/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestPredicateBinding {
    private static final List<Expression.Operation> COMPARISONS = Arrays.asList(Expression.Operation.LT, Expression.Operation.LT_EQ, Expression.Operation.GT, Expression.Operation.GT_EQ, Expression.Operation.EQ, Expression.Operation.NOT_EQ);

    @Test
    public void testMultipleFields() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"z", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"y"), (Object)6);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(11);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)Expression.Operation.LT);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)bound.asLiteralPredicate().literal().value())).as("Should not alter literal value", new Object[0])).isEqualTo(6);
    }

    @Test
    public void testMissingField() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"missing"), (Object)6);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> unbound.bind(struct)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing' in struct:");
    }

    @Test
    public void testComparisonPredicateBinding() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        for (Expression.Operation op : COMPARISONS) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"x"), (Object)5);
            Expression expr = unbound.bind(struct);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
            Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)bound.asLiteralPredicate().literal().value())).as("Should not alter literal value", new Object[0])).isEqualTo(5);
            ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(14);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)op);
        }
    }

    @Test
    public void testPredicateBindingForStringPrefixComparisons() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"x", (Type)Types.StringType.get())});
        for (Expression.Operation op : Arrays.asList(Expression.Operation.STARTS_WITH, Expression.Operation.NOT_STARTS_WITH)) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"x"), (Object)"s");
            Expression expr = unbound.bind(struct);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
            Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
            ((AbstractStringAssert)Assertions.assertThat((String)String.valueOf(bound.asLiteralPredicate().literal().value())).as("Should not alter literal value", new Object[0])).isEqualTo("s");
            ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(17);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)op);
        }
    }

    @Test
    public void testLiteralConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        for (Expression.Operation op : COMPARISONS) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"d"), (Object)"12.40");
            Expression expr = unbound.bind(struct);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
            Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
            ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)((BigDecimal)bound.asLiteralPredicate().literal().value())).as("Should convert literal value to decimal", new Object[0])).isEqualTo((Object)new BigDecimal("12.40"));
            ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(15);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)op);
        }
    }

    @Test
    public void testInvalidConversions() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"f", (Type)Types.FloatType.get())});
        for (Expression.Operation op : COMPARISONS) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"f"), (Object)"12.40");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> unbound.bind(struct)).isInstanceOf(ValidationException.class)).hasMessage("Invalid value for conversion to type float: 12.40 (java.lang.String)");
        }
    }

    @Test
    public void testLongToIntegerConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"i", (Type)Types.IntegerType.get())});
        UnboundPredicate lt = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        ((ObjectAssert)Assertions.assertThat((Object)lt.bind(struct)).as("Less than above max should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate lteq = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        ((ObjectAssert)Assertions.assertThat((Object)lteq.bind(struct)).as("Less than or equal above max should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate gt = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        ((ObjectAssert)Assertions.assertThat((Object)gt.bind(struct)).as("Greater than below min should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate gteq = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        ((ObjectAssert)Assertions.assertThat((Object)gteq.bind(struct)).as("Greater than or equal below min should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate gtMax = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        ((ObjectAssert)Assertions.assertThat((Object)gtMax.bind(struct)).as("Greater than above max should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        UnboundPredicate gteqMax = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        ((ObjectAssert)Assertions.assertThat((Object)gteqMax.bind(struct)).as("Greater than or equal above max should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        UnboundPredicate ltMin = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        ((ObjectAssert)Assertions.assertThat((Object)ltMin.bind(struct)).as("Less than below min should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        UnboundPredicate lteqMin = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        ((ObjectAssert)Assertions.assertThat((Object)lteqMin.bind(struct)).as("Less than or equal below min should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        Expression ltExpr = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MAX_VALUE).bind(struct, true);
        BoundPredicate ltMax = TestHelpers.assertAndUnwrap(ltExpr);
        Assertions.assertThat((boolean)ltMax.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)ltMax.asLiteralPredicate().literal().value())).as("Should translate bound to Integer", new Object[0])).isEqualTo(Integer.MAX_VALUE);
        Expression lteqExpr = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MAX_VALUE).bind(struct);
        BoundPredicate lteqMax = TestHelpers.assertAndUnwrap(lteqExpr);
        Assertions.assertThat((boolean)lteqMax.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)lteqMax.asLiteralPredicate().literal().value())).as("Should translate bound to Integer", new Object[0])).isEqualTo(Integer.MAX_VALUE);
        Expression gtExpr = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MIN_VALUE).bind(struct);
        BoundPredicate gtMin = TestHelpers.assertAndUnwrap(gtExpr);
        Assertions.assertThat((boolean)gtMin.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)gtMin.asLiteralPredicate().literal().value())).as("Should translate bound to Integer", new Object[0])).isEqualTo(Integer.MIN_VALUE);
        Expression gteqExpr = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MIN_VALUE).bind(struct);
        BoundPredicate gteqMin = TestHelpers.assertAndUnwrap(gteqExpr);
        Assertions.assertThat((boolean)gteqMin.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)gteqMin.asLiteralPredicate().literal().value())).as("Should translate bound to Integer", new Object[0])).isEqualTo(Integer.MIN_VALUE);
    }

    @Test
    public void testDoubleToFloatConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"f", (Type)Types.FloatType.get())});
        UnboundPredicate lt = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)lt.bind(struct)).as("Less than above max should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate lteq = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)lteq.bind(struct)).as("Less than or equal above max should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate gt = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)gt.bind(struct)).as("Greater than below min should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate gteq = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)gteq.bind(struct)).as("Greater than or equal below min should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        UnboundPredicate gtMax = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)gtMax.bind(struct)).as("Greater than above max should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        UnboundPredicate gteqMax = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)gteqMax.bind(struct)).as("Greater than or equal above max should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        UnboundPredicate ltMin = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)ltMin.bind(struct)).as("Less than below min should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        UnboundPredicate lteqMin = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        ((ObjectAssert)Assertions.assertThat((Object)lteqMin.bind(struct)).as("Less than or equal below min should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        Expression ltExpr = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"f"), (Object)3.4028234663852886E38).bind(struct);
        BoundPredicate ltMax = TestHelpers.assertAndUnwrap(ltExpr);
        Assertions.assertThat((boolean)ltMax.isLiteralPredicate()).isTrue();
        ((AbstractFloatAssert)Assertions.assertThat((Float)((Float)ltMax.asLiteralPredicate().literal().value())).as("Should translate bound to Float", new Object[0])).isEqualTo(Float.MAX_VALUE);
        Expression lteqExpr = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)3.4028234663852886E38).bind(struct);
        BoundPredicate lteqMax = TestHelpers.assertAndUnwrap(lteqExpr);
        Assertions.assertThat((boolean)lteqMax.isLiteralPredicate()).isTrue();
        ((AbstractFloatAssert)Assertions.assertThat((Float)((Float)lteqMax.asLiteralPredicate().literal().value())).as("Should translate bound to Float", new Object[0])).isEqualTo(Float.MAX_VALUE);
        Expression gtExpr = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"f"), (Object)-3.4028234663852886E38).bind(struct);
        BoundPredicate gtMin = TestHelpers.assertAndUnwrap(gtExpr);
        Assertions.assertThat((boolean)gtMin.isLiteralPredicate()).isTrue();
        ((AbstractFloatAssert)Assertions.assertThat((Float)((Float)gtMin.asLiteralPredicate().literal().value())).as("Should translate bound to Float", new Object[0])).isEqualTo(-3.4028235E38f);
        Expression gteqExpr = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)-3.4028234663852886E38).bind(struct);
        BoundPredicate gteqMin = TestHelpers.assertAndUnwrap(gteqExpr);
        Assertions.assertThat((boolean)gteqMin.isLiteralPredicate()).isTrue();
        ((AbstractFloatAssert)Assertions.assertThat((Float)((Float)gteqMin.asLiteralPredicate().literal().value())).as("Should translate bound to Float", new Object[0])).isEqualTo(-3.4028235E38f);
    }

    @Test
    public void testIsNull() {
        Types.StructType optional = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)19, (String)"s", (Type)Types.StringType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.IS_NULL, (UnboundTerm)Expressions.ref((String)"s"));
        Expression expr = unbound.bind(optional);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should use the same operation", new Object[0])).isEqualTo((Object)Expression.Operation.IS_NULL);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should use the correct field", new Object[0])).isEqualTo(19);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bound.isUnaryPredicate()).as("Should be a unary predicate", new Object[0])).isTrue();
        Types.StructType required = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"s", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)unbound.bind(required)).as("IsNull inclusive a required field should be alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
    }

    @Test
    public void testNotNull() {
        Types.StructType optional = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"s", (Type)Types.StringType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.NOT_NULL, (UnboundTerm)Expressions.ref((String)"s"));
        Expression expr = unbound.bind(optional);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should use the same operation", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_NULL);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should use the correct field", new Object[0])).isEqualTo(21);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bound.isUnaryPredicate()).as("Should be a unary predicate", new Object[0])).isTrue();
        Types.StructType required = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)unbound.bind(required)).as("NotNull inclusive a required field should be alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
    }

    @Test
    public void testIsNaN() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"d", (Type)Types.DoubleType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.IS_NAN, (UnboundTerm)Expressions.ref((String)"d"));
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should use the same operation", new Object[0])).isEqualTo((Object)Expression.Operation.IS_NAN);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should use the correct field", new Object[0])).isEqualTo(21);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bound.isUnaryPredicate()).as("Should be a unary predicate", new Object[0])).isTrue();
        struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"f", (Type)Types.FloatType.get())});
        unbound = new UnboundPredicate(Expression.Operation.IS_NAN, (UnboundTerm)Expressions.ref((String)"f"));
        expr = unbound.bind(struct);
        bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should use the same operation", new Object[0])).isEqualTo((Object)Expression.Operation.IS_NAN);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should use the correct field", new Object[0])).isEqualTo(21);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bound.isUnaryPredicate()).as("Should be a unary predicate", new Object[0])).isTrue();
        Types.StructType strStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"s", (Type)Types.StringType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new UnboundPredicate(Expression.Operation.IS_NAN, (UnboundTerm)Expressions.ref((String)"s")).bind(strStruct)).isInstanceOf(ValidationException.class)).hasMessage("IsNaN cannot be used with a non-floating-point column");
    }

    @Test
    public void testNotNaN() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"d", (Type)Types.DoubleType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.NOT_NAN, (UnboundTerm)Expressions.ref((String)"d"));
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should use the same operation", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_NAN);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should use the correct field", new Object[0])).isEqualTo(21);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bound.isUnaryPredicate()).as("Should be a unary predicate", new Object[0])).isTrue();
        struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"f", (Type)Types.FloatType.get())});
        unbound = new UnboundPredicate(Expression.Operation.NOT_NAN, (UnboundTerm)Expressions.ref((String)"f"));
        expr = unbound.bind(struct);
        bound = TestHelpers.assertAndUnwrap(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should use the same operation", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_NAN);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should use the correct field", new Object[0])).isEqualTo(21);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bound.isUnaryPredicate()).as("Should be a unary predicate", new Object[0])).isTrue();
        Types.StructType strStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"s", (Type)Types.StringType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new UnboundPredicate(Expression.Operation.NOT_NAN, (UnboundTerm)Expressions.ref((String)"s")).bind(strStruct)).isInstanceOf(ValidationException.class)).hasMessage("NotNaN cannot be used with a non-floating-point column");
    }

    @Test
    public void testInPredicateBinding() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"z", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"y", (Object[])new Integer[]{6, 7, 11});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(11);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the IN operation", new Object[0])).isEqualTo((Object)Expression.Operation.IN);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new Integer[2])).as("Should not alter literal set values", new Object[0])).isEqualTo((Object)new Integer[]{6, 7, 11});
    }

    @Test
    public void testInPredicateBindingConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.in((String)"d", (Object[])new String[]{"12.40", "1.23", "99.99", "1.23"});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new BigDecimal[2])).as("Should convert literal set values to decimal", new Object[0])).isEqualTo((Object)new BigDecimal[]{new BigDecimal("1.23"), new BigDecimal("12.40"), new BigDecimal("99.99")});
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(15);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the IN operation", new Object[0])).isEqualTo((Object)Expression.Operation.IN);
    }

    @Test
    public void testInToEqPredicate() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"x", (Object[])new Integer[]{5});
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)unbound.op()).as("Should create an IN predicate with a single item", new Object[0])).isEqualTo((Object)Expression.Operation.IN);
        ((ListAssert)Assertions.assertThat((List)unbound.literals()).as("Should create an IN predicate with a single item", new Object[0])).hasSize(1);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)bound.asLiteralPredicate().literal().value())).as("Should not alter literal value", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(14);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should change the operation from IN to EQ", new Object[0])).isEqualTo((Object)Expression.Operation.EQ);
    }

    @Test
    public void testInPredicateBindingConversionToEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"x", (Object[])new Long[]{5L, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)op).as("Should create an IN unbound predicate", new Object[0])).isEqualTo((Object)Expression.Operation.IN);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)bound.asLiteralPredicate().literal().value())).as("Should remove aboveMax literal value", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(14);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should change the IN operation to EQ", new Object[0])).isEqualTo((Object)Expression.Operation.EQ);
    }

    @Test
    public void testInPredicateBindingConversionDedupToEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.in((String)"d", (Object[])new Double[]{12.4, 12.401, 12.402});
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)unbound.op()).as("Should create an IN unbound predicate", new Object[0])).isEqualTo((Object)Expression.Operation.IN);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)((BigDecimal)bound.asLiteralPredicate().literal().value())).as("Should convert literal set values to a single decimal", new Object[0])).isEqualTo((Object)new BigDecimal("12.40"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(15);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should change the IN operation to EQ", new Object[0])).isEqualTo((Object)Expression.Operation.EQ);
    }

    @Test
    public void testInPredicateBindingConversionToExpression() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"x", (Object[])new Long[]{0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)op).as("Should create an IN predicate", new Object[0])).isEqualTo((Object)Expression.Operation.IN);
        Expression expr = unbound.bind(struct);
        ((ObjectAssert)Assertions.assertThat((Object)expr).as("Should change IN to alwaysFalse expression", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
    }

    @Test
    public void testNotInPredicateBinding() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"z", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"y", (Object[])new Integer[]{6, 7, 11});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(11);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the NOT_IN operation", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_IN);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new Integer[2])).as("Should not alter literal set values", new Object[0])).isEqualTo((Object)new Integer[]{6, 7, 11});
    }

    @Test
    public void testNotInPredicateBindingConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.notIn((String)"d", (Object[])new String[]{"12.40", "1.23", "99.99", "1.23"});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new BigDecimal[2])).as("Should convert literal set values to decimal", new Object[0])).isEqualTo((Object)new BigDecimal[]{new BigDecimal("1.23"), new BigDecimal("12.40"), new BigDecimal("99.99")});
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(15);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the NOT_IN operation", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_IN);
    }

    @Test
    public void testNotInToNotEqPredicate() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"x", (Object[])new Integer[]{5});
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)unbound.op()).as("Should create a NOT_IN predicate with a single item", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_IN);
        ((ListAssert)Assertions.assertThat((List)unbound.literals()).as("Should create a NOT_IN predicate with a single item", new Object[0])).hasSize(1);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)bound.asLiteralPredicate().literal().value())).as("Should not alter literal value", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(14);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should change the operation from NOT_IN to NOT_EQ", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_EQ);
    }

    @Test
    public void testNotInPredicateBindingConversionToNotEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"x", (Object[])new Long[]{5L, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)op).as("Should create a NOT_IN unbound predicate", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_IN);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)bound.asLiteralPredicate().literal().value())).as("Should remove aboveMax literal value", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(14);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should change the NOT_IN operation to NOT_EQ", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_EQ);
    }

    @Test
    public void testNotInPredicateBindingConversionDedupToNotEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.notIn((String)"d", (Object[])new Double[]{12.4, 12.401, 12.402});
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)unbound.op()).as("Should create a NOT_IN unbound predicate", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_IN);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assertions.assertThat((boolean)bound.isLiteralPredicate()).isTrue();
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)((BigDecimal)bound.asLiteralPredicate().literal().value())).as("Should convert literal set values to a single decimal", new Object[0])).isEqualTo((Object)new BigDecimal("12.40"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(15);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should change the NOT_IN operation to NOT_EQ", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_EQ);
    }

    @Test
    public void testNotInPredicateBindingConversionToExpression() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"x", (Object[])new Long[]{0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)op).as("Should create an NOT_IN predicate", new Object[0])).isEqualTo((Object)Expression.Operation.NOT_IN);
        Expression expr = unbound.bind(struct);
        ((ObjectAssert)Assertions.assertThat((Object)expr).as("Should change NOT_IN to alwaysTrue expression", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
    }
}

