/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestStringLiteralConversions {
    @Test
    public void testStringToStringLiteral() {
        Literal string = Literal.of((CharSequence)"abc");
        ((ObjectAssert)Assertions.assertThat((Object)string.to((Type)Types.StringType.get())).as("Should return same instance", new Object[0])).isSameAs((Object)string);
    }

    @Test
    public void testStringToDateLiteral() {
        Literal dateStr = Literal.of((CharSequence)"2017-08-18");
        Literal date = dateStr.to((Type)Types.DateType.get());
        Schema avroSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TimeConversions.DateConversion avroConversion = new TimeConversions.DateConversion();
        int avroValue = avroConversion.toInt(LocalDate.of(2017, 8, 18), avroSchema, avroSchema.getLogicalType());
        Assertions.assertThat((int)((Integer)date.value())).isEqualTo(avroValue);
    }

    @Test
    public void testNegativeStringToDateLiteral() {
        Literal dateStr = Literal.of((CharSequence)"1969-12-30");
        Literal date = dateStr.to((Type)Types.DateType.get());
        Schema avroSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TimeConversions.DateConversion avroConversion = new TimeConversions.DateConversion();
        int avroValue = avroConversion.toInt(LocalDate.of(1969, 12, 30), avroSchema, avroSchema.getLogicalType());
        ((AbstractIntegerAssert)((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)date.value())).as("Date should be -2", new Object[0])).isEqualTo(-2).as("Date should match", new Object[0])).isEqualTo(avroValue);
    }

    @Test
    public void testStringToTimeLiteral() {
        Schema avroSchema = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Literal timeStr = Literal.of((CharSequence)"14:21:01.919");
        Literal time = timeStr.to((Type)Types.TimeType.get());
        long avroValue = new TimeConversions.TimeMicrosConversion().toLong(LocalTime.of(14, 21, 1, 919000000), avroSchema, avroSchema.getLogicalType());
        Assertions.assertThat((long)((Long)time.value())).isEqualTo(avroValue);
    }

    @Test
    public void testStringToTimestampLiteral() {
        Schema avroSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TimeConversions.TimestampMicrosConversion avroConversion = new TimeConversions.TimestampMicrosConversion();
        Literal timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919+00:00");
        Literal timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        long avroValue = avroConversion.toLong(LocalDateTime.of(2017, 8, 18, 14, 21, 1, 919000000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        Assertions.assertThat((long)((Long)timestamp.value())).isEqualTo(avroValue);
        timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919");
        timestamp = timestampStr.to((Type)Types.TimestampType.withoutZone());
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(avroValue);
        timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919-07:00");
        timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        avroValue = avroConversion.toLong(LocalDateTime.of(2017, 8, 18, 21, 21, 1, 919000000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(avroValue);
    }

    @Test
    public void testStringToTimestampLiteralWithMicrosecondPrecisionFromNanoseconds() {
        Schema avroSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TimeConversions.TimestampMicrosConversion avroConversion = new TimeConversions.TimestampMicrosConversion();
        Literal timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.123456789");
        Literal timestamp = timestampStr.to((Type)Types.TimestampType.withoutZone());
        long avroValue = avroConversion.toLong(LocalDateTime.of(2017, 8, 18, 14, 21, 1, 123456000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(avroValue);
    }

    @Test
    public void testStringToTimestampLiteralWithNanosecondPrecisionFromNanoseconds() {
        Literal timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.123456789");
        Literal timestamp = timestampStr.to((Type)Types.TimestampNanoType.withoutZone());
        long expected = 1503066061123456789L;
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(expected);
        Schema avroSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TimeConversions.TimestampMicrosConversion avroConversion = new TimeConversions.TimestampMicrosConversion();
        long avroValue = avroConversion.toLong(LocalDateTime.of(2017, 8, 18, 14, 21, 1, 123456000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value() - avroValue * 1000L)).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(789L);
    }

    @Test
    public void testNegativeStringToTimestampLiteral() {
        Schema avroSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TimeConversions.TimestampMicrosConversion avroConversion = new TimeConversions.TimestampMicrosConversion();
        Literal timestampStr = Literal.of((CharSequence)"1969-12-31T23:59:58.999999+00:00");
        Literal timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        long avroValue = avroConversion.toLong(LocalDateTime.of(1969, 12, 31, 23, 59, 58, 999999000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        ((AbstractLongAssert)((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp should match", new Object[0])).isEqualTo(avroValue).as("Timestamp should be -1_000_001", new Object[0])).isEqualTo(-1000001L);
        timestampStr = Literal.of((CharSequence)"1969-12-31T23:59:58.999999");
        timestamp = timestampStr.to((Type)Types.TimestampType.withoutZone());
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(avroValue);
        timestampStr = Literal.of((CharSequence)"1969-12-31T16:59:58.999999-07:00");
        timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        avroValue = avroConversion.toLong(LocalDateTime.of(1969, 12, 31, 23, 59, 58, 999999000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        ((AbstractLongAssert)((AbstractLongAssert)Assertions.assertThat((long)((Long)timestamp.value())).as("Timestamp without zone should match UTC", new Object[0])).isEqualTo(avroValue).as("Timestamp without zone should be -1_000_001", new Object[0])).isEqualTo(-1000001L);
    }

    @Test
    public void testTimestampWithZoneWithoutZoneInLiteral() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Literal.of((CharSequence)"2017-08-18T14:21:01.919").to((Type)Types.TimestampType.withZone())).isInstanceOf(DateTimeException.class)).hasMessageContaining("could not be parsed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Literal.of((CharSequence)"2017-08-18T14:21:01.919123456").to((Type)Types.TimestampNanoType.withZone())).isInstanceOf(DateTimeException.class)).hasMessageContaining("could not be parsed");
    }

    @Test
    public void testTimestampWithoutZoneWithZoneInLiteral() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Literal.of((CharSequence)"2017-08-18T14:21:01.919+07:00").to((Type)Types.TimestampType.withoutZone())).isInstanceOf(DateTimeException.class)).hasMessageContaining("could not be parsed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Literal.of((CharSequence)"2017-08-18T14:21:01.919123456+07:00").to((Type)Types.TimestampNanoType.withoutZone())).isInstanceOf(DateTimeException.class)).hasMessageContaining("could not be parsed");
    }

    @Test
    public void testStringToUUIDLiteral() {
        UUID expected = UUID.randomUUID();
        Literal uuidStr = Literal.of((CharSequence)expected.toString());
        Literal uuid = uuidStr.to((Type)Types.UUIDType.get());
        Assertions.assertThat((Comparable)((UUID)uuid.value())).isEqualTo((Object)expected);
    }

    @Test
    public void testStringToDecimalLiteral() {
        BigDecimal expected = new BigDecimal("34.560");
        Literal decimalStr = Literal.of((CharSequence)"34.560");
        IntStream.range(0, 10).forEach(scale -> {
            Literal decimal = decimalStr.to((Type)Types.DecimalType.of((int)9, (int)scale));
            Assertions.assertThat((int)((BigDecimal)decimal.value()).scale()).isEqualTo(3);
            Assertions.assertThat((BigDecimal)((BigDecimal)decimal.value())).isEqualTo((Object)expected);
        });
    }
}

