/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.Iterator;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.ClosingIterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestClosingIterator {
    @Test
    public void testEmptyIterator() {
        CloseableIterator underlying = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        ClosingIterator closingIterator = new ClosingIterator(underlying);
        Assertions.assertThat((Iterator)closingIterator).isExhausted();
    }

    @Test
    public void testHasNextAndNext() {
        CloseableIterator underlying = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        Mockito.when((Object)underlying.hasNext()).thenReturn((Object)true);
        Mockito.when((Object)((String)underlying.next())).thenReturn((Object)"hello");
        ClosingIterator closingIterator = new ClosingIterator(underlying);
        Assertions.assertThat((Iterator)closingIterator).hasNext();
        Assertions.assertThat((String)((String)closingIterator.next())).isEqualTo("hello");
    }

    @Test
    public void testUnderlyingIteratorCloseWhenElementsAreExhausted() throws Exception {
        CloseableIterator underlying = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        Mockito.when((Object)underlying.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)((String)underlying.next())).thenReturn((Object)"hello");
        ClosingIterator closingIterator = new ClosingIterator(underlying);
        Assertions.assertThat((Iterator)closingIterator).hasNext();
        Assertions.assertThat((String)((String)closingIterator.next())).isEqualTo("hello");
        Assertions.assertThat((Iterator)closingIterator).isExhausted();
        ((CloseableIterator)Mockito.verify((Object)underlying, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseCalledOnceForMultipleHasNextCalls() throws Exception {
        CloseableIterator underlying = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        ClosingIterator closingIterator = new ClosingIterator(underlying);
        Assertions.assertThat((Iterator)closingIterator).isExhausted();
        ((CloseableIterator)Mockito.verify((Object)underlying, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void transformNullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterator.transform((CloseableIterator)CloseableIterator.empty(), null)).isInstanceOf(NullPointerException.class)).hasMessage("Invalid transform: null");
    }
}

