/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.metrics.FixedReservoirHistogram;
import org.apache.iceberg.metrics.Histogram;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFixedReservoirHistogram {
    @Test
    public void emptyHistogram() {
        FixedReservoirHistogram histogram = new FixedReservoirHistogram(100);
        Assertions.assertThat((int)histogram.count()).isEqualTo(0);
        Histogram.Statistics statistics = histogram.statistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(0);
        Assertions.assertThat((double)statistics.mean()).isEqualTo(0.0);
        Assertions.assertThat((double)statistics.stdDev()).isEqualTo(0.0);
        Assertions.assertThat((long)statistics.max()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.min()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.percentile(0.5)).isEqualTo(0L);
        Assertions.assertThat((long)statistics.percentile(0.99)).isEqualTo(0L);
    }

    @Test
    public void singleObservation() {
        FixedReservoirHistogram histogram = new FixedReservoirHistogram(100);
        histogram.update(123L);
        Assertions.assertThat((int)histogram.count()).isEqualTo(1);
        Histogram.Statistics statistics = histogram.statistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(1);
        Assertions.assertThat((double)statistics.mean()).isEqualTo(123.0);
        Assertions.assertThat((double)statistics.stdDev()).isEqualTo(0.0);
        Assertions.assertThat((long)statistics.max()).isEqualTo(123L);
        Assertions.assertThat((long)statistics.min()).isEqualTo(123L);
        Assertions.assertThat((long)statistics.percentile(0.5)).isEqualTo(123L);
        Assertions.assertThat((long)statistics.percentile(0.99)).isEqualTo(123L);
    }

    @Test
    public void minMaxPercentilePoints() {
        int reservoirSize = 100;
        FixedReservoirHistogram histogram = new FixedReservoirHistogram(reservoirSize);
        for (int i = 0; i < reservoirSize; ++i) {
            histogram.update((long)i);
        }
        Histogram.Statistics statistics = histogram.statistics();
        Assertions.assertThat((long)statistics.percentile(0.0)).isEqualTo(0L);
        Assertions.assertThat((long)statistics.percentile(1.0)).isEqualTo(99L);
    }

    @Test
    public void invalidPercentilePoints() {
        int reservoirSize = 100;
        FixedReservoirHistogram histogram = new FixedReservoirHistogram(reservoirSize);
        for (int i = 0; i < reservoirSize; ++i) {
            histogram.update((long)i);
        }
        Histogram.Statistics statistics = histogram.statistics();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> statistics.percentile(-0.1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Percentile point cannot be outside the range of [0.0 - 1.0]: -0.1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> statistics.percentile(1.1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Percentile point cannot be outside the range of [0.0 - 1.0]: 1.1");
    }

    @Test
    public void testMultipleThreadWriters() throws InterruptedException {
        int threads = 10;
        int samplesPerThread = 100;
        int totalSamples = threads * samplesPerThread;
        FixedReservoirHistogram histogram = new FixedReservoirHistogram(totalSamples);
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        List futures = IntStream.range(0, threads).mapToObj(threadIndex -> executor.submit(() -> {
            try {
                barrier.await(30L, TimeUnit.SECONDS);
                for (int i = 1; i <= 100; ++i) {
                    histogram.update((long)threadIndex * (long)samplesPerThread + (long)i);
                }
                return threadIndex;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })).collect(Collectors.toList());
        futures.stream().map(f -> {
            try {
                return (Integer)f.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        executor.shutdownNow();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        Histogram.Statistics statistics = histogram.statistics();
        Assertions.assertThat((int)histogram.count()).isEqualTo(totalSamples);
        Assertions.assertThat((int)statistics.size()).isEqualTo(totalSamples);
        Assertions.assertThat((double)statistics.mean()).isEqualTo(500.5);
        Assertions.assertThat((double)statistics.stdDev()).isCloseTo(288.67499, Assertions.withinPercentage((Double)0.001));
        Assertions.assertThat((long)statistics.max()).isEqualTo(1000L);
        Assertions.assertThat((long)statistics.min()).isEqualTo(1L);
        Assertions.assertThat((long)statistics.percentile(0.5)).isEqualTo(500L);
        Assertions.assertThat((long)statistics.percentile(0.75)).isEqualTo(750L);
        Assertions.assertThat((long)statistics.percentile(0.9)).isEqualTo(900L);
        Assertions.assertThat((long)statistics.percentile(0.95)).isEqualTo(950L);
        Assertions.assertThat((long)statistics.percentile(0.99)).isEqualTo(990L);
        Assertions.assertThat((long)statistics.percentile(0.999)).isEqualTo(999L);
    }
}

