/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Days;
import org.apache.iceberg.transforms.Hours;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDates {
    @Test
    public void testSatisfiesOrderOfDates() {
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Dates.MONTH)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
    }

    @Test
    public void testSatisfiesOrderOfTimestamps() {
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
    }

    @Test
    public void testSatisfiesOrderOfTimestampNanos() {
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
    }

    @Test
    public void testSatisfiesOrderOfTimeTransforms() {
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Dates.DAY.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Dates.MONTH.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Months.get())).isFalse();
        Assertions.assertThat((boolean)Dates.YEAR.satisfiesOrderOf((Transform)Years.get())).isTrue();
    }

    @Test
    public void testDeprecatedDateTransform() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"2017-12-01").to((Type)type);
        Literal pd = Literal.of((CharSequence)"1970-01-01").to((Type)type);
        Literal nd = Literal.of((CharSequence)"1969-12-31").to((Type)type);
        Transform years = Transforms.year((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Integer)date.value())))).as("Should produce 2017 - 1970 = 47", new Object[0])).isEqualTo(47);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Integer)pd.value())))).as("Should produce 1970 - 1970 = 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Integer)nd.value())))).as("Should produce 1969 - 1970 = -1", new Object[0])).isEqualTo(-1);
        Transform months = Transforms.month((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.apply((Object)((Integer)date.value())))).as("Should produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo(575);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.apply((Object)((Integer)pd.value())))).as("Should produce 0 * 12 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)months.apply((Object)((Integer)nd.value())))).isEqualTo(-1);
        Transform days = Transforms.day((Type)type);
        Assertions.assertThat((int)((Integer)days.apply((Object)((Integer)date.value())))).isEqualTo(17501);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.apply((Object)((Integer)pd.value())))).as("Should produce 0 * 365 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)days.apply((Object)((Integer)nd.value())))).isEqualTo(-1);
    }

    @Test
    public void testDateTransform() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"2017-12-01").to((Type)type);
        Literal pd = Literal.of((CharSequence)"1970-01-01").to((Type)type);
        Literal nd = Literal.of((CharSequence)"1969-12-31").to((Type)type);
        Transform years = Transforms.year();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Integer)date.value())))).as("Should produce 2017 - 1970 = 47", new Object[0])).isEqualTo(47);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Integer)pd.value())))).as("Should produce 1970 - 1970 = 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Integer)nd.value())))).as("Should produce 1969 - 1970 = -1", new Object[0])).isEqualTo(-1);
        Transform months = Transforms.month();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Integer)date.value())))).as("Should produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo(575);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Integer)pd.value())))).as("Should produce 0 * 12 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Integer)nd.value())))).isEqualTo(-1);
        Transform days = Transforms.day();
        Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Integer)date.value())))).isEqualTo(17501);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Integer)pd.value())))).as("Should produce 0 * 365 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Integer)nd.value())))).isEqualTo(-1);
    }

    @Test
    public void testDateToHumanString() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"2017-12-01").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("2017");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("2017-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("2017-12-01");
    }

    @Test
    public void testNegativeDateToHumanString() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1969-12-30").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969-12-30");
    }

    @Test
    public void testDateToHumanStringLowerBound() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1970-01-01").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1970");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1970-01");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1970-01-01");
    }

    @Test
    public void testNegativeDateToHumanStringLowerBound() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1969-01-01").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969-01");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969-01-01");
    }

    @Test
    public void testNegativeDateToHumanStringUpperBound() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1969-12-31").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value()))))).isEqualTo("1969-12-31");
    }

    @Test
    public void testNullHumanString() {
        Types.DateType type = Types.DateType.get();
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.year().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.month().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.day().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
    }

    @Test
    public void testDatesReturnType() {
        Types.DateType type = Types.DateType.get();
        Transform year = Transforms.year();
        Type yearResultType = year.getResultType((Type)type);
        Assertions.assertThat((Object)yearResultType).isEqualTo((Object)Types.IntegerType.get());
        Transform month = Transforms.month();
        Type monthResultType = month.getResultType((Type)type);
        Assertions.assertThat((Object)monthResultType).isEqualTo((Object)Types.IntegerType.get());
        Transform day = Transforms.day();
        Type dayResultType = day.getResultType((Type)type);
        Assertions.assertThat((Object)dayResultType).isEqualTo((Object)Types.DateType.get());
    }

    @Test
    public void testUnknownUnsupportedYear() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Transforms.year((Type)Types.UnknownType.get())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type: unknown");
        Transform year = Transforms.year();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> year.bind((Type)Types.UnknownType.get())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type: unknown");
        Assertions.assertThat((boolean)year.canTransform((Type)Types.UnknownType.get())).isFalse();
    }

    @Test
    public void testUnknownUnsupportedMonth() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Transforms.month((Type)Types.UnknownType.get())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type: unknown");
        Transform month = Transforms.month();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> month.bind((Type)Types.UnknownType.get())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type: unknown");
        Assertions.assertThat((boolean)month.canTransform((Type)Types.UnknownType.get())).isFalse();
    }

    @Test
    public void testUnknownUnsupportedDay() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Transforms.day((Type)Types.UnknownType.get())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type: unknown");
        Transform day = Transforms.day();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> day.bind((Type)Types.UnknownType.get())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type: unknown");
        Assertions.assertThat((boolean)day.canTransform((Type)Types.UnknownType.get())).isFalse();
    }
}

