/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBinaryComparator {
    @Test
    public void testBinaryUnsignedComparator() {
        ByteBuffer b1 = ByteBuffer.wrap(new byte[]{1, 1, 2});
        ByteBuffer b2 = ByteBuffer.wrap(new byte[]{1, -1, 2});
        Comparator cmp = Literal.of((ByteBuffer)b1).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(b1, b2)).as("Negative bytes should sort after positive bytes", new Object[0])).isLessThan(0);
    }

    @Test
    public void testFixedUnsignedComparator() {
        ByteBuffer b1 = ByteBuffer.wrap(new byte[]{1, 1, 2});
        ByteBuffer b2 = ByteBuffer.wrap(new byte[]{1, -1, 2});
        Literal fixedLit = Literal.of((ByteBuffer)b1).to((Type)Types.FixedType.ofLength((int)3));
        Comparator cmp = fixedLit.comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(b1, b2)).as("Negative bytes should sort after positive bytes", new Object[0])).isLessThan(0);
    }

    @Test
    public void testNullHandling() {
        ByteBuffer buf = ByteBuffer.allocate(0);
        Comparator cmp = Literal.of((ByteBuffer)buf).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(null, buf)).as("null comes before non-null", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(buf, null)).as("null comes before non-null", new Object[0])).isGreaterThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(null, null)).as("null equals null", new Object[0])).isZero();
    }
}

