/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDateTimeUtil {
    @Test
    public void nanosToMicros() {
        Assertions.assertThat((long)DateTimeUtil.nanosToMicros((long)1510871468000001001L)).isEqualTo(1510871468000001L);
        Assertions.assertThat((long)DateTimeUtil.nanosToMicros((long)-1510871468000001001L)).isEqualTo(-1510871468000002L);
    }

    @Test
    public void microsToNanos() {
        Assertions.assertThat((long)DateTimeUtil.microsToNanos((long)1510871468000001L)).isEqualTo(1510871468000001000L);
        Assertions.assertThat((long)DateTimeUtil.microsToNanos((long)-1510871468000001L)).isEqualTo(-1510871468000001000L);
    }

    @Test
    public void isoTimestampToNanos() {
        Assertions.assertThat((long)DateTimeUtil.isoTimestampToNanos((CharSequence)"2017-11-16T22:31:08.000001001")).isEqualTo(1510871468000001001L);
        Assertions.assertThat((long)DateTimeUtil.isoTimestampToNanos((CharSequence)"1922-02-15T01:28:51.999998999")).isEqualTo(-1510871468000001001L);
    }

    @Test
    public void isoTimestamptzToNanos() {
        Assertions.assertThat((long)DateTimeUtil.isoTimestamptzToNanos((CharSequence)"2017-11-16T14:31:08.000001001-08:00")).isEqualTo(1510871468000001001L);
        Assertions.assertThat((long)DateTimeUtil.isoTimestamptzToNanos((CharSequence)"1922-02-15T01:28:51.999998999+00:00")).isEqualTo(-1510871468000001001L);
    }

    @Test
    public void convertNanos() {
        Assertions.assertThat((String)Transforms.identity().toHumanString((Type)Types.TimestampNanoType.withoutZone(), (Object)1510871468000001001L)).isEqualTo("2017-11-16T22:31:08.000001001");
        Assertions.assertThat((int)DateTimeUtil.nanosToYears((long)1510871468000001001L)).isEqualTo(47);
        Assertions.assertThat((String)Transforms.year().toHumanString((Type)Types.IntegerType.get(), (Object)47)).isEqualTo("2017");
        Assertions.assertThat((int)DateTimeUtil.nanosToMonths((long)1510871468000001001L)).isEqualTo(574);
        Assertions.assertThat((String)Transforms.month().toHumanString((Type)Types.IntegerType.get(), (Object)574)).isEqualTo("2017-11");
        Assertions.assertThat((int)DateTimeUtil.nanosToDays((long)1510871468000001001L)).isEqualTo(17486);
        Assertions.assertThat((String)Transforms.day().toHumanString((Type)Types.IntegerType.get(), (Object)17486)).isEqualTo("2017-11-16");
        Assertions.assertThat((int)DateTimeUtil.nanosToHours((long)1510871468000001001L)).isEqualTo(419686);
        Assertions.assertThat((String)Transforms.hour().toHumanString((Type)Types.IntegerType.get(), (Object)419686)).isEqualTo("2017-11-16-22");
    }

    @Test
    public void convertNanosNegative() {
        Assertions.assertThat((String)Transforms.identity().toHumanString((Type)Types.TimestampNanoType.withZone(), (Object)-1510871468000001001L)).isEqualTo("1922-02-15T01:28:51.999998999+00:00");
        Assertions.assertThat((int)DateTimeUtil.nanosToYears((long)-1510871468000001001L)).isEqualTo(-48);
        Assertions.assertThat((String)Transforms.year().toHumanString((Type)Types.IntegerType.get(), (Object)47)).isEqualTo("2017");
        Assertions.assertThat((int)DateTimeUtil.nanosToMonths((long)-1510871468000001001L)).isEqualTo(-575);
        Assertions.assertThat((String)Transforms.month().toHumanString((Type)Types.IntegerType.get(), (Object)574)).isEqualTo("2017-11");
        Assertions.assertThat((int)DateTimeUtil.nanosToDays((long)-1510871468000001001L)).isEqualTo(-17487);
        Assertions.assertThat((String)Transforms.day().toHumanString((Type)Types.IntegerType.get(), (Object)17486)).isEqualTo("2017-11-16");
        Assertions.assertThat((int)DateTimeUtil.nanosToHours((long)-1510871468000001001L)).isEqualTo(-419687);
        Assertions.assertThat((String)Transforms.hour().toHumanString((Type)Types.IntegerType.get(), (Object)419686)).isEqualTo("2017-11-16-22");
    }
}

