/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.FieldSource;

class TestFileFormat {
    private static final Object[][] FILE_NAMES = new Object[][]{{"file.puffin", FileFormat.PUFFIN}, {"dir/file.puffin", FileFormat.PUFFIN}, {"file.orc", FileFormat.ORC}, {"dir/file.orc", FileFormat.ORC}, {"file.parquet", FileFormat.PARQUET}, {"dir/file.parquet", FileFormat.PARQUET}, {"file.avro", FileFormat.AVRO}, {"dir/file.avro", FileFormat.AVRO}, {"v1.metadata.json", FileFormat.METADATA}, {"dir/v1.metadata.json", FileFormat.METADATA}, {"x.puffin", FileFormat.PUFFIN}, {"x.orc", FileFormat.ORC}, {"x.parquet", FileFormat.PARQUET}, {"x.avro", FileFormat.AVRO}, {"x.metadata.json", FileFormat.METADATA}, {"file.csv", null}, {"dir/file.csv", null}, {"file", null}, {"dir", null}, {"", null}, {" ", null}, {null, null}};

    TestFileFormat() {
    }

    @ParameterizedTest
    @FieldSource(value={"FILE_NAMES"})
    void fromFileName(String fileName, FileFormat expected) {
        FileFormat actual = FileFormat.fromFileName((CharSequence)fileName);
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
    }
}

