/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.IcebergBuild;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestIcebergBuild {
    @Test
    public void testFullVersion() {
        ((AbstractStringAssert)Assertions.assertThat((String)IcebergBuild.fullVersion()).as("Should build full version from version and commit ID", new Object[0])).isEqualTo("Apache Iceberg " + IcebergBuild.version() + " (commit " + IcebergBuild.gitCommitId() + ")");
    }

    @Test
    public void testVersionNotUnspecified() {
        Assertions.assertThat((String)IcebergBuild.version()).isNotEqualTo((Object)"unspecified");
    }

    @Test
    public void testVersionMatchesSystemProperty() {
        Assumptions.assumeThat((String)System.getProperty("project.version")).isNotNull();
        Assertions.assertThat((String)IcebergBuild.version()).isEqualTo(System.getProperty("project.version")).as("IcebergBuild.version() should match system property project.version", new Object[0]);
    }

    @Test
    public void testVersionMatchesFile() throws IOException {
        Path versionPath = Paths.get("../version.txt", new String[0]).toAbsolutePath();
        Assumptions.assumeThat((boolean)Files.exists(versionPath, new LinkOption[0])).isTrue();
        String versionText = Files.readString(versionPath).trim();
        Assertions.assertThat((String)IcebergBuild.version()).isEqualTo(versionText).as("IcebergBuild.version() should match version file", new Object[0]);
    }

    @Test
    public void testVersion() {
        ((AbstractStringAssert)Assertions.assertThat((String)IcebergBuild.version()).as("Should not use unknown version", new Object[0])).isNotEqualTo((Object)"unknown");
    }

    @Test
    public void testGitCommitId() {
        ((AbstractStringAssert)Assertions.assertThat((String)IcebergBuild.gitCommitId()).as("Should not use unknown commit ID", new Object[0])).isNotEqualTo((Object)"unknown");
        ((MatcherAssert)Assertions.assertThat((Matcher)Pattern.compile("[0-9a-f]{40}").matcher(IcebergBuild.gitCommitId().toLowerCase(Locale.ROOT))).as("Should be a hexadecimal string of 20 bytes", new Object[0])).matches();
    }
}

