/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.EdgeAlgorithm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.FieldSource;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchema {
    private static final List<Type> TEST_TYPES = ImmutableList.of((Object)Types.TimestampNanoType.withoutZone(), (Object)Types.TimestampNanoType.withZone(), (Object)Types.VariantType.get(), (Object)Types.GeometryType.crs84(), (Object)Types.GeometryType.of((String)"srid:3857"), (Object)Types.GeographyType.crs84(), (Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
    private static final Schema INITIAL_DEFAULT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((String)"has_default").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault(Literal.of((CharSequence)"--")).withWriteDefault(Literal.of((CharSequence)"--")).build()});
    private static final Schema WRITE_DEFAULT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((String)"has_default").withId(2).ofType((Type)Types.StringType.get()).withWriteDefault(Literal.of((CharSequence)"--")).build()});
    private static int[] unsupportedInitialDefault = IntStream.range(1, 3).toArray();
    private static int[] supportedInitialDefault = IntStream.rangeClosed(3, 3).toArray();

    private Schema generateTypeSchema(Type type) {
        return new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"top", (Type)type), Types.NestedField.optional((int)3, (String)"arr", (Type)Types.ListType.ofRequired((int)4, (Type)type)), Types.NestedField.required((int)5, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"inner_op", (Type)type), Types.NestedField.required((int)7, (String)"inner_req", (Type)type), Types.NestedField.optional((int)8, (String)"struct_arr", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)9, (String)"deep", (Type)type)}))}))});
    }

    private static Stream<Arguments> unsupportedTypes() {
        return TEST_TYPES.stream().flatMap(type -> IntStream.range(1, (Integer)Schema.MIN_FORMAT_VERSIONS.get(type.typeId())).mapToObj(unsupportedVersion -> Arguments.of((Object[])new Object[]{type, unsupportedVersion})));
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedTypes"})
    public void testUnsupportedTypes(Type type, int unsupportedVersion) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Schema.checkCompatibility((Schema)this.generateTypeSchema(type), (int)unsupportedVersion)).isInstanceOf(IllegalStateException.class)).hasMessage("Invalid schema for v%s:\n- Invalid type for top: %s is not supported until v%s\n- Invalid type for arr.element: %s is not supported until v%s\n- Invalid type for struct.inner_op: %s is not supported until v%s\n- Invalid type for struct.inner_req: %s is not supported until v%s\n- Invalid type for struct.struct_arr.deep: %s is not supported until v%s", new Object[]{unsupportedVersion, type, Schema.MIN_FORMAT_VERSIONS.get(type.typeId()), type, Schema.MIN_FORMAT_VERSIONS.get(type.typeId()), type, Schema.MIN_FORMAT_VERSIONS.get(type.typeId()), type, Schema.MIN_FORMAT_VERSIONS.get(type.typeId()), type, Schema.MIN_FORMAT_VERSIONS.get(type.typeId())});
    }

    private static Stream<Arguments> supportedTypes() {
        return TEST_TYPES.stream().flatMap(type -> IntStream.rangeClosed((Integer)Schema.MIN_FORMAT_VERSIONS.get(type.typeId()), 3).mapToObj(supportedVersion -> Arguments.of((Object[])new Object[]{type, supportedVersion})));
    }

    @Test
    public void testUnknownSupport() {
        Schema schemaWithUnknown = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"top", (Type)Types.UnknownType.get()), Types.NestedField.optional((int)3, (String)"arr", (Type)Types.ListType.ofOptional((int)4, (Type)Types.UnknownType.get())), Types.NestedField.required((int)5, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"inner_op", (Type)Types.UnknownType.get()), Types.NestedField.optional((int)7, (String)"inner_map", (Type)Types.MapType.ofOptional((int)8, (int)9, (Type)Types.StringType.get(), (Type)Types.UnknownType.get())), Types.NestedField.optional((int)10, (String)"struct_arr", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)11, (String)"deep", (Type)Types.UnknownType.get())}))}))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Schema.checkCompatibility((Schema)schemaWithUnknown, (int)2)).isInstanceOf(IllegalStateException.class)).hasMessage("Invalid schema for v%s:\n- Invalid type for top: %s is not supported until v%s\n- Invalid type for arr.element: %s is not supported until v%s\n- Invalid type for struct.inner_op: %s is not supported until v%s\n- Invalid type for struct.inner_map.value: %s is not supported until v%s\n- Invalid type for struct.struct_arr.deep: %s is not supported until v%s", new Object[]{2, Types.UnknownType.get(), Schema.MIN_FORMAT_VERSIONS.get(Type.TypeID.UNKNOWN), Types.UnknownType.get(), Schema.MIN_FORMAT_VERSIONS.get(Type.TypeID.UNKNOWN), Types.UnknownType.get(), Schema.MIN_FORMAT_VERSIONS.get(Type.TypeID.UNKNOWN), Types.UnknownType.get(), Schema.MIN_FORMAT_VERSIONS.get(Type.TypeID.UNKNOWN), Types.UnknownType.get(), Schema.MIN_FORMAT_VERSIONS.get(Type.TypeID.UNKNOWN)});
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)schemaWithUnknown, (int)3)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @MethodSource(value={"supportedTypes"})
    public void testTypeSupported(Type type, int supportedVersion) {
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)this.generateTypeSchema(type), (int)supportedVersion)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @FieldSource(value={"unsupportedInitialDefault"})
    public void testUnsupportedInitialDefault(int formatVersion) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Schema.checkCompatibility((Schema)INITIAL_DEFAULT_SCHEMA, (int)formatVersion)).isInstanceOf(IllegalStateException.class)).hasMessage("Invalid schema for v%s:\n- Invalid initial default for has_default: non-null default (--) is not supported until v3", new Object[]{formatVersion});
    }

    @ParameterizedTest
    @FieldSource(value={"supportedInitialDefault"})
    public void testSupportedInitialDefault(int formatVersion) {
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)INITIAL_DEFAULT_SCHEMA, (int)formatVersion)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @FieldSource(value={"org.apache.iceberg.TestHelpers#ALL_VERSIONS"})
    public void testSupportedWriteDefault(int formatVersion) {
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)WRITE_DEFAULT_SCHEMA, (int)formatVersion)).doesNotThrowAnyException();
    }
}

