/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import org.apache.iceberg.catalog.Namespace;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNamespace {
    @Test
    public void testWithNullAndEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create Namespace from null array");
        Assertions.assertThat((Object)Namespace.of((String[])new String[0])).isEqualTo((Object)Namespace.empty());
    }

    @Test
    public void testNamespace() {
        String[] levels = new String[]{"a", "b", "c", "d"};
        Namespace namespace = Namespace.of((String[])levels);
        Assertions.assertThat((Object)namespace).isNotNull();
        Assertions.assertThat((Object[])namespace.levels()).hasSize(4);
        Assertions.assertThat((Object)namespace).hasToString("a.b.c.d");
        for (int i = 0; i < levels.length; ++i) {
            Assertions.assertThat((String)namespace.level(i)).isEqualTo(levels[i]);
        }
    }

    @Test
    public void testWithNullInLevel() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"a", null, "b"})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create a namespace with a null level");
    }

    @Test
    public void testDisallowsNamespaceWithNullByte() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"ac", "\u0000c", "b"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create a namespace with the null-byte character");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"ac", "c\u0000", "b"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create a namespace with the null-byte character");
    }
}

