/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UnicodeUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInclusiveMetricsEvaluator {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"no_stats", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"required", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"all_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)8, (String)"some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)9, (String)"no_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)10, (String)"all_nulls_double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)11, (String)"all_nans_v1_stats", (Type)Types.FloatType.get()), Types.NestedField.optional((int)12, (String)"nan_and_null_only", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)13, (String)"no_nan_stats", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)14, (String)"some_empty", (Type)Types.StringType.get())});
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 79;
    private static final DataFile FILE = new TestHelpers.TestDataFile("file.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.builder().put((Object)4, (Object)50L).put((Object)5, (Object)50L).put((Object)6, (Object)50L).put((Object)7, (Object)50L).put((Object)8, (Object)50L).put((Object)9, (Object)50L).put((Object)10, (Object)50L).put((Object)11, (Object)50L).put((Object)12, (Object)50L).put((Object)13, (Object)50L).put((Object)14, (Object)50L).buildOrThrow(), (Map<Integer, Long>)ImmutableMap.builder().put((Object)4, (Object)50L).put((Object)5, (Object)10L).put((Object)6, (Object)0L).put((Object)10, (Object)50L).put((Object)11, (Object)0L).put((Object)12, (Object)1L).put((Object)14, (Object)0L).buildOrThrow(), (Map<Integer, Long>)ImmutableMap.of((Object)7, (Object)50L, (Object)8, (Object)10L, (Object)9, (Object)0L), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)30), (Object)11, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(Float.NaN)), (Object)12, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN), (Object)14, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)79), (Object)11, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(Float.NaN)), (Object)12, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN), (Object)14, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"\u623f\u4e1c\u6574\u79df\u970d\u8425\u5c0f\u533a\u4e8c\u5c42\u4e24\u5c45\u5ba4")));
    private static final DataFile FILE_2 = new TestHelpers.TestDataFile("file_2.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"aa")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"dC")));
    private static final DataFile FILE_3 = new TestHelpers.TestDataFile("file_3.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"1str1")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"3str3")));
    private static final DataFile FILE_4 = new TestHelpers.TestDataFile("file_4.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"abc")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8")));
    private static final DataFile FILE_5 = new TestHelpers.TestDataFile("file_4.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)3, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"abc")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"abcdefghi")));

    @Test
    public void testAllNulls() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"all_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no non-null value in all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"all_nulls", (Object)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: lessThan on all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"all_nulls", (Object)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: lessThanOrEqual on all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"all_nulls", (Object)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: greaterThan on all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"all_nulls", (Object)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: greaterThanOrEqual on all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"all_nulls", (Object)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: equal on all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"all_nulls", (String)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: startsWith on all null column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"all_nulls", (String)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notStartsWith on all null column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"some_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nulls contains a non-null value", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"no_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: non-null column contains a non-null value", new Object[0])).isTrue();
    }

    @Test
    public void testNoNulls() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"all_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one null value in all null column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"some_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nulls contains a null value", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"no_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: non-null column contains no null values", new Object[0])).isFalse();
    }

    @Test
    public void testIsNaN() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"all_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one nan value in all nan column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"some_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one nan value in some nan column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"no_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no-nans column contains no nan values", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"all_nulls_double")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: all-null column doesn't contain nan value", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"no_nan_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no guarantee on if contains nan value without nan stats", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"all_nans_v1_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one nan value in all nan column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"nan_and_null_only")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one nan value in nan and nulls only column", new Object[0])).isTrue();
    }

    @Test
    public void testNotNaN() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"all_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: column with all nans will not contain non-nan", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"some_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one non-nan value in some nan column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"no_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one non-nan value in no nan column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"all_nulls_double")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one non-nan value in all null column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"no_nan_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no guarantee on if contains nan value without nan stats", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"all_nans_v1_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no guarantee on if contains nan value without nan stats", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"nan_and_null_only")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one null value in nan and nulls only column", new Object[0])).isTrue();
    }

    @Test
    public void testRequiredColumn() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"required")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: required columns are always non-null", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"required")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: required columns are always non-null", new Object[0])).isFalse();
    }

    @Test
    public void testMissingColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"missing", (Object)5)).eval((ContentFile)FILE)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing'");
    }

    @Test
    public void testMissingStats() {
        Expression[] exprs;
        TestHelpers.TestDataFile missingStats = new TestHelpers.TestDataFile("file.parquet", TestHelpers.Row.of(new Object[0]), 50L);
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"no_stats", (Object)5), Expressions.lessThanOrEqual((String)"no_stats", (Object)30), Expressions.equal((String)"no_stats", (Object)70), Expressions.greaterThan((String)"no_stats", (Object)78), Expressions.greaterThanOrEqual((String)"no_stats", (Object)90), Expressions.notEqual((String)"no_stats", (Object)101), Expressions.isNull((String)"no_stats"), Expressions.notNull((String)"no_stats"), Expressions.isNaN((String)"some_nans"), Expressions.notNaN((String)"some_nans")}) {
            boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, expr).eval((ContentFile)missingStats);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read when missing stats for expr: " + expr, new Object[0])).isTrue();
        }
    }

    @Test
    public void testZeroRecordFile() {
        Expression[] exprs;
        TestHelpers.TestDataFile empty = new TestHelpers.TestDataFile("file.parquet", TestHelpers.Row.of(new Object[0]), 0L);
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"id", (Object)5), Expressions.lessThanOrEqual((String)"id", (Object)30), Expressions.equal((String)"id", (Object)70), Expressions.greaterThan((String)"id", (Object)78), Expressions.greaterThanOrEqual((String)"id", (Object)90), Expressions.notEqual((String)"id", (Object)101), Expressions.isNull((String)"some_nulls"), Expressions.notNull((String)"some_nulls"), Expressions.isNaN((String)"some_nans"), Expressions.notNaN((String)"some_nans")}) {
            boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, expr).eval((ContentFile)empty);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should never read 0-record file: " + expr, new Object[0])).isFalse();
        }
    }

    @Test
    public void testNot() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.lessThan((String)"id", (Object)5))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: not(false)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.greaterThan((String)"id", (Object)5))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: not(true)", new Object[0])).isFalse();
    }

    @Test
    public void testAnd() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)0))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, false)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.and((Expression)Expressions.greaterThan((String)"id", (Object)5), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true)", new Object[0])).isTrue();
    }

    @Test
    public void testOr() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: or(false, false)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)60))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: or(false, true)", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerLt() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (30 is not < 30)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)31)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerLtEq() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)29)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (29 < 30)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: many possible ids", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerGt() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)85)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (79 is not > 79)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)78)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)75)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerGtEq() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)85)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (80 > 79)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)75)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerEq() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)29)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)75)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)85)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
    }

    @Test
    public void testIntegerNotEq() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)29)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)75)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)85)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerNotEqRewritten() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)5))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)29))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)30))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)75))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)79))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)80))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)85))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @Test
    public void testCaseInsensitiveIntegerNotEqRewritten() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)5)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)29)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)30)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)75)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)79)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)80)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)85)), false).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @Test
    public void testCaseSensitiveIntegerNotEqRewritten() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new InclusiveMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"ID", (Object)5)), true).eval((ContentFile)FILE)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'ID'");
    }

    @Test
    public void testStringStartsWith() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"a"), true).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no stats", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"a"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"aa"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"aaa"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"1s"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"1str1x"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"ff"), true).eval((ContentFile)FILE_4);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"aB"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"dWX"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"5"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"3str3x"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"some_empty", (String)"\u623f\u4e1c\u6574\u79df\u970d"), true).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"all_nulls", (String)""), true).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        String aboveMax = ((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)"\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8"), (int)4).value()).toString();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)aboveMax), true).eval((ContentFile)FILE_4);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
    }

    @Test
    public void testStringNotStartsWith() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"a"), true).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no stats", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"a"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"aa"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"aaa"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"1s"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"1str1x"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"ff"), true).eval((ContentFile)FILE_4);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"aB"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"dWX"), true).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"5"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"3str3x"), true).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        String aboveMax = ((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)"\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8"), (int)4).value()).toString();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)aboveMax), true).eval((ContentFile)FILE_4);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"abc"), true).eval((ContentFile)FILE_5);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: all strings start with prefix", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"abcd"), true).eval((ContentFile)FILE_5);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: lower shorter than prefix, cannot match", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerIn() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{5, 6})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound (5 < 30, 6 < 30)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{28, 29})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound (28 < 30, 29 < 30)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{29, 30})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound (30 == 30)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{75, 76})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds (30 < 75 < 79, 30 < 76 < 79)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{79, 80})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound (79 == 79)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{80, 81})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound (80 > 79, 81 > 79)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{85, 86})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound (85 > 79, 86 > 79)", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"all_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: in on all nulls column", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on some nulls column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on no nulls column", new Object[0])).isTrue();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)400);
        for (int id = -400; id <= 0; ++id) {
            ids.add(id);
        }
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Iterable)ids)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: large in expression", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerNotIn() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{5, 6})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound (5 < 30, 6 < 30)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{28, 29})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound (28 < 30, 29 < 30)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{29, 30})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound (30 == 30)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{75, 76})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds (30 < 75 < 79, 30 < 76 < 79)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{79, 80})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound (79 == 79)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{80, 81})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound (80 > 79, 81 > 79)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{85, 86})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound (85 > 79, 86 > 79)", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"all_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on all nulls column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on some nulls column", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on no nulls column", new Object[0])).isTrue();
    }
}

