/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.List;
import org.apache.iceberg.expressions.PathUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.FieldSource;

public class TestPathUtil {
    private static final String[] VALID_PATHS = new String[]{"$", "$.event_id", "$.event.id", "$.\u2603", "$.\ud834\udd1e"};
    private static final String[] INVALID_PATHS = new String[]{null, "", "event_id", "$['event_id']", "$..event_id", "$.events[0].event_id", "$.events.*", "$.0invalid", "$._\ud834", "$._\udc34"};
    private static final String[][] NORMALIZED_PATHS = new String[][]{{"$", "$"}, {"$.a", "$['a']"}, {"$.a.b.c", "$['a']['b']['c']"}, {"$.\u2603", "$['\u2603']"}, {"$.a\ud834\udd1eb.x", "$['a\ud834\udd1eb']['x']"}};
    private static final Object[][] NORMALIZED_FIELD_LISTS = new Object[][]{{List.of(), "$"}, {List.of("a.b", "c"), "$['a.b']['c']"}, {List.of("a", "b", "c"), "$['a']['b']['c']"}, {List.of("a", "\u2603", "c"), "$['a']['\u2603']['c']"}, {List.of("a\ud834\udd1eb", "c"), "$['a\ud834\udd1eb']['c']"}, {List.of("a'b\n", "\fc"), "$['a\\'b\\n']['\\fc']"}, {List.of("a'b\u000b\n", "\fc"), "$['a\\'b\\u000b\\n']['\\fc']"}};
    private static final String[][] ESCAPE_CASES = new String[][]{{"\u000b", "\\u000b"}, {"\b", "\\b"}, {"\t", "\\t"}, {"\f", "\\f"}, {"\n", "\\n"}, {"\r", "\\r"}, {"'", "\\'"}, {"\\", "\\\\"}, {"a\\b", "a\\\\b"}, {"a\\b'", "a\\\\b\\'"}};

    @Test
    public void testSimplePath() {
        Assertions.assertThat((List)PathUtil.parse((String)"$.event.id")).isEqualTo(List.of("event", "id"));
    }

    @ParameterizedTest
    @FieldSource(value={"VALID_PATHS"})
    public void testExtractExpressionBindingPaths(String path) {
        Assertions.assertThatCode(() -> PathUtil.parse((String)path)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @FieldSource(value={"INVALID_PATHS"})
    public void testExtractBindingWithInvalidPath(String path) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PathUtil.parse((String)path)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("(Unsupported|Invalid) path.*");
    }

    @ParameterizedTest
    @FieldSource(value={"NORMALIZED_PATHS"})
    public void testNormalizedPath(String shortPath, String normalizedPath) {
        Assertions.assertThat((String)PathUtil.toNormalizedPath((Iterable)PathUtil.parse((String)shortPath))).isEqualTo(normalizedPath);
    }

    @ParameterizedTest
    @FieldSource(value={"NORMALIZED_FIELD_LISTS"})
    public void testNormalizedFieldLists(List<String> fields, String normalizedPath) {
        Assertions.assertThat((String)PathUtil.toNormalizedPath(fields)).isEqualTo(normalizedPath);
    }

    @ParameterizedTest
    @FieldSource(value={"ESCAPE_CASES"})
    public void testPathEscaping(String name, String escaped) {
        Assertions.assertThat((String)PathUtil.rfc9535escape((String)name)).isEqualTo(escaped);
    }
}

