/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.TestableCloseableIterable;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCloseableIterable {
    @Test
    public void testFilterManuallyClosable() throws IOException {
        TestableCloseableIterable iterable = new TestableCloseableIterable();
        TestableCloseableIterable.TestableCloseableIterator iterator = (TestableCloseableIterable.TestableCloseableIterator)iterable.iterator();
        CloseableIterable filtered = CloseableIterable.filter((CloseableIterable)iterable, x -> x > 5);
        Assertions.assertThat((Boolean)iterable.closed()).isFalse();
        Assertions.assertThat((Boolean)iterator.closed()).isFalse();
        filtered.iterator().close();
        Assertions.assertThat((Boolean)iterable.closed()).isFalse();
        Assertions.assertThat((Boolean)iterator.closed()).isTrue();
        filtered.close();
        Assertions.assertThat((Boolean)iterable.closed()).isTrue();
        Assertions.assertThat((Boolean)iterator.closed()).isTrue();
    }

    @Test
    public void testFilterAutomaticallyClosable() throws IOException {
        TestableCloseableIterable iterable = new TestableCloseableIterable();
        Assertions.assertThat((Boolean)iterable.closed()).isFalse();
        try (CloseableIterable filtered = CloseableIterable.filter((CloseableIterable)iterable, x -> x > 5);){
            Assertions.assertThat((Boolean)iterable.closed()).isFalse();
        }
        Assertions.assertThat((Boolean)iterable.closed()).isTrue();
    }

    @Test
    public void testConcatWithEmptyIterables() {
        CloseableIterable iter = CloseableIterable.combine((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), () -> {});
        CloseableIterable empty = CloseableIterable.empty();
        CloseableIterable concat1 = CloseableIterable.concat((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{iter, empty, empty}));
        Assertions.assertThat((int)((Integer)Iterables.getLast((Iterable)concat1))).isEqualTo(3);
        CloseableIterable concat2 = CloseableIterable.concat((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{empty, empty, iter}));
        Assertions.assertThat((int)((Integer)Iterables.getLast((Iterable)concat2))).isEqualTo(3);
        CloseableIterable concat3 = CloseableIterable.concat((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{empty, iter, empty}));
        Assertions.assertThat((int)((Integer)Iterables.getLast((Iterable)concat3))).isEqualTo(3);
        CloseableIterable concat4 = CloseableIterable.concat((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{empty, iter, empty, empty, iter}));
        Assertions.assertThat((int)((Integer)Iterables.getLast((Iterable)concat4))).isEqualTo(3);
        CloseableIterable concat5 = CloseableIterable.concat((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{empty, empty, empty}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Iterables.getLast((Iterable)concat5)).isInstanceOf(NoSuchElementException.class)).hasMessage(null);
    }

    @Test
    public void testWithCompletionRunnable() throws IOException {
        AtomicInteger completionCounter = new AtomicInteger(0);
        ArrayList items = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.whenComplete((CloseableIterable)CloseableIterable.combine((Iterable)items, () -> {}), null)).isInstanceOf(NullPointerException.class)).hasMessage("Invalid runnable: null");
        try (CloseableIterable iter = CloseableIterable.whenComplete((CloseableIterable)CloseableIterable.combine((Iterable)items, () -> {}), completionCounter::incrementAndGet);){
            iter.forEach(val -> Assertions.assertThat((int)completionCounter.get()).isZero());
        }
        Assertions.assertThat((int)completionCounter.get()).isOne();
    }

    @Test
    public void testWithCompletionRunnableAndEmptyIterable() throws IOException {
        AtomicInteger completionCounter = new AtomicInteger(0);
        CloseableIterable empty = CloseableIterable.empty();
        try (CloseableIterable iter = CloseableIterable.whenComplete((CloseableIterable)CloseableIterable.combine((Iterable)empty, () -> {}), completionCounter::incrementAndGet);){
            iter.forEach(val -> Assertions.assertThat((int)completionCounter.get()).isZero());
        }
        Assertions.assertThat((int)completionCounter.get()).isOne();
    }

    @Test
    public void testWithCompletionRunnableAndUnclosedIterable() {
        AtomicInteger completionCounter = new AtomicInteger(0);
        ArrayList items = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5});
        CloseableIterable iter = CloseableIterable.whenComplete((CloseableIterable)CloseableIterable.combine((Iterable)items, () -> {}), completionCounter::incrementAndGet);
        iter.forEach(val -> Assertions.assertThat((int)completionCounter.get()).isZero());
        Assertions.assertThat((int)completionCounter.get()).isZero();
    }

    @Test
    public void testWithCompletionRunnableWhenIterableThrows() {
        AtomicInteger completionCounter = new AtomicInteger(0);
        ArrayList items = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (CloseableIterable iter = CloseableIterable.whenComplete((CloseableIterable)CloseableIterable.combine((Iterable)items, () -> {
                throw new RuntimeException("expected");
            }), completionCounter::incrementAndGet);){
                iter.forEach(val -> Assertions.assertThat((int)completionCounter.get()).isZero());
            }
        }).isInstanceOf(RuntimeException.class)).hasMessage("expected");
        Assertions.assertThat((int)completionCounter.get()).isOne();
    }

    @Test
    public void testConcatWithEmpty() {
        AtomicInteger counter = new AtomicInteger(0);
        CloseableIterable.concat(Collections.emptyList()).forEach(c -> counter.incrementAndGet());
        Assertions.assertThat((int)counter.get()).isZero();
    }

    @Test
    public void concatShouldOnlyEvaluateItemsOnce() throws IOException {
        AtomicInteger counter = new AtomicInteger(0);
        ArrayList items = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5});
        Iterable iterable = Iterables.filter((Iterable)items, item -> {
            counter.incrementAndGet();
            return true;
        });
        Iterable transform = Iterables.transform((Iterable)iterable, item -> new CloseableIterable<Integer>(){

            public void close() {
            }

            public CloseableIterator<Integer> iterator() {
                return CloseableIterator.withClose(Collections.singletonList(item).iterator());
            }
        });
        AtomicInteger consumedCounter = new AtomicInteger(0);
        try (CloseableIterable concat = CloseableIterable.concat((Iterable)transform);){
            concat.forEach(count -> consumedCounter.getAndIncrement());
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(items.size()).isEqualTo(consumedCounter.get());
    }

    @Test
    public void concatIterablesWithIterator() throws IOException {
        CloseableIterable closeableIterable = CloseableIterable.concat(Collections.emptyList());
        closeableIterable.iterator();
        closeableIterable.close();
    }

    @Test
    public void count() {
        Counter counter = new DefaultMetricsContext().counter("x");
        CloseableIterable items = CloseableIterable.count((Counter)counter, (CloseableIterable)CloseableIterable.withNoopClose(Arrays.asList(1, 2, 3, 4, 5)));
        Assertions.assertThat((long)counter.value()).isZero();
        items.forEach(item -> {});
        Assertions.assertThat((long)counter.value()).isEqualTo(5L);
    }

    @Test
    public void countSkipped() {
        Counter counter = new DefaultMetricsContext().counter("x");
        CloseableIterable items = CloseableIterable.filter((Counter)counter, (CloseableIterable)CloseableIterable.withNoopClose(Arrays.asList(1, 2, 3, 4, 5)), x -> x % 2 == 0);
        Assertions.assertThat((long)counter.value()).isZero();
        items.forEach(item -> {});
        Assertions.assertThat((long)counter.value()).isEqualTo(3L);
    }

    @Test
    public void countNullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.count(null, (CloseableIterable)CloseableIterable.empty())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid counter: null");
        Counter counter = new DefaultMetricsContext().counter("x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.count((Counter)counter, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid iterable: null");
    }

    @Test
    public void countSkippedNullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.filter(null, (CloseableIterable)CloseableIterable.empty(), Predicate.isEqual(true))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid counter: null");
        Counter counter = new DefaultMetricsContext().counter("x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.filter((Counter)counter, null, Predicate.isEqual(true))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid iterable: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.filter((Counter)counter, (CloseableIterable)CloseableIterable.empty(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid predicate: null");
    }

    @Test
    public void transformNullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CloseableIterable.transform((CloseableIterable)CloseableIterable.empty(), null)).isInstanceOf(NullPointerException.class)).hasMessage("Invalid transform: null");
    }
}

