/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestIdentity {
    @Test
    public void testNullHumanString() {
        Types.LongType longType = Types.LongType.get();
        Transform identity = Transforms.identity();
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)longType, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
    }

    @Test
    public void testBinaryHumanString() {
        Types.BinaryType binary = Types.BinaryType.get();
        Transform identity = Transforms.identity();
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)binary, (Object)ByteBuffer.wrap(new byte[]{1, 2, 3}))).as("Should base64-encode binary", new Object[0])).isEqualTo("AQID");
    }

    @Test
    public void testFixedHumanString() {
        Types.FixedType fixed3 = Types.FixedType.ofLength((int)3);
        Transform identity = Transforms.identity();
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)fixed3, (Object)new byte[]{1, 2, 3})).as("Should base64-encode binary", new Object[0])).isEqualTo("AQID");
    }

    @Test
    public void testDateHumanString() {
        Types.DateType date = Types.DateType.get();
        Transform identity = Transforms.identity();
        String dateString = "2017-12-01";
        Literal dateLit = Literal.of((CharSequence)dateString).to((Type)date);
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)date, (Object)((Integer)dateLit.value()))).as("Should produce identical date", new Object[0])).isEqualTo(dateString);
    }

    @Test
    public void testDateHumanStringDeprecated() {
        Types.DateType date = Types.DateType.get();
        Transform identity = Transforms.identity((Type)date);
        String dateString = "2017-12-01";
        Literal dateLit = Literal.of((CharSequence)dateString).to((Type)date);
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Object)((Integer)dateLit.value()))).as("Should produce identical date", new Object[0])).isEqualTo(dateString);
    }

    @Test
    public void testTimeHumanString() {
        Types.TimeType time = Types.TimeType.get();
        Transform identity = Transforms.identity();
        String timeString = "10:12:55.038194";
        Literal timeLit = Literal.of((CharSequence)timeString).to((Type)time);
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)time, (Object)((Long)timeLit.value()))).as("Should produce identical time", new Object[0])).isEqualTo(timeString);
    }

    @Test
    public void testTimestampWithZoneHumanString() {
        Types.TimestampType timestamptz = Types.TimestampType.withZone();
        Transform identity = Transforms.identity();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194-08:00").to((Type)timestamptz);
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)timestamptz, (Object)((Long)ts.value()))).as("Should produce timestamp with time zone adjusted to UTC", new Object[0])).isEqualTo("2017-12-01T18:12:55.038194+00:00");
    }

    @Test
    public void testTimestampWithoutZoneHumanString() {
        Types.TimestampType timestamp = Types.TimestampType.withoutZone();
        Transform identity = Transforms.identity();
        String tsString = "2017-12-01T10:12:55.038194";
        Literal ts = Literal.of((CharSequence)tsString).to((Type)timestamp);
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)timestamp, (Object)((Long)ts.value()))).as("Should produce identical timestamp without time zone", new Object[0])).isEqualTo(tsString);
    }

    @Test
    public void testLongToHumanString() {
        Types.LongType longType = Types.LongType.get();
        Transform identity = Transforms.identity();
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)longType, (Object)-1234567890000L)).as("Should use Long toString", new Object[0])).isEqualTo("-1234567890000");
    }

    @Test
    public void testStringToHumanString() {
        Types.StringType string = Types.StringType.get();
        Transform identity = Transforms.identity();
        String withSlash = "a/b/c=d";
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)string, (Object)withSlash)).as("Should not modify Strings", new Object[0])).isEqualTo(withSlash);
    }

    @Test
    public void testBigDecimalToHumanString() {
        Types.DecimalType decimal = Types.DecimalType.of((int)9, (int)2);
        Transform identity = Transforms.identity();
        String decimalString = "-1.50";
        BigDecimal bigDecimal = new BigDecimal(decimalString);
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)decimal, (Object)bigDecimal)).as("Should not modify Strings", new Object[0])).isEqualTo(decimalString);
    }

    @Test
    public void testUnknownToHumanString() {
        Types.UnknownType unknownType = Types.UnknownType.get();
        Transform identity = Transforms.identity();
        ((AbstractStringAssert)Assertions.assertThat((String)identity.toHumanString((Type)unknownType, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedTypesProvider"})
    public void testUnsupported(Type type) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Transforms.identity().bind(type)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot bind to unsupported type: " + type);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Transforms.fromString((Type)type, (String)"identity")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type for identity: " + type);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Transforms.identity((Type)type)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported type for identity: " + type);
        Assertions.assertThat((boolean)Transforms.identity().canTransform(type)).isFalse();
    }

    private static Type[] unsupportedTypesProvider() {
        return new Type[]{Types.VariantType.get(), Types.GeometryType.crs84(), Types.GeographyType.crs84()};
    }
}

