/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Days;
import org.apache.iceberg.transforms.Hours;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimeTransforms {
    @Test
    public void testMicrosSatisfiesOrderOfDates() {
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Dates.MONTH)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
    }

    @Test
    public void testMicrosSatisfiesOrderOfTimestamps() {
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
    }

    @Test
    public void testMicrosSatisfiesOrderOfTimestampNanos() {
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
    }

    @Test
    public void testMicrosSatisfiesOrderOfTimeTransforms() {
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Hours.get())).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Hours.get().satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Days.get().satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Months.get().satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Months.get())).isFalse();
        Assertions.assertThat((boolean)Years.get().satisfiesOrderOf((Transform)Years.get())).isTrue();
    }

    @Test
    public void testHoursToEnum() {
        Hours hours = Hours.get();
        Types.DateType type = Types.DateType.get();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hours.toEnum((Type)type)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Unsupported type: date");
    }
}

