/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.EdgeAlgorithm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestTypeUtil {
    @Test
    public void testReassignIdsDuplicateColumns() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"A", (Type)Types.IntegerType.get())});
        Schema sourceSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())});
        Schema actualSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)sourceSchema.asStruct());
    }

    @Test
    public void testReassignIdsWithIdentifier() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{0}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Schema actualSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)sourceSchema.asStruct());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actualSchema.identifierFieldIds()).as("identifier field ID should change based on source schema", new Object[0])).isEqualTo((Object)sourceSchema.identifierFieldIds());
    }

    @Test
    public void testAssignIncreasingFreshIdWithIdentifier() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Schema actualSchema = TypeUtil.assignIncreasingFreshIds((Schema)schema);
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actualSchema.identifierFieldIds()).as("identifier field ID should change based on source schema", new Object[0])).isEqualTo((Object)expectedSchema.identifierFieldIds());
    }

    @Test
    public void testAssignIncreasingFreshIdNewIdentifier() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)sourceSchema.asStruct());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actualSchema.identifierFieldIds()).as("source schema missing identifier should not impact refreshing new identifier", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{sourceSchema.findField("a").fieldId()}));
    }

    @Test
    public void testProject() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema expectedTop = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}));
        Schema actualTop = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11}));
        Assertions.assertThat((Object)actualTop.asStruct()).isEqualTo((Object)expectedTop.asStruct());
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get())}))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 12, 13}));
        Assertions.assertThat((Object)actualDepthOne.asStruct()).isEqualTo((Object)expectedDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11, 12, 15, 17}));
        Schema actualDepthTwoChildren = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11, 17}));
        Assertions.assertThat((Object)actualDepthTwo.asStruct()).isEqualTo((Object)expectedDepthTwo.asStruct());
        Assertions.assertThat((Object)actualDepthTwoChildren.asStruct()).isEqualTo((Object)expectedDepthTwo.asStruct());
    }

    @Test
    public void testProjectNaturallyEmpty() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"empty", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}))}));
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}));
        Assertions.assertThat((Object)actualDepthOne.asStruct()).isEqualTo((Object)expectedDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12, 15}));
        Assertions.assertThat((Object)actualDepthTwo.asStruct()).isEqualTo((Object)expectedDepthTwo.asStruct());
        Schema expectedDepthThree = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"empty", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}))}));
        Schema actualDepthThree = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12, 15, 20}));
        Schema actualDepthThreeChildren = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{20}));
        Assertions.assertThat((Object)actualDepthThree.asStruct()).isEqualTo((Object)expectedDepthThree.asStruct());
        Assertions.assertThat((Object)actualDepthThreeChildren.asStruct()).isEqualTo((Object)expectedDepthThree.asStruct());
    }

    @Test
    public void testProjectEmpty() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}));
        Assertions.assertThat((Object)actualDepthOne.asStruct()).isEqualTo((Object)expectedDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12, 15}));
        Assertions.assertThat((Object)actualDepthTwo.asStruct()).isEqualTo((Object)expectedDepthTwo.asStruct());
    }

    @Test
    public void testSelect() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema expectedTop = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}));
        Schema actualTop = TypeUtil.select((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11}));
        Assertions.assertThat((Object)actualTop.asStruct()).isEqualTo((Object)expectedTop.asStruct());
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema actualDepthOne = TypeUtil.select((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 12}));
        Assertions.assertThat((Object)actualDepthOne.asStruct()).isEqualTo((Object)expectedDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema actualDepthTwo = TypeUtil.select((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11, 17}));
        Assertions.assertThat((Object)actualDepthTwo.asStruct()).isEqualTo((Object)expectedDepthTwo.asStruct());
    }

    @Test
    public void testProjectMap() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)100, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)101, (String)"y", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)200, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)201, (String)"innerMap", (Type)Types.MapType.ofOptional((int)202, (int)203, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)300, (String)"foo", (Type)Types.IntegerType.get()), Types.NestedField.required((int)301, (String)"bar", (Type)Types.IntegerType.get())})))})))}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{201}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        Schema expectedTopLevel = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get())}));
        Schema actualTopLevel = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Assertions.assertThat((Object)actualTopLevel.asStruct()).isEqualTo((Object)expectedTopLevel.asStruct());
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)100, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)101, (String)"y", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 13, 14, 100, 101}));
        Schema actualDepthOneNoKeys = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 13, 14}));
        Assertions.assertThat((Object)actualDepthOne.asStruct()).isEqualTo((Object)expectedDepthOne.asStruct());
        Assertions.assertThat((Object)actualDepthOneNoKeys.asStruct()).isEqualTo((Object)expectedDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)100, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)101, (String)"y", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)200, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)201, (String)"innerMap", (Type)Types.MapType.ofOptional((int)202, (int)203, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))})))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 13, 14, 100, 101, 200, 202, 203}));
        Assertions.assertThat((Object)actualDepthTwo.asStruct()).isEqualTo((Object)expectedDepthTwo.asStruct());
    }

    @Test
    public void testGetProjectedIds() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)35, (String)"emptyStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        HashSet expectedIds = Sets.newHashSet((Object[])new Integer[]{10, 11, 35, 12, 13, 14, 15, 16, 17});
        Set actualIds = TypeUtil.getProjectedIds((Schema)schema);
        Assertions.assertThat((Collection)actualIds).isEqualTo((Object)expectedIds);
    }

    @Test
    public void testProjectListNested() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"list", (Type)Types.ListType.ofRequired((int)13, (Type)Types.ListType.ofRequired((int)14, (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)18, (String)"y", (Type)Types.IntegerType.get())})))))}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{13}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{14}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        Schema expected = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"list", (Type)Types.ListType.ofRequired((int)13, (Type)Types.ListType.ofRequired((int)14, (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))))}));
        Schema actual = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{16}));
        Assertions.assertThat((Object)actual.asStruct()).isEqualTo((Object)expected.asStruct());
    }

    @Test
    public void testProjectMapNested() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.IntegerType.get(), (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.ListType.ofRequired((int)17, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)19, (String)"y", (Type)Types.IntegerType.get())})))))}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{14}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{16}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        Schema expected = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.IntegerType.get(), (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.ListType.ofRequired((int)17, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))))}));
        Schema actual = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{17}));
        Assertions.assertThat((Object)actual.asStruct()).isEqualTo((Object)expected.asStruct());
    }

    @Test
    public void testReassignIdsIllegalArgumentException() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.IntegerType.get())});
        Schema sourceSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Field b not found in source schema");
    }

    @Test
    public void testValidateSchemaViaIndexByName() {
        Types.NestedField nestedType = Types.NestedField.required((int)1, (String)"a", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"b", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c", (Type)Types.BooleanType.get())})), Types.NestedField.required((int)4, (String)"b.c", (Type)Types.BooleanType.get())}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.indexByName((Types.StructType)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{nestedType}))).isInstanceOf(RuntimeException.class)).hasMessageContaining("Invalid schema: multiple fields for name a.b.c");
    }

    @Test
    public void testSelectNot() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"long", (Type)Types.DoubleType.get())}))}));
        Schema expectedNoPrimitive = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"long", (Type)Types.DoubleType.get())}))}));
        Schema actualNoPrimitve = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Assertions.assertThat((Object)actualNoPrimitve.asStruct()).isEqualTo((Object)expectedNoPrimitive.asStruct());
        Schema expectedNoStructElements = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema actualNoStructElements = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{3, 4}));
        Assertions.assertThat((Object)actualNoStructElements.asStruct()).isEqualTo((Object)expectedNoStructElements.asStruct());
        Schema actualNoStruct = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{2}));
        Assertions.assertThat((Object)actualNoStruct.asStruct()).isEqualTo((Object)schema.asStruct());
    }

    @Test
    public void testReassignOrRefreshIds() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(11).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)12, (String)"B", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"B", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.reassignOrRefreshIds((Schema)schema, (Schema)sourceSchema);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(16).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)15, (String)"B", (Type)Types.IntegerType.get())}));
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testReassignOrRefreshIdsCaseInsensitive() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"FIELD1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"FIELD2", (Type)Types.IntegerType.get())}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field2", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.reassignOrRefreshIds((Schema)schema, (Schema)sourceSchema, (boolean)false);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"FIELD1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"FIELD2", (Type)Types.IntegerType.get())}));
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testAssignIds() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(1).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)2, (String)"B", (Type)Types.IntegerType.get())}));
        Type actualSchema = TypeUtil.assignIds((Type)schema.asStruct(), oldId -> oldId + 10);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(11).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)12, (String)"B", (Type)Types.IntegerType.get())}));
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testAssignFreshIds() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(1).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)2, (String)"B", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.assignFreshIds((Schema)schema, new AtomicInteger(10)::incrementAndGet);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(12).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)13, (String)"B", (Type)Types.IntegerType.get())}));
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testReassignDoc() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((String)"c").withId(1).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).build(), Types.NestedField.required((int)2, (String)"B", (Type)Types.IntegerType.get())}));
        Schema docSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get(), (String)"a_doc"), Types.NestedField.required((String)"c").withId(1).ofType((Type)Types.IntegerType.get()).withDoc("c_doc").build(), Types.NestedField.required((int)2, (String)"B", (Type)Types.IntegerType.get(), (String)"b_doc")}));
        Schema actualSchema = TypeUtil.reassignDoc((Schema)schema, (Schema)docSchema);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get(), (String)"a_doc"), Types.NestedField.required((String)"c").withId(1).ofType((Type)Types.IntegerType.get()).withInitialDefault(Literal.of((int)23)).withWriteDefault(Literal.of((int)34)).withDoc("c_doc").build(), Types.NestedField.required((int)2, (String)"B", (Type)Types.IntegerType.get(), (String)"b_doc")}));
        Assertions.assertThat((Object)actualSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
    }

    private static Stream<Arguments> testTypes() {
        return Stream.of(Arguments.of((Object[])new Object[]{Types.UnknownType.get()}), Arguments.of((Object[])new Object[]{Types.VariantType.get()}), Arguments.of((Object[])new Object[]{Types.TimestampNanoType.withoutZone()}), Arguments.of((Object[])new Object[]{Types.TimestampNanoType.withZone()}), Arguments.of((Object[])new Object[]{Types.GeometryType.crs84()}), Arguments.of((Object[])new Object[]{Types.GeometryType.of((String)"srid:3857")}), Arguments.of((Object[])new Object[]{Types.GeographyType.crs84()}), Arguments.of((Object[])new Object[]{Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY)}));
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testAssignIdsWithType(Type testType) {
        Types.StructType sourceType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)11, (String)"data", (Type)testType)});
        Type assignedType = TypeUtil.assignIds((Type)sourceType, oldId -> oldId + 10);
        Assertions.assertThat((Object)assignedType).isEqualTo((Object)expectedType);
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testAssignFreshIdsWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Schema assignedSchema = TypeUtil.assignFreshIds((Schema)schema, new AtomicInteger(10)::incrementAndGet);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)11, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)12, (String)"data", (Type)testType)});
        Assertions.assertThat((Object)assignedSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testReassignIdsWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Schema sourceSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)testType)});
        Schema reassignedSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assertions.assertThat((Object)reassignedSchema.asStruct()).isEqualTo((Object)sourceSchema.asStruct());
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testIndexByIdWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Map indexByIds = TypeUtil.indexById((Types.StructType)schema.asStruct());
        Assertions.assertThat((Object)((Types.NestedField)indexByIds.get(1)).type()).isEqualTo((Object)testType);
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testIndexNameByIdWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Map indexNameByIds = TypeUtil.indexNameById((Types.StructType)schema.asStruct());
        Assertions.assertThat((String)((String)indexNameByIds.get(1))).isEqualTo("data");
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testProjectWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Schema projectedSchema = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Assertions.assertThat((Object)projectedSchema.asStruct()).isEqualTo((Object)expectedSchema.asStruct());
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testGetProjectedIdsWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Set projectedIds = TypeUtil.getProjectedIds((Schema)schema);
        Assertions.assertThat(Set.of(Integer.valueOf(0), Integer.valueOf(1))).isEqualTo((Object)projectedIds);
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    public void testReassignDocWithType(Type testType) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)testType)});
        Schema docSourceSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get(), (String)"id"), Types.NestedField.optional((int)1, (String)"data", (Type)testType, (String)"data")});
        Schema reassignedSchema = TypeUtil.reassignDoc((Schema)schema, (Schema)docSourceSchema);
        Assertions.assertThat((Object)reassignedSchema.asStruct()).isEqualTo((Object)docSourceSchema.asStruct());
    }
}

