/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import org.apache.iceberg.types.EdgeAlgorithm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypes {
    @Test
    public void fromTypeName() {
        Assertions.assertThat((Object)Types.fromTypeName((String)"boolean")).isSameAs((Object)Types.BooleanType.get());
        Assertions.assertThat((Object)Types.fromTypeName((String)"BooLean")).isSameAs((Object)Types.BooleanType.get());
        Assertions.assertThat((Object)Types.fromTypeName((String)"timestamp")).isSameAs((Object)Types.TimestampType.withoutZone());
        Assertions.assertThat((Object)Types.fromTypeName((String)"timestamptz")).isSameAs((Object)Types.TimestampType.withZone());
        Assertions.assertThat((Object)Types.fromTypeName((String)"timestamp_ns")).isSameAs((Object)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Object)Types.fromTypeName((String)"timestamptz_ns")).isSameAs((Object)Types.TimestampNanoType.withZone());
        Assertions.assertThat((Object)Types.fromTypeName((String)"Fixed[ 3 ]")).isEqualTo((Object)Types.FixedType.ofLength((int)3));
        Assertions.assertThat((Object)Types.fromTypeName((String)"Decimal( 2 , 3 )")).isEqualTo((Object)Types.DecimalType.of((int)2, (int)3));
        Assertions.assertThat((Object)Types.fromTypeName((String)"Decimal(2,3)")).isEqualTo((Object)Types.DecimalType.of((int)2, (int)3));
        Assertions.assertThat((Object)Types.fromTypeName((String)"variant")).isSameAs((Object)Types.VariantType.get());
        Assertions.assertThat((Object)Types.fromTypeName((String)"Variant")).isSameAs((Object)Types.VariantType.get());
        Assertions.assertThat((Object)Types.fromTypeName((String)"geometry")).isEqualTo((Object)Types.GeometryType.crs84());
        Assertions.assertThat((Object)Types.fromTypeName((String)"Geometry")).isEqualTo((Object)Types.GeometryType.crs84());
        Assertions.assertThat((Object)Types.fromTypeName((String)"geometry(srid:3857)")).isEqualTo((Object)Types.GeometryType.of((String)"srid:3857"));
        Assertions.assertThat((Object)Types.fromTypeName((String)"geometry ( srid:3857 )")).isEqualTo((Object)Types.GeometryType.of((String)"srid:3857"));
        Assertions.assertThat((Object)Types.fromTypeName((String)"geography")).isEqualTo((Object)Types.GeographyType.crs84());
        Assertions.assertThat((Object)Types.fromTypeName((String)"Geography")).isEqualTo((Object)Types.GeographyType.crs84());
        Assertions.assertThat((Object)Types.fromTypeName((String)"geography(srid:4269)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269"));
        Assertions.assertThat((Object)Types.fromTypeName((String)"geography(srid:4269, karney)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
        Assertions.assertThat((Object)Types.fromTypeName((String)"geography ( srid:4269 , karney )")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromTypeName((String)"abcdefghij")).withMessage("Cannot parse type string to primitive: abcdefghij");
    }

    @Test
    public void fromPrimitiveString() {
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"boolean")).isSameAs((Object)Types.BooleanType.get());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"BooLean")).isSameAs((Object)Types.BooleanType.get());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"timestamp")).isSameAs((Object)Types.TimestampType.withoutZone());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"timestamptz")).isSameAs((Object)Types.TimestampType.withZone());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"timestamp_ns")).isSameAs((Object)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"timestamptz_ns")).isSameAs((Object)Types.TimestampNanoType.withZone());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Fixed[ 3 ]")).isEqualTo((Object)Types.FixedType.ofLength((int)3));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Decimal( 2 , 3 )")).isEqualTo((Object)Types.DecimalType.of((int)2, (int)3));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Decimal(2,3)")).isEqualTo((Object)Types.DecimalType.of((int)2, (int)3));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"variant")).withMessage("Cannot parse type string: variant is not a primitive type");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"Variant")).withMessage("Cannot parse type string: variant is not a primitive type");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"abcdefghij")).withMessage("Cannot parse type string to primitive: abcdefghij");
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geometry")).isEqualTo((Object)Types.GeometryType.crs84());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Geometry")).isEqualTo((Object)Types.GeometryType.crs84());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geometry(srid:3857)")).isEqualTo((Object)Types.GeometryType.of((String)"srid:3857"));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geometry( srid:3857 )")).isEqualTo((Object)Types.GeometryType.of((String)"srid:3857"));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geometry( srid: 3857 )")).isEqualTo((Object)Types.GeometryType.of((String)"srid: 3857"));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Geometry( projjson:TestIdentifier )")).isEqualTo((Object)Types.GeometryType.of((String)"projjson:TestIdentifier"));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"geometry()")).withMessageContaining("Invalid CRS: (empty string)");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"geometry( )")).withMessageContaining("Invalid CRS: (empty string)");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"geometry(srid:123,456)")).withMessageContaining("Invalid CRS: srid:123,456");
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography")).isEqualTo((Object)Types.GeographyType.crs84());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Geography")).isEqualTo((Object)Types.GeographyType.crs84());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269"));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid: 4269)")).isEqualTo((Object)Types.GeographyType.of((String)"srid: 4269"));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269, spherical)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.SPHERICAL));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269, vincenty)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.VINCENTY));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269, thomas)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.THOMAS));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269, andoyer)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.ANDOYER));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269, karney)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid: 4269, karney)")).isEqualTo((Object)Types.GeographyType.of((String)"srid: 4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Geography(projjson: TestIdentifier, karney)")).isEqualTo((Object)Types.GeographyType.of((String)"projjson: TestIdentifier", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"geography()")).withMessageContaining("Invalid CRS: (empty string)");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"geography( , spherical)")).withMessageContaining("Invalid CRS: (empty string)");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"geography(srid:4269, BadAlgorithm)")).withMessageContaining("Invalid edge interpolation algorithm").withMessageContaining("BadAlgorithm");
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography( srid:4269 )")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269"));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography( srid:4269 , spherical )")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.SPHERICAL));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography(srid:4269,vincenty)")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.VINCENTY));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"geography( srid:4269  ,  karney  )")).isEqualTo((Object)Types.GeographyType.of((String)"srid:4269", (EdgeAlgorithm)EdgeAlgorithm.KARNEY));
    }

    @Test
    public void testGeospatialTypeToString() {
        Assertions.assertThat((String)Types.GeometryType.crs84().toString()).isEqualTo("geometry");
        Assertions.assertThat((String)Types.GeometryType.of((String)"srid:4326").toString()).isEqualTo("geometry(srid:4326)");
        Assertions.assertThat((String)Types.GeographyType.crs84().toString()).isEqualTo("geography");
        Assertions.assertThat((String)Types.GeographyType.of((String)"srid:4326", (EdgeAlgorithm)EdgeAlgorithm.KARNEY).toString()).isEqualTo("geography(srid:4326, karney)");
        Assertions.assertThat((String)Types.GeographyType.of(null, (EdgeAlgorithm)EdgeAlgorithm.KARNEY).toString()).isEqualTo("geography(OGC:CRS84, karney)");
    }

    @Test
    public void testNestedFieldBuilderIdCheck() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> Types.NestedField.optional((String)"field").ofType((Type)Types.StringType.get()).build()).withMessage("Id cannot be null");
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> Types.NestedField.required((String)"field").ofType((Type)Types.StringType.get()).build()).withMessage("Id cannot be null");
    }
}

