/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.util.CharSequenceWrapper;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCharSequenceWrapper {
    @Test
    public void nullWrapper() {
        CharSequenceWrapper one = CharSequenceWrapper.wrap(null);
        CharSequenceWrapper two = CharSequenceWrapper.wrap(null);
        Assertions.assertThat((CharSequence)one).isEqualTo((Object)two);
        Assertions.assertThat((int)one.hashCode()).isEqualTo(two.hashCode()).isEqualTo(0);
        Assertions.assertThat((CharSequence)one).isEqualTo((Object)two);
    }

    @Test
    public void equalsWithLazyHashCode() {
        CharSequenceWrapper string = CharSequenceWrapper.wrap((CharSequence)"v1");
        CharSequenceWrapper buffer = CharSequenceWrapper.wrap((CharSequence)new StringBuffer("v1"));
        CharSequenceWrapper builder = CharSequenceWrapper.wrap((CharSequence)new StringBuilder("v1"));
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)string).isEqualTo((Object)buffer)).isEqualTo((Object)builder);
        Assertions.assertThat((int)string.hashCode()).isEqualTo(buffer.hashCode()).isEqualTo(builder.hashCode());
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)string).isEqualTo((Object)buffer)).isEqualTo((Object)builder);
    }

    @Test
    public void notEqualsWithLazyHashCode() {
        CharSequenceWrapper v1 = CharSequenceWrapper.wrap((CharSequence)"v1");
        CharSequenceWrapper v2 = CharSequenceWrapper.wrap((CharSequence)"v2");
        Assertions.assertThat((CharSequence)v1).isNotEqualTo((Object)v2);
        Assertions.assertThat((int)v1.hashCode()).isNotEqualTo(v2.hashCode());
        Assertions.assertThat((CharSequence)v1).isNotEqualTo((Object)v2);
    }

    @Test
    public void hashCodeIsRecomputed() {
        CharSequenceWrapper wrapper = CharSequenceWrapper.wrap((CharSequence)"v1");
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(173804);
        wrapper.set((CharSequence)"v2");
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(173805);
        wrapper.set((CharSequence)new StringBuffer("v2"));
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(173805);
        wrapper.set((CharSequence)new StringBuilder("v2"));
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(173805);
        wrapper.set((CharSequence)"v3");
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(173806);
        wrapper.set(null);
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(0);
        wrapper.set((CharSequence)"v2");
        Assertions.assertThat((int)wrapper.hashCode()).isEqualTo(173805);
    }
}

