/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.iceberg.util.ExceptionUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestExceptionUtil {
    @Test
    public void testRunSafely() {
        CustomCheckedException exc = new CustomCheckedException("test");
        Exception suppressedOne = new Exception("test catch suppression");
        RuntimeException suppressedTwo = new RuntimeException("test finally suppression");
        ((ListAssert)((ListAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExceptionUtil.runSafely(() -> {
            throw exc;
        }, e -> {
            throw suppressedOne;
        }, () -> {
            throw suppressedTwo;
        }, CustomCheckedException.class)).isInstanceOf(CustomCheckedException.class)).hasMessage(exc.getMessage()).isEqualTo((Object)exc)).extracting(e -> Arrays.asList(e.getSuppressed())).asInstanceOf(InstanceOfAssertFactories.LIST)).hasSize(2)).containsExactly(new Object[]{suppressedOne, suppressedTwo});
    }

    @Test
    public void testRunSafelyTwoExceptions() {
        CustomCheckedException exc = new CustomCheckedException("test");
        Exception suppressedOne = new Exception("test catch suppression");
        RuntimeException suppressedTwo = new RuntimeException("test finally suppression");
        ((ListAssert)((ListAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExceptionUtil.runSafely(() -> {
            throw exc;
        }, e -> {
            throw suppressedOne;
        }, () -> {
            throw suppressedTwo;
        }, CustomCheckedException.class, IOException.class)).isInstanceOf(CustomCheckedException.class)).hasMessage(exc.getMessage()).isEqualTo((Object)exc)).extracting(e -> Arrays.asList(e.getSuppressed())).asInstanceOf(InstanceOfAssertFactories.LIST)).hasSize(2)).containsExactly(new Object[]{suppressedOne, suppressedTwo});
    }

    @Test
    public void testRunSafelyThreeExceptions() {
        CustomCheckedException exc = new CustomCheckedException("test");
        Exception suppressedOne = new Exception("test catch suppression");
        RuntimeException suppressedTwo = new RuntimeException("test finally suppression");
        ((ListAssert)((ListAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExceptionUtil.runSafely(() -> {
            throw exc;
        }, e -> {
            throw suppressedOne;
        }, () -> {
            throw suppressedTwo;
        }, CustomCheckedException.class, IOException.class, ClassNotFoundException.class)).isInstanceOf(CustomCheckedException.class)).hasMessage(exc.getMessage()).isEqualTo((Object)exc)).extracting(e -> Arrays.asList(e.getSuppressed())).asInstanceOf(InstanceOfAssertFactories.LIST)).hasSize(2)).containsExactly(new Object[]{suppressedOne, suppressedTwo});
    }

    @Test
    public void testRunSafelyRuntimeExceptions() {
        RuntimeException exc = new RuntimeException("test");
        Exception suppressedOne = new Exception("test catch suppression");
        CustomCheckedException suppressedTwo = new CustomCheckedException("test finally suppression");
        ((ListAssert)((ListAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExceptionUtil.runSafely(() -> {
            throw exc;
        }, e -> {
            throw suppressedOne;
        }, () -> {
            throw suppressedTwo;
        })).isInstanceOf(RuntimeException.class)).hasMessage(exc.getMessage()).isEqualTo((Object)exc)).extracting(e -> Arrays.asList(e.getSuppressed())).asInstanceOf(InstanceOfAssertFactories.LIST)).hasSize(2)).containsExactly(new Object[]{suppressedOne, suppressedTwo});
    }

    private static class CustomCheckedException
    extends Exception {
        private CustomCheckedException(String message) {
            super(message);
        }
    }
}

