/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.ScanTaskUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestScanTaskUtil {
    @Test
    public void testContentSize() {
        DeleteFile dv1 = TestScanTaskUtil.mockDV("dv1.puffin", 20L, 25L, "data1.parquet");
        DeleteFile dv2 = TestScanTaskUtil.mockDV("dv2.puffin", 4L, 15L, "data2.parquet");
        long size1 = ScanTaskUtil.contentSizeInBytes((Iterable)ImmutableList.of());
        Assertions.assertThat((long)size1).isEqualTo(0L);
        long size2 = ScanTaskUtil.contentSizeInBytes((Iterable)ImmutableList.of((Object)dv1));
        Assertions.assertThat((long)size2).isEqualTo(25L);
        long size3 = ScanTaskUtil.contentSizeInBytes((Iterable)ImmutableList.of((Object)dv1, (Object)dv2));
        Assertions.assertThat((long)size3).isEqualTo(40L);
    }

    private static DeleteFile mockDV(String location, long contentOffset, long contentSize, String referencedDataFile) {
        DeleteFile mockFile = (DeleteFile)Mockito.mock(DeleteFile.class);
        Mockito.when((Object)mockFile.format()).thenReturn((Object)FileFormat.PUFFIN);
        Mockito.when((Object)mockFile.location()).thenReturn((Object)location);
        Mockito.when((Object)mockFile.contentOffset()).thenReturn((Object)contentOffset);
        Mockito.when((Object)mockFile.contentSizeInBytes()).thenReturn((Object)contentSize);
        Mockito.when((Object)mockFile.referencedDataFile()).thenReturn((Object)referencedDataFile);
        return mockFile;
    }
}

