/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.iceberg.util.RandomUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.Serialized;
import org.apache.iceberg.variants.SerializedArray;
import org.apache.iceberg.variants.SerializedMetadata;
import org.apache.iceberg.variants.SerializedPrimitive;
import org.apache.iceberg.variants.SerializedShortString;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantTestUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSerializedArray {
    private static final VariantMetadata EMPTY_METADATA = SerializedMetadata.EMPTY_V1_METADATA;
    private static final SerializedPrimitive NULL = SerializedPrimitive.from((byte[])new byte[]{0});
    private static final SerializedPrimitive TRUE = SerializedPrimitive.from((byte[])new byte[]{4});
    private static final SerializedPrimitive FALSE = SerializedPrimitive.from((byte[])new byte[]{8});
    private static final SerializedShortString STR = SerializedShortString.from((byte[])new byte[]{29, 105, 99, 101, 98, 101, 114, 103});
    private static final SerializedShortString A = SerializedShortString.from((byte[])new byte[]{5, 97});
    private static final SerializedShortString B = SerializedShortString.from((byte[])new byte[]{5, 98});
    private static final SerializedShortString C = SerializedShortString.from((byte[])new byte[]{5, 99});
    private static final SerializedShortString D = SerializedShortString.from((byte[])new byte[]{5, 100});
    private static final SerializedShortString E = SerializedShortString.from((byte[])new byte[]{5, 101});
    private static final SerializedPrimitive I34 = SerializedPrimitive.from((byte[])new byte[]{12, 34});
    private static final SerializedPrimitive I1234 = SerializedPrimitive.from((byte[])new byte[]{16, -46, 4});
    private static final SerializedPrimitive DATE = SerializedPrimitive.from((byte[])new byte[]{44, -12, 67, 0, 0});
    private final Random random = new Random(374513L);

    @Test
    public void testEmptyArray() {
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (byte[])new byte[]{3, 0});
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(0);
    }

    @Test
    public void testEmptyLargeArray() {
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (byte[])new byte[]{19, 0, 0, 0, 0});
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(0);
    }

    @Test
    public void testStringArray() {
        ByteBuffer buffer = VariantTestUtil.createArray(new Serialized[]{A, B, C, D, E});
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (ByteBuffer)buffer, (int)buffer.get(0));
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(5);
        Assertions.assertThat((Comparable)array.get(0).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(0).asPrimitive().get()).isEqualTo((Object)"a");
        Assertions.assertThat((Comparable)array.get(1).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(1).asPrimitive().get()).isEqualTo((Object)"b");
        Assertions.assertThat((Comparable)array.get(2).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(2).asPrimitive().get()).isEqualTo((Object)"c");
        Assertions.assertThat((Comparable)array.get(3).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(3).asPrimitive().get()).isEqualTo((Object)"d");
        Assertions.assertThat((Comparable)array.get(4).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(4).asPrimitive().get()).isEqualTo((Object)"e");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> array.get(5)).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 5 out of bounds for length 5");
    }

    @Test
    public void testStringDifferentLengths() {
        ByteBuffer buffer = VariantTestUtil.createArray(new Serialized[]{A, B, C, STR, D, E});
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (ByteBuffer)buffer, (int)buffer.get(0));
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(6);
        Assertions.assertThat((Comparable)array.get(0).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(0).asPrimitive().get()).isEqualTo((Object)"a");
        Assertions.assertThat((Comparable)array.get(1).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(1).asPrimitive().get()).isEqualTo((Object)"b");
        Assertions.assertThat((Comparable)array.get(2).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(2).asPrimitive().get()).isEqualTo((Object)"c");
        Assertions.assertThat((Comparable)array.get(3).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(3).asPrimitive().get()).isEqualTo((Object)"iceberg");
        Assertions.assertThat((Comparable)array.get(4).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(4).asPrimitive().get()).isEqualTo((Object)"d");
        Assertions.assertThat((Comparable)array.get(5).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(5).asPrimitive().get()).isEqualTo((Object)"e");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> array.get(6)).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 6 out of bounds for length 6");
    }

    @Test
    public void testArrayOfMixedTypes() {
        ByteBuffer nestedBuffer = VariantTestUtil.createArray(new Serialized[]{A, C, D});
        SerializedArray nested = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (ByteBuffer)nestedBuffer, (int)nestedBuffer.get(0));
        ByteBuffer buffer = VariantTestUtil.createArray(new Serialized[]{DATE, I34, STR, NULL, E, B, FALSE, nested, TRUE, I1234});
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (ByteBuffer)buffer, (int)buffer.get(0));
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(10);
        Assertions.assertThat((Comparable)array.get(0).type()).isEqualTo((Object)PhysicalType.DATE);
        Assertions.assertThat((Object)array.get(0).asPrimitive().get()).isEqualTo((Object)17396);
        Assertions.assertThat((Comparable)array.get(1).type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)array.get(1).asPrimitive().get()).isEqualTo((Object)34);
        Assertions.assertThat((Comparable)array.get(2).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(2).asPrimitive().get()).isEqualTo((Object)"iceberg");
        Assertions.assertThat((Comparable)array.get(3).type()).isEqualTo((Object)PhysicalType.NULL);
        Assertions.assertThat((Object)array.get(3).asPrimitive().get()).isEqualTo(null);
        Assertions.assertThat((Comparable)array.get(4).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(4).asPrimitive().get()).isEqualTo((Object)"e");
        Assertions.assertThat((Comparable)array.get(5).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(5).asPrimitive().get()).isEqualTo((Object)"b");
        Assertions.assertThat((Comparable)array.get(6).type()).isEqualTo((Object)PhysicalType.BOOLEAN_FALSE);
        Assertions.assertThat((Object)array.get(6).asPrimitive().get()).isEqualTo((Object)false);
        Assertions.assertThat((Comparable)array.get(8).type()).isEqualTo((Object)PhysicalType.BOOLEAN_TRUE);
        Assertions.assertThat((Object)array.get(8).asPrimitive().get()).isEqualTo((Object)true);
        Assertions.assertThat((Comparable)array.get(9).type()).isEqualTo((Object)PhysicalType.INT16);
        Assertions.assertThat((Object)array.get(9).asPrimitive().get()).isEqualTo((Object)1234);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> array.get(10)).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 10 out of bounds for length 10");
        Assertions.assertThat((Comparable)array.get(7).type()).isEqualTo((Object)PhysicalType.ARRAY);
        SerializedArray actualNested = (SerializedArray)array.get(7);
        Assertions.assertThat((int)actualNested.numElements()).isEqualTo(3);
        Assertions.assertThat((Comparable)actualNested.get(0).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)actualNested.get(0).asPrimitive().get()).isEqualTo((Object)"a");
        Assertions.assertThat((Comparable)actualNested.get(1).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)actualNested.get(1).asPrimitive().get()).isEqualTo((Object)"c");
        Assertions.assertThat((Comparable)actualNested.get(2).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)actualNested.get(2).asPrimitive().get()).isEqualTo((Object)"d");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actualNested.get(3)).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 3 out of bounds for length 3");
    }

    @Test
    public void testTwoByteOffsets() {
        String randomString = RandomUtil.generateString(300, this.random);
        SerializedPrimitive bigString = VariantTestUtil.createString(randomString);
        ByteBuffer buffer = VariantTestUtil.createArray(new Serialized[]{bigString, A, B, C});
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (ByteBuffer)buffer, (int)buffer.get(0));
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(4);
        Assertions.assertThat((Comparable)array.get(0).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(0).asPrimitive().get()).isEqualTo((Object)randomString);
        Assertions.assertThat((Comparable)array.get(1).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(1).asPrimitive().get()).isEqualTo((Object)"a");
        Assertions.assertThat((Comparable)array.get(2).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(2).asPrimitive().get()).isEqualTo((Object)"b");
        Assertions.assertThat((Comparable)array.get(3).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(3).asPrimitive().get()).isEqualTo((Object)"c");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> array.get(4)).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 4 out of bounds for length 4");
    }

    @Test
    public void testThreeByteOffsets() {
        String randomString = RandomUtil.generateString(70000, this.random);
        SerializedPrimitive reallyBigString = VariantTestUtil.createString(randomString);
        ByteBuffer buffer = VariantTestUtil.createArray(new Serialized[]{reallyBigString, A, B, C});
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (ByteBuffer)buffer, (int)buffer.get(0));
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(4);
        Assertions.assertThat((Comparable)array.get(0).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(0).asPrimitive().get()).isEqualTo((Object)randomString);
        Assertions.assertThat((Comparable)array.get(1).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(1).asPrimitive().get()).isEqualTo((Object)"a");
        Assertions.assertThat((Comparable)array.get(2).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(2).asPrimitive().get()).isEqualTo((Object)"b");
        Assertions.assertThat((Comparable)array.get(3).type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)array.get(3).asPrimitive().get()).isEqualTo((Object)"c");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> array.get(4)).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 4 out of bounds for length 4");
    }

    @Test
    public void testLargeArraySize() {
        SerializedArray array = SerializedArray.from((VariantMetadata)EMPTY_METADATA, (byte[])new byte[]{19, -1, 1, 0, 0});
        Assertions.assertThat((Comparable)array.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)array.numElements()).isEqualTo(511);
    }

    @Test
    public void testNegativeArraySize() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SerializedArray.from((VariantMetadata)EMPTY_METADATA, (byte[])new byte[]{19, -1, -1, -1, -1})).isInstanceOf(NegativeArraySizeException.class)).hasMessage("-1");
    }
}

