/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.RandomUtil;
import org.apache.iceberg.variants.SerializedMetadata;
import org.apache.iceberg.variants.VariantTestUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestSerializedMetadata {
    private final Random random = new Random(872591L);

    @Test
    public void testEmptyVariantMetadata() {
        SerializedMetadata metadata = SerializedMetadata.EMPTY_V1_METADATA;
        Assertions.assertThat((boolean)metadata.isSorted()).isFalse();
        Assertions.assertThat((int)metadata.dictionarySize()).isEqualTo(0);
        Assertions.assertThatThrownBy(() -> metadata.get(0)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testHeaderSorted() {
        SerializedMetadata metadata = SerializedMetadata.from((byte[])new byte[]{17, 0, 0});
        Assertions.assertThat((boolean)metadata.isSorted()).isTrue();
        Assertions.assertThat((int)metadata.dictionarySize()).isEqualTo(0);
    }

    @Test
    public void testHeaderOffsetSize() {
        Assertions.assertThat((int)SerializedMetadata.from((byte[])new byte[]{-47, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}).dictionarySize()).isEqualTo(1);
        Assertions.assertThat((int)SerializedMetadata.from((byte[])new byte[]{-111, 1, 0, 0, 0, 0, 0, 0, 0, 0}).dictionarySize()).isEqualTo(1);
        Assertions.assertThat((int)SerializedMetadata.from((byte[])new byte[]{81, 1, 0, 0, 0, 0, 0}).dictionarySize()).isEqualTo(1);
        Assertions.assertThat((int)SerializedMetadata.from((byte[])new byte[]{17, 1, 0, 0}).dictionarySize()).isEqualTo(1);
    }

    @Test
    public void testReadString() {
        SerializedMetadata metadata = SerializedMetadata.from((byte[])new byte[]{17, 5, 0, 1, 2, 3, 4, 5, 97, 98, 99, 100, 101});
        Assertions.assertThat((String)metadata.get(0)).isEqualTo("a");
        Assertions.assertThat((String)metadata.get(1)).isEqualTo("b");
        Assertions.assertThat((String)metadata.get(2)).isEqualTo("c");
        Assertions.assertThat((String)metadata.get(3)).isEqualTo("d");
        Assertions.assertThat((String)metadata.get(4)).isEqualTo("e");
        Assertions.assertThatThrownBy(() -> metadata.get(5)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testMultibyteString() {
        SerializedMetadata metadata = SerializedMetadata.from((byte[])new byte[]{17, 5, 0, 1, 2, 5, 6, 7, 97, 98, 120, 121, 122, 100, 101});
        Assertions.assertThat((String)metadata.get(0)).isEqualTo("a");
        Assertions.assertThat((String)metadata.get(1)).isEqualTo("b");
        Assertions.assertThat((String)metadata.get(2)).isEqualTo("xyz");
        Assertions.assertThat((String)metadata.get(3)).isEqualTo("d");
        Assertions.assertThat((String)metadata.get(4)).isEqualTo("e");
        Assertions.assertThatThrownBy(() -> metadata.get(5)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testTwoByteOffsets() {
        SerializedMetadata metadata = SerializedMetadata.from((byte[])new byte[]{81, 5, 0, 0, 0, 1, 0, 2, 0, 5, 0, 6, 0, 7, 0, 97, 98, 120, 121, 122, 100, 101});
        Assertions.assertThat((String)metadata.get(0)).isEqualTo("a");
        Assertions.assertThat((String)metadata.get(1)).isEqualTo("b");
        Assertions.assertThat((String)metadata.get(2)).isEqualTo("xyz");
        Assertions.assertThat((String)metadata.get(3)).isEqualTo("d");
        Assertions.assertThat((String)metadata.get(4)).isEqualTo("e");
        Assertions.assertThatThrownBy(() -> metadata.get(5)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testFindStringSorted() {
        SerializedMetadata metadata = SerializedMetadata.from((byte[])new byte[]{17, 5, 0, 1, 2, 3, 4, 5, 97, 98, 99, 100, 101});
        Assertions.assertThat((int)metadata.id("A")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("a")).isEqualTo(0);
        Assertions.assertThat((int)metadata.id("aa")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("b")).isEqualTo(1);
        Assertions.assertThat((int)metadata.id("bb")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("c")).isEqualTo(2);
        Assertions.assertThat((int)metadata.id("cc")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("d")).isEqualTo(3);
        Assertions.assertThat((int)metadata.id("dd")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("e")).isEqualTo(4);
        Assertions.assertThat((int)metadata.id("ee")).isEqualTo(-1);
    }

    @Test
    public void testFindStringUnsorted() {
        SerializedMetadata metadata = SerializedMetadata.from((byte[])new byte[]{1, 5, 0, 1, 2, 3, 4, 5, 101, 100, 99, 98, 97});
        Assertions.assertThat((int)metadata.id("A")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("a")).isEqualTo(4);
        Assertions.assertThat((int)metadata.id("aa")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("b")).isEqualTo(3);
        Assertions.assertThat((int)metadata.id("bb")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("c")).isEqualTo(2);
        Assertions.assertThat((int)metadata.id("cc")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("d")).isEqualTo(1);
        Assertions.assertThat((int)metadata.id("dd")).isEqualTo(-1);
        Assertions.assertThat((int)metadata.id("e")).isEqualTo(0);
        Assertions.assertThat((int)metadata.id("ee")).isEqualTo(-1);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTwoByteFieldIds(boolean sortFieldNames) {
        HashSet keySet = Sets.newHashSet();
        String lastKey = null;
        for (int i = 0; i < 10000; ++i) {
            lastKey = RandomUtil.generateString(10, this.random);
            keySet.add(lastKey);
        }
        ByteBuffer buffer = VariantTestUtil.createMetadata(keySet, sortFieldNames);
        SerializedMetadata metadata = SerializedMetadata.from((ByteBuffer)buffer);
        Assertions.assertThat((int)metadata.dictionarySize()).isEqualTo(10000);
        Assertions.assertThat((int)metadata.id(lastKey)).isGreaterThan(0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testThreeByteFieldIds(boolean sortFieldNames) {
        HashSet keySet = Sets.newHashSet();
        String lastKey = null;
        for (int i = 0; i < 100000; ++i) {
            lastKey = RandomUtil.generateString(10, this.random);
            keySet.add(lastKey);
        }
        ByteBuffer buffer = VariantTestUtil.createMetadata(keySet, sortFieldNames);
        SerializedMetadata metadata = SerializedMetadata.from((ByteBuffer)buffer);
        Assertions.assertThat((int)metadata.dictionarySize()).isEqualTo(100000);
        Assertions.assertThat((int)metadata.id(lastKey)).isGreaterThan(0);
    }

    @Test
    public void testInvalidMetadataVersion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SerializedMetadata.from((byte[])new byte[]{2, 0})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported version: 2");
    }

    @Test
    public void testMissingLength() {
        Assertions.assertThatThrownBy(() -> SerializedMetadata.from((byte[])new byte[]{1})).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    public void testLengthTooShort() {
        Assertions.assertThatThrownBy(() -> SerializedMetadata.from((byte[])new byte[]{-47, 0, 0, 0})).isInstanceOf(IndexOutOfBoundsException.class);
    }
}

