/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.RandomUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.SerializedMetadata;
import org.apache.iceberg.variants.SerializedObject;
import org.apache.iceberg.variants.SerializedPrimitive;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantTestUtil;
import org.apache.iceberg.variants.VariantValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestSerializedObject {
    private static final VariantMetadata EMPTY_METADATA = SerializedMetadata.EMPTY_V1_METADATA;
    private static final SerializedPrimitive I1 = SerializedPrimitive.from((byte[])new byte[]{12, 1});
    private static final SerializedPrimitive I2 = SerializedPrimitive.from((byte[])new byte[]{12, 2});
    private static final SerializedPrimitive I3 = SerializedPrimitive.from((byte[])new byte[]{12, 3});
    private static final SerializedPrimitive NULL = SerializedPrimitive.from((byte[])new byte[]{0});
    private static final SerializedPrimitive TRUE = SerializedPrimitive.from((byte[])new byte[]{4});
    private static final SerializedPrimitive DATE = SerializedPrimitive.from((byte[])new byte[]{44, -12, 67, 0, 0});
    private static final byte[] UNSORTED_VALUES = new byte[]{2, 3, 0, 1, 2, 2, 4, 0, 6, 12, 3, 12, 1, 12, 2};
    private final Random random = new Random(198725L);

    @Test
    public void testEmptyObject() {
        SerializedObject object = SerializedObject.from((VariantMetadata)EMPTY_METADATA, (byte[])new byte[]{2, 0});
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(0);
    }

    @Test
    public void testEmptyLargeObject() {
        SerializedObject object = SerializedObject.from((VariantMetadata)EMPTY_METADATA, (byte[])new byte[]{66, 0, 0, 0, 0});
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(0);
    }

    @Test
    public void testSimpleObject() {
        ImmutableMap data = ImmutableMap.of((Object)"a", (Object)I1, (Object)"b", (Object)I2, (Object)"c", (Object)I3);
        ByteBuffer meta = VariantTestUtil.createMetadata(data.keySet(), true);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(3);
        Assertions.assertThat((Comparable)object.get("a").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("a").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("b").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("b").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)object.get("c").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("c").asPrimitive().get()).isEqualTo((Object)3);
        Assertions.assertThat((Object)object.get("d")).isEqualTo(null);
    }

    @Test
    public void testUnsortedValues() {
        ByteBuffer meta = VariantTestUtil.createMetadata(Sets.newHashSet((Object[])new String[]{"a", "b", "c"}), true);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (byte[])UNSORTED_VALUES);
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(3);
        Assertions.assertThat((Comparable)object.get("a").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("a").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("b").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("b").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)object.get("c").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("c").asPrimitive().get()).isEqualTo((Object)3);
        Assertions.assertThat((Object)object.get("d")).isEqualTo(null);
    }

    @Test
    public void testOutOfOrderKeys() {
        ImmutableMap data = ImmutableMap.of((Object)"b", (Object)I2, (Object)"a", (Object)I1, (Object)"c", (Object)I3);
        ByteBuffer meta = VariantTestUtil.createMetadata(data.keySet(), false);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(3);
        Assertions.assertThat((Object)object.get("d")).isEqualTo(null);
        Assertions.assertThat((Comparable)object.get("c").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("c").asPrimitive().get()).isEqualTo((Object)3);
        Assertions.assertThat((Comparable)object.get("a").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("a").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("b").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("b").asPrimitive().get()).isEqualTo((Object)2);
    }

    @Test
    public void testMixedValueTypes() {
        ByteBuffer meta = VariantTestUtil.createMetadata((Collection<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"), true);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        ImmutableMap inner = ImmutableMap.of((Object)"b", (Object)I2, (Object)"f", (Object)I3);
        ByteBuffer innerBuffer = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)inner);
        SerializedObject innerObject = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)innerBuffer, (int)innerBuffer.get(0));
        ImmutableMap data = ImmutableMap.of((Object)"a", (Object)I1, (Object)"b", (Object)DATE, (Object)"c", (Object)NULL, (Object)"d", (Object)TRUE, (Object)"e", (Object)innerObject);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(5);
        Assertions.assertThat((Comparable)object.get("a").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("a").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("b").type()).isEqualTo((Object)PhysicalType.DATE);
        Assertions.assertThat((Object)((SerializedPrimitive)object.get("b")).get()).isEqualTo((Object)17396);
        Assertions.assertThat((Comparable)object.get("c").type()).isEqualTo((Object)PhysicalType.NULL);
        Assertions.assertThat((Object)((SerializedPrimitive)object.get("c")).get()).isEqualTo(null);
        Assertions.assertThat((Comparable)object.get("d").type()).isEqualTo((Object)PhysicalType.BOOLEAN_TRUE);
        Assertions.assertThat((Object)((SerializedPrimitive)object.get("d")).get()).isEqualTo((Object)true);
        Assertions.assertThat((Comparable)object.get("e").type()).isEqualTo((Object)PhysicalType.OBJECT);
        SerializedObject actualInner = (SerializedObject)object.get("e").asObject();
        Assertions.assertThat((int)actualInner.numFields()).isEqualTo(2);
        Assertions.assertThat((Comparable)actualInner.get("b").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)actualInner.get("b").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)actualInner.get("f").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)actualInner.get("f").asPrimitive().get()).isEqualTo((Object)3);
    }

    @Test
    public void testTwoByteOffsets() {
        String randomString = RandomUtil.generateString(300, this.random);
        SerializedPrimitive bigString = VariantTestUtil.createString(randomString);
        ImmutableMap data = ImmutableMap.of((Object)"big", (Object)bigString, (Object)"a", (Object)I1, (Object)"b", (Object)I2, (Object)"c", (Object)I3);
        ByteBuffer meta = VariantTestUtil.createMetadata(data.keySet(), true);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(4);
        Assertions.assertThat((Comparable)object.get("a").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("a").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("b").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("b").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)object.get("c").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("c").asPrimitive().get()).isEqualTo((Object)3);
        Assertions.assertThat((Comparable)object.get("big").type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)object.get("big").asPrimitive().get()).isEqualTo((Object)randomString);
    }

    @Test
    public void testThreeByteOffsets() {
        String randomString = RandomUtil.generateString(70000, this.random);
        SerializedPrimitive reallyBigString = VariantTestUtil.createString(randomString);
        ImmutableMap data = ImmutableMap.of((Object)"really-big", (Object)reallyBigString, (Object)"a", (Object)I1, (Object)"b", (Object)I2, (Object)"c", (Object)I3);
        ByteBuffer meta = VariantTestUtil.createMetadata(data.keySet(), true);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(4);
        Assertions.assertThat((Comparable)object.get("a").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("a").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("b").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("b").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)object.get("c").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("c").asPrimitive().get()).isEqualTo((Object)3);
        Assertions.assertThat((Comparable)object.get("really-big").type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)object.get("really-big").asPrimitive().get()).isEqualTo((Object)randomString);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLargeObject(boolean sortFieldNames) {
        HashMap fields = Maps.newHashMap();
        for (int i = 0; i < 10000; ++i) {
            fields.put(RandomUtil.generateString(10, this.random), VariantTestUtil.createString(RandomUtil.generateString(10, this.random)));
        }
        ByteBuffer meta = VariantTestUtil.createMetadata(fields.keySet(), sortFieldNames);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)fields);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(10000);
        for (Map.Entry entry : fields.entrySet()) {
            VariantValue fieldValue = object.get((String)entry.getKey());
            Assertions.assertThat((Comparable)fieldValue.type()).isEqualTo((Object)PhysicalType.STRING);
            Assertions.assertThat((Object)fieldValue.asPrimitive().get()).isEqualTo(((SerializedPrimitive)entry.getValue()).get());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTwoByteFieldIds(boolean sortFieldNames) {
        HashSet keySet = Sets.newHashSet();
        for (int i = 0; i < 10000; ++i) {
            keySet.add(RandomUtil.generateString(10, this.random));
        }
        ImmutableMap data = ImmutableMap.of((Object)"aa", (Object)I1, (Object)"AA", (Object)I2, (Object)"ZZ", (Object)I3);
        keySet.addAll(data.keySet());
        ByteBuffer meta = VariantTestUtil.createMetadata(keySet, sortFieldNames);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(3);
        Assertions.assertThat((Comparable)object.get("aa").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("aa").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("AA").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("AA").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)object.get("ZZ").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("ZZ").asPrimitive().get()).isEqualTo((Object)3);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testThreeByteFieldIds(boolean sortFieldNames) {
        HashSet keySet = Sets.newHashSet();
        for (int i = 0; i < 100000; ++i) {
            keySet.add(RandomUtil.generateString(10, this.random));
        }
        ImmutableMap data = ImmutableMap.of((Object)"aa", (Object)I1, (Object)"AA", (Object)I2, (Object)"ZZ", (Object)I3);
        keySet.addAll(data.keySet());
        ByteBuffer meta = VariantTestUtil.createMetadata(keySet, sortFieldNames);
        ByteBuffer value = VariantTestUtil.createObject(meta, (Map<String, VariantValue>)data);
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)meta);
        SerializedObject object = SerializedObject.from((VariantMetadata)metadata, (ByteBuffer)value, (int)value.get(0));
        Assertions.assertThat((Comparable)object.type()).isEqualTo((Object)PhysicalType.OBJECT);
        Assertions.assertThat((int)object.numFields()).isEqualTo(3);
        Assertions.assertThat((Comparable)object.get("aa").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("aa").asPrimitive().get()).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)object.get("AA").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("AA").asPrimitive().get()).isEqualTo((Object)2);
        Assertions.assertThat((Comparable)object.get("ZZ").type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)object.get("ZZ").asPrimitive().get()).isEqualTo((Object)3);
    }
}

