/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.SerializedPrimitive;
import org.apache.iceberg.variants.SerializedShortString;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSerializedPrimitives {
    @Test
    public void testNull() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(0)});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.NULL);
        Assertions.assertThat((Object)value.get()).isEqualTo(null);
    }

    @Test
    public void testTrue() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(1)});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.BOOLEAN_TRUE);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)true);
    }

    @Test
    public void testFalse() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(2)});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.BOOLEAN_FALSE);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)false);
    }

    @Test
    public void testInt8() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(3), 34});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)34);
    }

    @Test
    public void testNegativeInt8() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(3), -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT8);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)-1);
    }

    @Test
    public void testInt16() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(4), -46, 4});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT16);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)1234);
    }

    @Test
    public void testNegativeInt16() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(4), -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT16);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)-1);
    }

    @Test
    public void testInt32() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(5), -46, 2, -106, 73});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT32);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)1234567890);
    }

    @Test
    public void testNegativeInt32() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(5), -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT32);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)-1);
    }

    @Test
    public void testInt64() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(6), -79, 28, 108, -79, -12, 16, 34, 17});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT64);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)1234567890987654321L);
    }

    @Test
    public void testNegativeInt64() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(6), -1, -1, -1, -1, -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.INT64);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)-1L);
    }

    @Test
    public void testDouble() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(7), -79, 28, 108, -79, -12, 16, 34, 17});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DOUBLE);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)Double.longBitsToDouble(1234567890987654321L));
    }

    @Test
    public void testNegativeDouble() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(7), 0, 0, 0, 0, 0, 0, 0, -128});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DOUBLE);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)-0.0);
    }

    @Test
    public void testDecimal4() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(8), 4, -46, 2, -106, 73});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DECIMAL4);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)new BigDecimal("123456.7890"));
    }

    @Test
    public void testNegativeDecimal4() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(8), 4, -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DECIMAL4);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)new BigDecimal("-0.0001"));
    }

    @Test
    public void testDecimal8() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(9), 9, -79, 28, 108, -79, -12, 16, 34, 17});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DECIMAL8);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)new BigDecimal("1234567890.987654321"));
    }

    @Test
    public void testNegativeDecimal8() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(9), 9, -1, -1, -1, -1, -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DECIMAL8);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)new BigDecimal("-0.000000001"));
    }

    @Test
    public void testDecimal16() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(10), 9, 21, 113, 52, -80, -72, -121, 16, -119, 0, 0, 0, 0, 0, 0, 0, 0});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DECIMAL16);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)new BigDecimal("9876543210.123456789"));
    }

    @Test
    public void testNegativeDecimal16() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(10), 9, -21, -114, -53, 79, 71, 120, -17, 118, -1, -1, -1, -1, -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DECIMAL16);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)new BigDecimal("-9876543210.123456789"));
    }

    @Test
    public void testDate() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(11), -12, 67, 0, 0});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DATE);
        Assertions.assertThat((String)DateTimeUtil.daysToIsoDate((int)((Integer)value.get()))).isEqualTo("2017-08-18");
    }

    @Test
    public void testNegativeDate() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(11), -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.DATE);
        Assertions.assertThat((String)DateTimeUtil.daysToIsoDate((int)((Integer)value.get()))).isEqualTo("1969-12-31");
    }

    @Test
    public void testTimestamptz() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(12), 24, -45, -79, -42, 7, 87, 5, 0});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.TIMESTAMPTZ);
        Assertions.assertThat((String)DateTimeUtil.microsToIsoTimestamptz((long)((Long)value.get()))).isEqualTo("2017-08-18T14:21:01.919+00:00");
    }

    @Test
    public void testNegativeTimestamptz() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(12), -1, -1, -1, -1, -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.TIMESTAMPTZ);
        Assertions.assertThat((String)DateTimeUtil.microsToIsoTimestamptz((long)((Long)value.get()))).isEqualTo("1969-12-31T23:59:59.999999+00:00");
    }

    @Test
    public void testTimestampntz() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(13), 24, -45, -79, -42, 7, 87, 5, 0});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.TIMESTAMPNTZ);
        Assertions.assertThat((String)DateTimeUtil.microsToIsoTimestamp((long)((Long)value.get()))).isEqualTo("2017-08-18T14:21:01.919");
    }

    @Test
    public void testNegativeTimestampntz() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(13), -1, -1, -1, -1, -1, -1, -1, -1});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.TIMESTAMPNTZ);
        Assertions.assertThat((String)DateTimeUtil.microsToIsoTimestamp((long)((Long)value.get()))).isEqualTo("1969-12-31T23:59:59.999999");
    }

    @Test
    public void testFloat() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(14), -46, 2, -106, 73});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.FLOAT);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)Float.valueOf(Float.intBitsToFloat(1234567890)));
    }

    @Test
    public void testNegativeFloat() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(14), 0, 0, 0, -128});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.FLOAT);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)Float.valueOf(-0.0f));
    }

    @Test
    public void testBinary() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(15), 5, 0, 0, 0, 97, 98, 99, 100, 101});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.BINARY);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)ByteBuffer.wrap(new byte[]{97, 98, 99, 100, 101}));
    }

    @Test
    public void testString() {
        SerializedPrimitive value = SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(16), 7, 0, 0, 0, 105, 99, 101, 98, 101, 114, 103});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)"iceberg");
    }

    @Test
    public void testShortString() {
        SerializedShortString value = SerializedShortString.from((byte[])new byte[]{29, 105, 99, 101, 98, 101, 114, 103});
        Assertions.assertThat((Comparable)value.type()).isEqualTo((Object)PhysicalType.STRING);
        Assertions.assertThat((Object)value.get()).isEqualTo((Object)"iceberg");
    }

    @Test
    public void testUnsupportedType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SerializedPrimitive.from((byte[])new byte[]{TestSerializedPrimitives.primitiveHeader(17)})).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Unknown primitive physical type: 17");
    }

    private static byte primitiveHeader(int primitiveType) {
        return (byte)(primitiveType << 2);
    }
}

