/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.Serialized;
import org.apache.iceberg.variants.SerializedMetadata;
import org.apache.iceberg.variants.SerializedPrimitive;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;

public class VariantTestUtil {
    private VariantTestUtil() {
    }

    public static void assertEqual(VariantMetadata expected, VariantMetadata actual) {
        AssertionsForClassTypes.assertThat((Object)actual).isNotNull();
        AssertionsForClassTypes.assertThat((Object)expected).isNotNull();
        ((AbstractIntegerAssert)AssertionsForClassTypes.assertThat((int)actual.dictionarySize()).as("Dictionary size should match", new Object[0])).isEqualTo(expected.dictionarySize());
        for (int i = 0; i < expected.dictionarySize(); ++i) {
            AssertionsForClassTypes.assertThat((String)actual.get(i)).isEqualTo(expected.get(i));
        }
    }

    public static void assertEqual(VariantValue expected, VariantValue actual) {
        AssertionsForClassTypes.assertThat((Object)actual).isNotNull();
        AssertionsForClassTypes.assertThat((Object)expected).isNotNull();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)actual.type()).as("Variant type should match", new Object[0])).isEqualTo((Object)expected.type());
        if (expected.type() == PhysicalType.OBJECT) {
            VariantObject expectedObject = expected.asObject();
            VariantObject actualObject = actual.asObject();
            ((AbstractIntegerAssert)AssertionsForClassTypes.assertThat((int)actualObject.numFields()).as("Variant object num fields should match", new Object[0])).isEqualTo(expectedObject.numFields());
            for (String fieldName : expectedObject.fieldNames()) {
                VariantTestUtil.assertEqual(expectedObject.get(fieldName), actualObject.get(fieldName));
            }
        } else if (expected.type() == PhysicalType.ARRAY) {
            VariantArray expectedArray = expected.asArray();
            VariantArray actualArray = actual.asArray();
            ((AbstractIntegerAssert)AssertionsForClassTypes.assertThat((int)actualArray.numElements()).as("Variant array num element should match", new Object[0])).isEqualTo(expectedArray.numElements());
            for (int i = 0; i < expectedArray.numElements(); ++i) {
                VariantTestUtil.assertEqual(expectedArray.get(i), actualArray.get(i));
            }
        } else {
            ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)actual.asPrimitive().get()).as("Variant primitive value should match", new Object[0])).isEqualTo(expected.asPrimitive().get());
        }
    }

    private static byte primitiveHeader(int primitiveType) {
        return (byte)(primitiveType << 2);
    }

    private static byte metadataHeader(boolean isSorted, int offsetSize) {
        return (byte)(offsetSize - 1 << 6 | (isSorted ? 16 : 0) | 1);
    }

    private static int writeBufferAbsolute(ByteBuffer buffer, int offset, ByteBuffer toCopy) {
        int originalPosition = buffer.position();
        buffer.position(offset);
        ByteBuffer copy = toCopy.duplicate();
        buffer.put(copy);
        buffer.position(originalPosition);
        Preconditions.checkArgument((copy.remaining() <= 0 ? 1 : 0) != 0, (Object)"Not fully written");
        return toCopy.remaining();
    }

    static SerializedPrimitive createString(String string) {
        byte[] utf8 = string.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(5 + utf8.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, VariantTestUtil.primitiveHeader(16));
        buffer.putInt(1, utf8.length);
        VariantTestUtil.writeBufferAbsolute(buffer, 5, ByteBuffer.wrap(utf8));
        return SerializedPrimitive.from((ByteBuffer)buffer, (int)buffer.get(0));
    }

    public static ByteBuffer variantBuffer(Map<String, VariantValue> data) {
        ByteBuffer meta = VariantTestUtil.createMetadata(data.keySet(), true);
        ByteBuffer value = VariantTestUtil.createObject(meta, data);
        ByteBuffer buffer = ByteBuffer.allocate(meta.remaining() + value.remaining()).order(ByteOrder.LITTLE_ENDIAN);
        VariantTestUtil.writeBufferAbsolute(buffer, 0, meta);
        VariantTestUtil.writeBufferAbsolute(buffer, meta.remaining(), value);
        return buffer;
    }

    public static Variant variant(Map<String, VariantValue> data) {
        return Variant.from((ByteBuffer)VariantTestUtil.variantBuffer(data));
    }

    public static ByteBuffer emptyMetadata() {
        return VariantTestUtil.createMetadata((Collection<String>)ImmutableList.of(), true);
    }

    public static ByteBuffer createMetadata(Collection<String> fieldNames, boolean sortNames) {
        if (fieldNames.isEmpty()) {
            return SerializedMetadata.EMPTY_V1_BUFFER;
        }
        int numElements = fieldNames.size();
        Stream<String> names = sortNames ? fieldNames.stream().sorted() : fieldNames.stream();
        ByteBuffer[] nameBuffers = (ByteBuffer[])names.map(str -> ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8))).toArray(ByteBuffer[]::new);
        int dataSize = 0;
        for (ByteBuffer nameBuffer : nameBuffers) {
            dataSize += nameBuffer.remaining();
        }
        int offsetSize = VariantUtil.sizeOf((int)dataSize);
        int offsetListOffset = 1 + offsetSize;
        int dataOffset = offsetListOffset + (1 + numElements) * offsetSize;
        int totalSize = dataOffset + dataSize;
        byte header = VariantTestUtil.metadataHeader(sortNames, offsetSize);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, header);
        VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)numElements, (int)1, (int)offsetSize);
        int nextOffset = 0;
        int index = 0;
        for (ByteBuffer nameBuffer : nameBuffers) {
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
            int nameSize = VariantTestUtil.writeBufferAbsolute(buffer, dataOffset + nextOffset, nameBuffer);
            nextOffset += nameSize;
            ++index;
        }
        VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
        return buffer;
    }

    public static ByteBuffer createObject(ByteBuffer metadataBuffer, Map<String, VariantValue> data) {
        return VariantTestUtil.createObject((VariantMetadata)SerializedMetadata.from((ByteBuffer)metadataBuffer), data);
    }

    public static ByteBuffer createObject(VariantMetadata metadata, Map<String, VariantValue> data) {
        int numElements = data.size();
        boolean isLarge = numElements > 255;
        int dataSize = 0;
        for (Map.Entry<String, VariantValue> field : data.entrySet()) {
            dataSize += field.getValue().sizeInBytes();
        }
        int fieldIdSize = VariantUtil.sizeOf((int)metadata.dictionarySize());
        int fieldIdListOffset = 1 + (isLarge ? 4 : 1);
        int offsetSize = VariantUtil.sizeOf((int)dataSize);
        int offsetListOffset = fieldIdListOffset + numElements * fieldIdSize;
        int dataOffset = offsetListOffset + (1 + numElements) * offsetSize;
        int totalSize = dataOffset + dataSize;
        byte header = VariantUtil.objectHeader((boolean)isLarge, (int)fieldIdSize, (int)offsetSize);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, header);
        if (isLarge) {
            buffer.putInt(1, numElements);
        } else {
            buffer.put(1, (byte)(numElements & 0xFF));
        }
        int nextOffset = 0;
        int index = 0;
        List sortedFieldNames = data.keySet().stream().sorted().collect(Collectors.toList());
        for (String fieldName : sortedFieldNames) {
            int id = metadata.id(fieldName);
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)id, (int)(fieldIdListOffset + index * fieldIdSize), (int)fieldIdSize);
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
            int valueSize = data.get(fieldName).writeTo(buffer, dataOffset + nextOffset);
            nextOffset += valueSize;
            ++index;
        }
        VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
        return buffer;
    }

    static ByteBuffer createArray(Serialized ... values) {
        int numElements = values.length;
        boolean isLarge = numElements > 255;
        int dataSize = 0;
        for (Serialized value : values) {
            dataSize += value.buffer().remaining();
        }
        int offsetSize = VariantUtil.sizeOf((int)dataSize);
        int offsetListOffset = 1 + (isLarge ? 4 : 1);
        int dataOffset = offsetListOffset + (1 + numElements) * offsetSize;
        int totalSize = dataOffset + dataSize;
        byte header = VariantUtil.arrayHeader((boolean)isLarge, (int)offsetSize);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, header);
        if (isLarge) {
            buffer.putInt(1, numElements);
        } else {
            buffer.put(1, (byte)(numElements & 0xFF));
        }
        int nextOffset = 0;
        int index = 0;
        for (Serialized value : values) {
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
            ByteBuffer valueBuffer = value.buffer();
            int valueSize = VariantTestUtil.writeBufferAbsolute(buffer, dataOffset + nextOffset, valueBuffer);
            nextOffset += valueSize;
            ++index;
        }
        VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
        return buffer;
    }
}

