/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.function.IntConsumer;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.iceberg.arrow.ArrowSchemaUtil;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessor;
import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DictEncodedArrowConverter {
    private DictEncodedArrowConverter() {
    }

    public static FieldVector toArrowVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        Preconditions.checkArgument((null != vectorHolder ? 1 : 0) != 0, (Object)"Invalid vector holder: null");
        Preconditions.checkArgument((null != accessor ? 1 : 0) != 0, (Object)"Invalid arrow vector accessor: null");
        if (vectorHolder.isDictionaryEncoded()) {
            if (Type.TypeID.DECIMAL.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toDecimalVector(vectorHolder, accessor);
            }
            if (Type.TypeID.TIMESTAMP.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toTimestampVector(vectorHolder, accessor);
            }
            if (Type.TypeID.LONG.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toBigIntVector(vectorHolder, accessor);
            }
            if (Type.TypeID.FLOAT.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toFloat4Vector(vectorHolder, accessor);
            }
            if (Type.TypeID.DOUBLE.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toFloat8Vector(vectorHolder, accessor);
            }
            if (Type.TypeID.STRING.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toVarCharVector(vectorHolder, accessor);
            }
            if (Type.TypeID.BINARY.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toVarBinaryVector(vectorHolder, accessor);
            }
            if (Type.TypeID.TIME.equals((Object)vectorHolder.icebergType().typeId())) {
                return DictEncodedArrowConverter.toTimeMicroVector(vectorHolder, accessor);
            }
            throw new IllegalArgumentException(String.format("Cannot convert dict encoded field '%s' of type '%s' to Arrow vector as it is currently not supported", vectorHolder.icebergField().name(), vectorHolder.icebergType().typeId()));
        }
        return vectorHolder.vector();
    }

    private static DecimalVector toDecimalVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        int precision = ((Types.DecimalType)vectorHolder.icebergType()).precision();
        int scale = ((Types.DecimalType)vectorHolder.icebergType()).scale();
        DecimalVector vector = new DecimalVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseFixedWidthVector)vector, vectorHolder, (int idx) -> vector.set(idx, (BigDecimal)accessor.getDecimal(idx, precision, scale)));
        return vector;
    }

    private static TimeStampVector toTimestampVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        Object vector = ((Types.TimestampType)vectorHolder.icebergType()).shouldAdjustToUTC() ? new TimeStampMicroTZVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator()) : new TimeStampMicroVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseFixedWidthVector)vector, vectorHolder, arg_0 -> DictEncodedArrowConverter.lambda$toTimestampVector$1((TimeStampVector)vector, accessor, arg_0));
        return vector;
    }

    private static BigIntVector toBigIntVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        BigIntVector vector = new BigIntVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseFixedWidthVector)vector, vectorHolder, (int idx) -> vector.set(idx, accessor.getLong(idx)));
        return vector;
    }

    private static Float4Vector toFloat4Vector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        Float4Vector vector = new Float4Vector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseFixedWidthVector)vector, vectorHolder, (int idx) -> vector.set(idx, accessor.getFloat(idx)));
        return vector;
    }

    private static Float8Vector toFloat8Vector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        Float8Vector vector = new Float8Vector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseFixedWidthVector)vector, vectorHolder, (int idx) -> vector.set(idx, accessor.getDouble(idx)));
        return vector;
    }

    private static VarCharVector toVarCharVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        VarCharVector vector = new VarCharVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseVariableWidthVector)vector, vectorHolder, (int idx) -> vector.setSafe(idx, ((String)accessor.getUTF8String(idx)).getBytes(StandardCharsets.UTF_8)));
        return vector;
    }

    private static VarBinaryVector toVarBinaryVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        VarBinaryVector vector = new VarBinaryVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseVariableWidthVector)vector, vectorHolder, (int idx) -> vector.setSafe(idx, accessor.getBinary(idx)));
        return vector;
    }

    private static TimeMicroVector toTimeMicroVector(VectorHolder vectorHolder, ArrowVectorAccessor<?, String, ?, ?> accessor) {
        TimeMicroVector vector = new TimeMicroVector(vectorHolder.vector().getName(), ArrowSchemaUtil.convert(vectorHolder.icebergField()).getFieldType(), vectorHolder.vector().getAllocator());
        DictEncodedArrowConverter.initVector((BaseFixedWidthVector)vector, vectorHolder, (int idx) -> vector.set(idx, accessor.getLong(idx)));
        return vector;
    }

    private static void initVector(BaseFixedWidthVector vector, VectorHolder vectorHolder, IntConsumer consumer) {
        vector.allocateNew(vectorHolder.vector().getValueCount());
        DictEncodedArrowConverter.init((FieldVector)vector, vectorHolder, consumer, vectorHolder.vector().getValueCount());
    }

    private static void initVector(BaseVariableWidthVector vector, VectorHolder vectorHolder, IntConsumer consumer) {
        vector.allocateNew(vectorHolder.vector().getValueCount());
        DictEncodedArrowConverter.init((FieldVector)vector, vectorHolder, consumer, vectorHolder.vector().getValueCount());
    }

    private static void init(FieldVector vector, VectorHolder vectorHolder, IntConsumer consumer, int valueCount) {
        for (int i = 0; i < valueCount; ++i) {
            if (DictEncodedArrowConverter.isNullAt(vectorHolder, i)) {
                vector.setNull(i);
                continue;
            }
            consumer.accept(i);
        }
        vector.setValueCount(valueCount);
    }

    private static boolean isNullAt(VectorHolder vectorHolder, int idx) {
        return vectorHolder.nullabilityHolder().isNullAt(idx) == 1;
    }

    private static /* synthetic */ void lambda$toTimestampVector$1(TimeStampVector vector, ArrowVectorAccessor accessor, int idx) {
        vector.set(idx, accessor.getLong(idx));
    }
}

