/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.arrow.vector.NullCheckingForGet;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.arrow.vectorized.ArrowBatchReader;
import org.apache.iceberg.arrow.vectorized.ColumnarBatch;
import org.apache.iceberg.arrow.vectorized.VectorizedReaderBuilder;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.ExceptionUtil;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowReader
extends CloseableGroup {
    private static final Logger LOG = LoggerFactory.getLogger(ArrowReader.class);
    private static final Set<Type.TypeID> SUPPORTED_TYPES = ImmutableSet.of((Object)Type.TypeID.BOOLEAN, (Object)Type.TypeID.INTEGER, (Object)Type.TypeID.LONG, (Object)Type.TypeID.FLOAT, (Object)Type.TypeID.DOUBLE, (Object)Type.TypeID.STRING, (Object[])new Type.TypeID[]{Type.TypeID.TIMESTAMP, Type.TypeID.BINARY, Type.TypeID.DATE, Type.TypeID.UUID, Type.TypeID.TIME, Type.TypeID.DECIMAL});
    private final Schema schema;
    private final FileIO io;
    private final EncryptionManager encryption;
    private final int batchSize;
    private final boolean reuseContainers;

    public ArrowReader(TableScan scan, int batchSize, boolean reuseContainers) {
        this.schema = scan.schema();
        this.io = scan.table().io();
        this.encryption = scan.table().encryption();
        this.batchSize = batchSize;
        this.reuseContainers = reuseContainers;
    }

    public CloseableIterator<ColumnarBatch> open(CloseableIterable<CombinedScanTask> tasks) {
        VectorizedCombinedScanIterator itr = new VectorizedCombinedScanIterator(tasks, this.schema, null, this.io, this.encryption, true, this.batchSize, this.reuseContainers);
        this.addCloseable((Closeable)((Object)itr));
        return itr;
    }

    public void close() throws IOException {
        super.close();
    }

    private static final class VectorizedCombinedScanIterator
    implements CloseableIterator<ColumnarBatch> {
        private final Iterator<FileScanTask> fileItr;
        private final Map<String, InputFile> inputFiles;
        private final Schema expectedSchema;
        private final String nameMapping;
        private final boolean caseSensitive;
        private final int batchSize;
        private final boolean reuseContainers;
        private CloseableIterator<ColumnarBatch> currentIterator;
        private FileScanTask currentTask;

        VectorizedCombinedScanIterator(CloseableIterable<CombinedScanTask> tasks, Schema expectedSchema, String nameMapping, FileIO io, EncryptionManager encryptionManager, boolean caseSensitive, int batchSize, boolean reuseContainers) {
            List fileTasks = StreamSupport.stream(tasks.spliterator(), false).map(CombinedScanTask::files).flatMap(Collection::stream).collect(Collectors.toList());
            this.fileItr = fileTasks.iterator();
            if (fileTasks.stream().anyMatch(TableScanUtil::hasDeletes)) {
                throw new UnsupportedOperationException("Cannot read files that require applying delete files");
            }
            if (expectedSchema.columns().isEmpty()) {
                throw new UnsupportedOperationException("Cannot read without at least one projected column");
            }
            Sets.SetView unsupportedTypes = Sets.difference(expectedSchema.columns().stream().map(c -> c.type().typeId()).collect(Collectors.toSet()), SUPPORTED_TYPES);
            if (!unsupportedTypes.isEmpty()) {
                throw new UnsupportedOperationException("Cannot read unsupported column types: " + (Set)unsupportedTypes);
            }
            HashMap keyMetadata = Maps.newHashMap();
            fileTasks.stream().map(ContentScanTask::file).forEach(file -> keyMetadata.put(file.path().toString(), file.keyMetadata()));
            Stream<EncryptedInputFile> encrypted = keyMetadata.entrySet().stream().map(entry -> EncryptedFiles.encryptedInput((InputFile)io.newInputFile((String)entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue())));
            Iterable decryptedFiles = encryptionManager.decrypt(encrypted::iterator);
            HashMap files = Maps.newHashMapWithExpectedSize((int)fileTasks.size());
            decryptedFiles.forEach(decrypted -> files.putIfAbsent(decrypted.location(), decrypted));
            this.inputFiles = ImmutableMap.copyOf((Map)files);
            this.currentIterator = CloseableIterator.empty();
            this.expectedSchema = expectedSchema;
            this.nameMapping = nameMapping;
            this.caseSensitive = caseSensitive;
            this.batchSize = batchSize;
            this.reuseContainers = reuseContainers;
        }

        public boolean hasNext() {
            try {
                while (true) {
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    if (!this.fileItr.hasNext()) break;
                    this.currentIterator.close();
                    this.currentTask = this.fileItr.next();
                    this.currentIterator = this.open(this.currentTask);
                }
                this.currentIterator.close();
                return false;
            }
            catch (IOException | RuntimeException e) {
                if (this.currentTask != null && !this.currentTask.isDataTask()) {
                    LOG.error("Error reading file: {}", (Object)this.getInputFile(this.currentTask).location(), (Object)e);
                }
                ExceptionUtil.castAndThrow((Throwable)e, RuntimeException.class);
                return false;
            }
        }

        public ColumnarBatch next() {
            if (this.hasNext()) {
                return (ColumnarBatch)this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        CloseableIterator<ColumnarBatch> open(FileScanTask task) {
            Parquet.ReadBuilder builder;
            InputFile location = this.getInputFile(task);
            Preconditions.checkNotNull((Object)location, (Object)"Could not find InputFile associated with FileScanTask");
            if (((DataFile)task.file()).format() == FileFormat.PARQUET) {
                builder = Parquet.read((InputFile)location).project(this.expectedSchema).split(task.start(), task.length()).createBatchedReaderFunc(fileSchema -> VectorizedCombinedScanIterator.buildReader(this.expectedSchema, fileSchema, NullCheckingForGet.NULL_CHECKING_ENABLED)).recordsPerBatch(this.batchSize).filter(task.residual()).caseSensitive(this.caseSensitive);
                if (this.reuseContainers) {
                    builder.reuseContainers();
                }
                if (this.nameMapping != null) {
                    builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
                }
            } else {
                throw new UnsupportedOperationException("Format: " + ((DataFile)task.file()).format() + " not supported for batched reads");
            }
            CloseableIterable iter = builder.build();
            return iter.iterator();
        }

        public void close() throws IOException {
            this.currentIterator.close();
            while (this.fileItr.hasNext()) {
                this.fileItr.next();
            }
        }

        private InputFile getInputFile(FileScanTask task) {
            Preconditions.checkArgument((!task.isDataTask() ? 1 : 0) != 0, (Object)"Invalid task type");
            return this.inputFiles.get(((DataFile)task.file()).path().toString());
        }

        private static ArrowBatchReader buildReader(Schema expectedSchema, MessageType fileSchema, boolean setArrowValidityVector) {
            return (ArrowBatchReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new VectorizedReaderBuilder(expectedSchema, fileSchema, setArrowValidityVector, (Map<Integer, ?>)ImmutableMap.of(), ArrowBatchReader::new));
        }
    }
}

