/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.arrow.ArrowAllocation;
import org.apache.iceberg.arrow.ArrowSchemaUtil;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedColumnIterator;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class VectorizedArrowReader
implements VectorizedReader<VectorHolder> {
    public static final int DEFAULT_BATCH_SIZE = 5000;
    private static final Integer UNKNOWN_WIDTH = null;
    private static final int AVERAGE_VARIABLE_WIDTH_RECORD_SIZE = 10;
    private final ColumnDescriptor columnDescriptor;
    private final VectorizedColumnIterator vectorizedColumnIterator;
    private final Types.NestedField icebergField;
    private final BufferAllocator rootAlloc;
    private int batchSize;
    private FieldVector vec;
    private Integer typeWidth;
    private ReadType readType;
    private NullabilityHolder nullabilityHolder;
    private Dictionary dictionary;

    public VectorizedArrowReader(ColumnDescriptor desc, Types.NestedField icebergField, BufferAllocator ra, boolean setArrowValidityVector) {
        this.icebergField = icebergField;
        this.columnDescriptor = desc;
        this.rootAlloc = ra;
        this.vectorizedColumnIterator = new VectorizedColumnIterator(desc, "", setArrowValidityVector);
    }

    private VectorizedArrowReader() {
        this(null);
    }

    private VectorizedArrowReader(Types.NestedField icebergField) {
        this.icebergField = icebergField;
        this.batchSize = 5000;
        this.columnDescriptor = null;
        this.rootAlloc = null;
        this.vectorizedColumnIterator = null;
    }

    protected Types.NestedField icebergField() {
        return this.icebergField;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize == 0 ? 5000 : batchSize;
        this.vectorizedColumnIterator.setBatchSize(batchSize);
    }

    public VectorHolder read(VectorHolder reuse, int numValsToRead) {
        boolean dictEncoded = this.vectorizedColumnIterator.producesDictionaryEncodedVector();
        if (reuse == null || !dictEncoded && this.readType == ReadType.DICTIONARY || dictEncoded && this.readType != ReadType.DICTIONARY) {
            this.allocateFieldVector(dictEncoded);
            this.nullabilityHolder = new NullabilityHolder(this.batchSize);
        } else {
            this.vec.setValueCount(0);
            this.nullabilityHolder.reset();
        }
        if (this.vectorizedColumnIterator.hasNext()) {
            if (dictEncoded) {
                this.vectorizedColumnIterator.dictionaryBatchReader().nextBatch(this.vec, -1, this.nullabilityHolder);
            } else {
                switch (this.readType) {
                    case VARBINARY: 
                    case VARCHAR: {
                        this.vectorizedColumnIterator.varWidthTypeBatchReader().nextBatch(this.vec, -1, this.nullabilityHolder);
                        break;
                    }
                    case BOOLEAN: {
                        this.vectorizedColumnIterator.booleanBatchReader().nextBatch(this.vec, -1, this.nullabilityHolder);
                        break;
                    }
                    case INT: 
                    case INT_BACKED_DECIMAL: {
                        this.vectorizedColumnIterator.integerBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case LONG: 
                    case LONG_BACKED_DECIMAL: {
                        this.vectorizedColumnIterator.longBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case FLOAT: {
                        this.vectorizedColumnIterator.floatBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case DOUBLE: {
                        this.vectorizedColumnIterator.doubleBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case TIMESTAMP_MILLIS: {
                        this.vectorizedColumnIterator.timestampMillisBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case TIMESTAMP_INT96: {
                        this.vectorizedColumnIterator.timestampInt96BatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case UUID: 
                    case FIXED_WIDTH_BINARY: 
                    case FIXED_LENGTH_DECIMAL: {
                        this.vectorizedColumnIterator.fixedSizeBinaryBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                    }
                }
            }
        }
        Preconditions.checkState((this.vec.getValueCount() == numValsToRead ? 1 : 0) != 0, (String)"Number of values read, %s, does not equal expected, %s", (int)this.vec.getValueCount(), (int)numValsToRead);
        return new VectorHolder(this.columnDescriptor, this.vec, dictEncoded, this.dictionary, this.nullabilityHolder, this.icebergField);
    }

    private void allocateFieldVector(boolean dictionaryEncodedVector) {
        if (dictionaryEncodedVector) {
            this.allocateDictEncodedVector();
        } else {
            Field arrowField = ArrowSchemaUtil.convert(VectorizedArrowReader.getPhysicalType(this.columnDescriptor, this.icebergField));
            if (this.columnDescriptor.getPrimitiveType().getOriginalType() != null) {
                this.allocateVectorBasedOnOriginalType(this.columnDescriptor.getPrimitiveType(), arrowField);
            } else {
                this.allocateVectorBasedOnTypeName(this.columnDescriptor.getPrimitiveType(), arrowField);
            }
        }
    }

    private static Types.NestedField getPhysicalType(ColumnDescriptor desc, Types.NestedField logicalType) {
        PrimitiveType primitive = desc.getPrimitiveType();
        PrimitiveType.PrimitiveTypeName typeName = primitive.getPrimitiveTypeName();
        Types.NestedField physicalType = logicalType;
        if (OriginalType.DECIMAL.equals((Object)primitive.getOriginalType())) {
            Object type = PrimitiveType.PrimitiveTypeName.INT64.equals((Object)typeName) ? Types.LongType.get() : (PrimitiveType.PrimitiveTypeName.INT32.equals((Object)typeName) ? Types.IntegerType.get() : Types.FixedType.ofLength((int)primitive.getTypeLength()));
            physicalType = Types.NestedField.of((int)logicalType.fieldId(), (boolean)logicalType.isOptional(), (String)logicalType.name(), (Type)type);
        }
        return physicalType;
    }

    private void allocateDictEncodedVector() {
        Field field = new Field(this.icebergField.name(), new FieldType(this.icebergField.isOptional(), (ArrowType)new ArrowType.Int(32, true), null, null), null);
        this.vec = field.createVector(this.rootAlloc);
        ((IntVector)this.vec).allocateNew(this.batchSize);
        this.typeWidth = 4;
        this.readType = ReadType.DICTIONARY;
    }

    private void allocateVectorBasedOnOriginalType(PrimitiveType primitive, Field arrowField) {
        block0 : switch (primitive.getOriginalType()) {
            case ENUM: 
            case JSON: 
            case UTF8: 
            case BSON: {
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * 10);
                this.vec.allocateNewSafe();
                this.readType = ReadType.VARCHAR;
                this.typeWidth = UNKNOWN_WIDTH;
                break;
            }
            case INT_8: 
            case INT_16: 
            case INT_32: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((IntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.INT;
                this.typeWidth = 4;
                break;
            }
            case DATE: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((DateDayVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.INT;
                this.typeWidth = 4;
                break;
            }
            case INT_64: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((BigIntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.LONG;
                this.typeWidth = 8;
                break;
            }
            case TIMESTAMP_MILLIS: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((BigIntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.TIMESTAMP_MILLIS;
                this.typeWidth = 8;
                break;
            }
            case TIMESTAMP_MICROS: {
                this.vec = arrowField.createVector(this.rootAlloc);
                if (((Types.TimestampType)this.icebergField.type()).shouldAdjustToUTC()) {
                    ((TimeStampMicroTZVector)this.vec).allocateNew(this.batchSize);
                } else {
                    ((TimeStampMicroVector)this.vec).allocateNew(this.batchSize);
                }
                this.readType = ReadType.LONG;
                this.typeWidth = 8;
                break;
            }
            case TIME_MICROS: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((TimeMicroVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.LONG;
                this.typeWidth = 8;
                break;
            }
            case DECIMAL: {
                this.vec = arrowField.createVector(this.rootAlloc);
                switch (primitive.getPrimitiveTypeName()) {
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        ((FixedSizeBinaryVector)this.vec).allocateNew(this.batchSize);
                        this.readType = ReadType.FIXED_LENGTH_DECIMAL;
                        this.typeWidth = primitive.getTypeLength();
                        break block0;
                    }
                    case INT64: {
                        ((BigIntVector)this.vec).allocateNew(this.batchSize);
                        this.readType = ReadType.LONG_BACKED_DECIMAL;
                        this.typeWidth = 8;
                        break block0;
                    }
                    case INT32: {
                        ((IntVector)this.vec).allocateNew(this.batchSize);
                        this.readType = ReadType.INT_BACKED_DECIMAL;
                        this.typeWidth = 4;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unsupported base type for decimal: " + primitive.getPrimitiveTypeName());
            }
            default: {
                throw new UnsupportedOperationException("Unsupported logical type: " + primitive.getOriginalType());
            }
        }
    }

    private void allocateVectorBasedOnTypeName(PrimitiveType primitive, Field arrowField) {
        switch (primitive.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: {
                int len;
                if (this.icebergField.type() instanceof Types.UUIDType) {
                    len = 16;
                    this.readType = ReadType.UUID;
                } else {
                    len = ((Types.FixedType)this.icebergField.type()).length();
                    this.readType = ReadType.FIXED_WIDTH_BINARY;
                }
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * len);
                this.vec.allocateNew();
                this.typeWidth = len;
                break;
            }
            case BINARY: {
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * 10);
                this.vec.allocateNewSafe();
                this.readType = ReadType.VARBINARY;
                this.typeWidth = UNKNOWN_WIDTH;
                break;
            }
            case INT32: {
                Field intField = new Field(this.icebergField.name(), new FieldType(this.icebergField.isOptional(), (ArrowType)new ArrowType.Int(32, true), null, null), null);
                this.vec = intField.createVector(this.rootAlloc);
                ((IntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.INT;
                this.typeWidth = 4;
                break;
            }
            case INT96: {
                int length = 8;
                this.readType = ReadType.TIMESTAMP_INT96;
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * length);
                this.vec.allocateNew();
                this.typeWidth = length;
                break;
            }
            case FLOAT: {
                Field floatField = new Field(this.icebergField.name(), new FieldType(this.icebergField.isOptional(), (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null, null), null);
                this.vec = floatField.createVector(this.rootAlloc);
                ((Float4Vector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.FLOAT;
                this.typeWidth = 4;
                break;
            }
            case BOOLEAN: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((BitVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.BOOLEAN;
                this.typeWidth = UNKNOWN_WIDTH;
                break;
            }
            case INT64: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((BigIntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.LONG;
                this.typeWidth = 8;
                break;
            }
            case DOUBLE: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((Float8Vector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.DOUBLE;
                this.typeWidth = 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + primitive);
            }
        }
    }

    public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata, long rowPosition) {
        ColumnChunkMetaData chunkMetaData = metadata.get(ColumnPath.get((String[])this.columnDescriptor.getPath()));
        this.dictionary = this.vectorizedColumnIterator.setRowGroupInfo(source.getPageReader(this.columnDescriptor), !ParquetUtil.hasNonDictionaryPages((ColumnChunkMetaData)chunkMetaData));
    }

    public void close() {
        if (this.vec != null) {
            this.vec.close();
        }
    }

    public String toString() {
        return this.columnDescriptor.toString();
    }

    public static VectorizedArrowReader nulls() {
        return NullVectorReader.INSTANCE;
    }

    public static VectorizedArrowReader positions() {
        return new PositionVectorReader(false);
    }

    public static VectorizedArrowReader positionsWithSetArrowValidityVector() {
        return new PositionVectorReader(true);
    }

    public static class DeletedVectorReader
    extends VectorizedArrowReader {
        public DeletedVectorReader() {
            super(MetadataColumns.IS_DELETED);
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            return VectorHolder.deletedVectorHolder(numValsToRead);
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata, long rowPosition) {
        }

        @Override
        public String toString() {
            return "DeletedVectorReader";
        }

        @Override
        public void setBatchSize(int batchSize) {
        }
    }

    public static class ConstantVectorReader<T>
    extends VectorizedArrowReader {
        private final T value;

        public ConstantVectorReader(Types.NestedField icebergField, T value) {
            super(icebergField);
            this.value = value;
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            return VectorHolder.constantHolder(this.icebergField(), numValsToRead, this.value);
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata, long rowPosition) {
        }

        @Override
        public String toString() {
            return String.format("ConstantReader: %s", this.value);
        }

        @Override
        public void setBatchSize(int batchSize) {
        }
    }

    private static final class PositionVectorReader
    extends VectorizedArrowReader {
        private static final Field ROW_POSITION_ARROW_FIELD = ArrowSchemaUtil.convert(MetadataColumns.ROW_POSITION);
        private final boolean setArrowValidityVector;
        private long rowStart;
        private int batchSize;
        private NullabilityHolder nulls;

        PositionVectorReader(boolean setArrowValidityVector) {
            super(MetadataColumns.ROW_POSITION);
            this.setArrowValidityVector = setArrowValidityVector;
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            FieldVector vec;
            if (reuse == null) {
                vec = PositionVectorReader.newVector(this.batchSize);
            } else {
                vec = reuse.vector();
                vec.setValueCount(0);
            }
            ArrowBuf dataBuffer = vec.getDataBuffer();
            for (int i = 0; i < numValsToRead; ++i) {
                dataBuffer.setLong((long)i * 8L, this.rowStart + (long)i);
            }
            if (this.setArrowValidityVector) {
                ArrowBuf validityBuffer = vec.getValidityBuffer();
                for (int i = 0; i < numValsToRead; ++i) {
                    BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)i);
                }
            }
            this.rowStart += (long)numValsToRead;
            vec.setValueCount(numValsToRead);
            return new VectorHolder.PositionVectorHolder(vec, MetadataColumns.ROW_POSITION, this.nulls);
        }

        private static BigIntVector newVector(int valueCount) {
            BigIntVector vector = (BigIntVector)ROW_POSITION_ARROW_FIELD.createVector((BufferAllocator)ArrowAllocation.rootAllocator());
            vector.allocateNew(valueCount);
            return vector;
        }

        private static NullabilityHolder newNullabilityHolder(int size) {
            NullabilityHolder nullabilityHolder = new NullabilityHolder(size);
            nullabilityHolder.setNotNulls(0, size);
            return nullabilityHolder;
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata, long rowPosition) {
            this.rowStart = rowPosition;
        }

        @Override
        public String toString() {
            return this.getClass().toString();
        }

        @Override
        public void setBatchSize(int batchSize) {
            if (this.nulls == null || this.nulls.size() < batchSize) {
                this.nulls = PositionVectorReader.newNullabilityHolder(batchSize);
            }
            this.batchSize = batchSize == 0 ? 5000 : batchSize;
        }

        @Override
        public void close() {
        }
    }

    private static final class NullVectorReader
    extends VectorizedArrowReader {
        private static final NullVectorReader INSTANCE = new NullVectorReader();

        private NullVectorReader() {
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            return VectorHolder.dummyHolder(numValsToRead);
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata, long rowPosition) {
        }

        @Override
        public String toString() {
            return "NullReader";
        }

        @Override
        public void setBatchSize(int batchSize) {
        }
    }

    private static enum ReadType {
        FIXED_LENGTH_DECIMAL,
        INT_BACKED_DECIMAL,
        LONG_BACKED_DECIMAL,
        VARCHAR,
        VARBINARY,
        FIXED_WIDTH_BINARY,
        BOOLEAN,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        TIMESTAMP_MILLIS,
        TIMESTAMP_INT96,
        TIME_MICROS,
        UUID,
        DICTIONARY;

    }
}

