/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.IntVector;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.parquet.BaseVectorizedParquetValuesReader;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.column.Dictionary;

public class VectorizedDictionaryEncodedParquetValuesReader
extends BaseVectorizedParquetValuesReader {
    public VectorizedDictionaryEncodedParquetValuesReader(int maxDefLevel, boolean setValidityVector) {
        super(maxDefLevel, setValidityVector);
    }

    public DictionaryIdReader dictionaryIdReader() {
        return new DictionaryIdReader();
    }

    public LongDictEncodedReader longDictEncodedReader() {
        return new LongDictEncodedReader();
    }

    public TimestampMillisDictEncodedReader timestampMillisDictEncodedReader() {
        return new TimestampMillisDictEncodedReader();
    }

    public TimestampInt96DictEncodedReader timestampInt96DictEncodedReader() {
        return new TimestampInt96DictEncodedReader();
    }

    public IntegerDictEncodedReader integerDictEncodedReader() {
        return new IntegerDictEncodedReader();
    }

    public FloatDictEncodedReader floatDictEncodedReader() {
        return new FloatDictEncodedReader();
    }

    public DoubleDictEncodedReader doubleDictEncodedReader() {
        return new DoubleDictEncodedReader();
    }

    @Deprecated
    public FixedWidthBinaryDictEncodedReader fixedWidthBinaryDictEncodedReader() {
        return new FixedWidthBinaryDictEncodedReader();
    }

    public VarWidthBinaryDictEncodedReader varWidthBinaryDictEncodedReader() {
        return new VarWidthBinaryDictEncodedReader();
    }

    public FixedSizeBinaryDictEncodedReader fixedSizeBinaryDictEncodedReader() {
        return new FixedSizeBinaryDictEncodedReader();
    }

    class FixedSizeBinaryDictEncodedReader
    extends BaseDictEncodedReader {
        FixedSizeBinaryDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            byte[] bytes = dict.decodeToBinary(currentVal).getBytesUnsafe();
            byte[] vectorBytes = new byte[typeWidth];
            System.arraycopy(bytes, 0, vectorBytes, 0, typeWidth);
            ((FixedSizeBinaryVector)vector).set(idx, vectorBytes);
        }
    }

    class VarWidthBinaryDictEncodedReader
    extends BaseDictEncodedReader {
        VarWidthBinaryDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            ByteBuffer buffer = dict.decodeToBinary(currentVal).toByteBuffer();
            ((BaseVariableWidthVector)vector).setSafe(idx, buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.limit() - buffer.position());
        }
    }

    @Deprecated
    class FixedWidthBinaryDictEncodedReader
    extends BaseDictEncodedReader {
        FixedWidthBinaryDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            ByteBuffer buffer = dict.decodeToBinary(currentVal).toByteBuffer();
            vector.getDataBuffer().setBytes((long)idx * (long)typeWidth, buffer);
        }
    }

    class DoubleDictEncodedReader
    extends BaseDictEncodedReader {
        DoubleDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            vector.getDataBuffer().setDouble((long)idx * (long)typeWidth, dict.decodeToDouble(currentVal));
        }
    }

    class FloatDictEncodedReader
    extends BaseDictEncodedReader {
        FloatDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            vector.getDataBuffer().setFloat((long)idx * (long)typeWidth, dict.decodeToFloat(currentVal));
        }
    }

    class IntegerDictEncodedReader
    extends BaseDictEncodedReader {
        IntegerDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            vector.getDataBuffer().setInt((long)idx * (long)typeWidth, dict.decodeToInt(currentVal));
        }
    }

    class TimestampInt96DictEncodedReader
    extends BaseDictEncodedReader {
        TimestampInt96DictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            ByteBuffer buffer = dict.decodeToBinary(currentVal).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long timestampInt96 = ParquetUtil.extractTimestampInt96((ByteBuffer)buffer);
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, timestampInt96);
        }
    }

    class TimestampMillisDictEncodedReader
    extends BaseDictEncodedReader {
        TimestampMillisDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, dict.decodeToLong(currentVal) * 1000L);
        }
    }

    class LongDictEncodedReader
    extends BaseDictEncodedReader {
        LongDictEncodedReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, dict.decodeToLong(currentVal));
        }
    }

    class DictionaryIdReader
    extends BaseDictEncodedReader {
        DictionaryIdReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, Dictionary dict, int idx, int currentVal, int typeWidth) {
            ((IntVector)vector).set(idx, currentVal);
        }
    }

    abstract class BaseDictEncodedReader {
        BaseDictEncodedReader() {
        }

        public void nextBatch(FieldVector vector, int startOffset, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth) {
            int left = numValuesToRead;
            int idx = startOffset;
            while (left > 0) {
                if (VectorizedDictionaryEncodedParquetValuesReader.this.currentCount == 0) {
                    VectorizedDictionaryEncodedParquetValuesReader.this.readNextGroup();
                }
                int numValues = Math.min(left, VectorizedDictionaryEncodedParquetValuesReader.this.currentCount);
                for (int i = 0; i < numValues; ++i) {
                    if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)VectorizedDictionaryEncodedParquetValuesReader.this.mode)) {
                        this.nextVal(vector, dict, idx, VectorizedDictionaryEncodedParquetValuesReader.this.currentValue, typeWidth);
                    } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)VectorizedDictionaryEncodedParquetValuesReader.this.mode)) {
                        this.nextVal(vector, dict, idx, VectorizedDictionaryEncodedParquetValuesReader.this.packedValuesBuffer[VectorizedDictionaryEncodedParquetValuesReader.this.packedValuesBufferIdx++], typeWidth);
                    }
                    nullabilityHolder.setNotNull(idx);
                    if (VectorizedDictionaryEncodedParquetValuesReader.this.setArrowValidityVector) {
                        BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)idx);
                    }
                    ++idx;
                }
                left -= numValues;
                VectorizedDictionaryEncodedParquetValuesReader.this.currentCount -= numValues;
            }
        }

        protected abstract void nextVal(FieldVector var1, Dictionary var2, int var3, int var4, int var5);
    }
}

