/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.parquet.BaseVectorizedParquetValuesReader;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedDictionaryEncodedParquetValuesReader;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.ValuesAsBytesReader;
import org.apache.parquet.column.Dictionary;

public final class VectorizedParquetDefinitionLevelReader
extends BaseVectorizedParquetValuesReader {
    public VectorizedParquetDefinitionLevelReader(int bitWidth, int maxDefLevel, boolean setArrowValidityVector) {
        super(bitWidth, maxDefLevel, setArrowValidityVector);
    }

    public VectorizedParquetDefinitionLevelReader(int bitWidth, int maxDefLevel, boolean readLength, boolean setArrowValidityVector) {
        super(bitWidth, maxDefLevel, readLength, setArrowValidityVector);
    }

    private void setNull(NullabilityHolder nullabilityHolder, int bufferIdx, ArrowBuf validityBuffer) {
        nullabilityHolder.setNull(bufferIdx);
        if (this.setArrowValidityVector) {
            BitVectorHelper.setValidityBit((ArrowBuf)validityBuffer, (int)bufferIdx, (int)0);
        }
    }

    private void setNulls(NullabilityHolder nullabilityHolder, int idx, int numValues, ArrowBuf validityBuffer) {
        nullabilityHolder.setNulls(idx, numValues);
        if (this.setArrowValidityVector) {
            for (int i = 0; i < numValues; ++i) {
                BitVectorHelper.setValidityBit((ArrowBuf)validityBuffer, (int)(idx + i), (int)0);
            }
        }
    }

    private void setNextNValuesInVector(int typeWidth, NullabilityHolder nullabilityHolder, ValuesAsBytesReader valuesReader, int bufferIdx, FieldVector vector, int numValues) {
        ArrowBuf validityBuffer = vector.getValidityBuffer();
        if (this.currentValue == this.maxDefLevel) {
            ByteBuffer buffer = valuesReader.getBuffer(numValues * typeWidth);
            vector.getDataBuffer().setBytes((long)bufferIdx * (long)typeWidth, buffer);
            nullabilityHolder.setNotNulls(bufferIdx, numValues);
            if (this.setArrowValidityVector) {
                for (int i = 0; i < numValues; ++i) {
                    BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)(bufferIdx + i));
                }
            }
        } else {
            this.setNulls(nullabilityHolder, bufferIdx, numValues, validityBuffer);
        }
    }

    LongReader longReader() {
        return new LongReader();
    }

    DoubleReader doubleReader() {
        return new DoubleReader();
    }

    FloatReader floatReader() {
        return new FloatReader();
    }

    IntegerReader integerReader() {
        return new IntegerReader();
    }

    TimestampMillisReader timestampMillisReader() {
        return new TimestampMillisReader();
    }

    TimestampInt96Reader timestampInt96Reader() {
        return new TimestampInt96Reader();
    }

    @Deprecated
    FixedWidthBinaryReader fixedWidthBinaryReader() {
        return new FixedWidthBinaryReader();
    }

    FixedSizeBinaryReader fixedSizeBinaryReader() {
        return new FixedSizeBinaryReader();
    }

    VarWidthReader varWidthReader() {
        return new VarWidthReader();
    }

    BooleanReader booleanReader() {
        return new BooleanReader();
    }

    DictionaryIdReader dictionaryIdReader() {
        return new DictionaryIdReader();
    }

    class DictionaryIdReader
    extends BaseReader {
        DictionaryIdReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.dictionaryIdReader().nextBatch(vector, idx, numValuesToRead, dict, nullabilityHolder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setInt((long)idx * 4L, reader.readInteger());
            }
        }
    }

    class BooleanReader
    extends BaseReader {
        BooleanReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            ((BitVector)vector).setSafe(idx, valuesReader.readBooleanAsInt());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            throw new UnsupportedOperationException();
        }
    }

    class VarWidthReader
    extends BaseReader {
        VarWidthReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            int len = valuesReader.readInteger();
            ByteBuffer buffer = valuesReader.getBuffer(len);
            ((BaseVariableWidthVector)vector).setValueLengthSafe(idx, len);
            int startOffset = ((BaseVariableWidthVector)vector).getStartOffset(idx);
            vector.getDataBuffer().setBytes((long)startOffset, buffer);
            if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)idx);
            }
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.varWidthBinaryDictEncodedReader().nextBatch(vector, idx, numValuesToRead, dict, nullabilityHolder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                ((BaseVariableWidthVector)vector).setSafe(idx, dict.decodeToBinary(reader.readInteger()).getBytesUnsafe());
            }
        }
    }

    class FixedSizeBinaryReader
    extends BaseReader {
        FixedSizeBinaryReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            valuesReader.getBuffer(typeWidth).get(byteArray, 0, typeWidth);
            ((FixedSizeBinaryVector)vector).set(idx, byteArray);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.fixedSizeBinaryDictEncodedReader().nextBatch(vector, idx, numValuesToRead, dict, nullabilityHolder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                byte[] bytes = dict.decodeToBinary(reader.readInteger()).getBytes();
                byte[] vectorBytes = new byte[typeWidth];
                System.arraycopy(bytes, 0, vectorBytes, 0, typeWidth);
                ((FixedSizeBinaryVector)vector).set(idx, vectorBytes);
            }
        }
    }

    @Deprecated
    class FixedWidthBinaryReader
    extends BaseReader {
        FixedWidthBinaryReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            ByteBuffer buffer = valuesReader.getBuffer(typeWidth);
            ((VarBinaryVector)vector).setSafe(idx, buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.limit() - buffer.position());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.fixedWidthBinaryDictEncodedReader().nextBatch(vector, idx, numValuesToRead, dict, nullabilityHolder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                ByteBuffer buffer = dict.decodeToBinary(reader.readInteger()).toByteBuffer();
                vector.getDataBuffer().setBytes((long)idx * (long)typeWidth, buffer);
            }
        }
    }

    class TimestampInt96Reader
    extends BaseReader {
        TimestampInt96Reader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            ByteBuffer buffer = valuesReader.getBuffer(12).order(ByteOrder.LITTLE_ENDIAN);
            long timestampInt96 = ParquetUtil.extractTimestampInt96((ByteBuffer)buffer);
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, timestampInt96);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            switch (mode) {
                case RLE: {
                    reader.timestampInt96DictEncodedReader().nextBatch(vector, idx, numValuesToRead, dict, nullabilityHolder, typeWidth);
                    break;
                }
                case PACKED: {
                    ByteBuffer buffer = dict.decodeToBinary(reader.readInteger()).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                    long timestampInt96 = ParquetUtil.extractTimestampInt96((ByteBuffer)buffer);
                    vector.getDataBuffer().setLong((long)idx, timestampInt96);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported mode for timestamp int96 reader: " + mode);
                }
            }
        }
    }

    class TimestampMillisReader
    extends BaseReader {
        TimestampMillisReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, int typeWidth, byte[] byteArray) {
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, valuesReader.readLong() * 1000L);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, int numValuesToRead, Dictionary dict, NullabilityHolder nullabilityHolder, int typeWidth, BaseVectorizedParquetValuesReader.Mode mode) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.timestampMillisDictEncodedReader().nextBatch(vector, idx, numValuesToRead, dict, nullabilityHolder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setLong((long)idx * (long)typeWidth, dict.decodeToLong(reader.readInteger()) * 1000L);
            }
        }
    }

    abstract class BaseReader {
        BaseReader() {
        }

        public void nextBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, NullabilityHolder nullabilityHolder, ValuesAsBytesReader valuesReader) {
            int bufferIdx = startOffset;
            int left = numValsToRead;
            while (left > 0) {
                if (VectorizedParquetDefinitionLevelReader.this.currentCount == 0) {
                    VectorizedParquetDefinitionLevelReader.this.readNextGroup();
                }
                int numValues = Math.min(left, VectorizedParquetDefinitionLevelReader.this.currentCount);
                byte[] byteArray = null;
                if (typeWidth > -1) {
                    byteArray = new byte[typeWidth];
                }
                switch (VectorizedParquetDefinitionLevelReader.this.mode) {
                    case RLE: {
                        int i;
                        if (VectorizedParquetDefinitionLevelReader.this.currentValue == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                            for (i = 0; i < numValues; ++i) {
                                this.nextVal(vector, bufferIdx, valuesReader, typeWidth, byteArray);
                                nullabilityHolder.setNotNull(bufferIdx);
                                ++bufferIdx;
                            }
                            break;
                        }
                        VectorizedParquetDefinitionLevelReader.this.setNulls(nullabilityHolder, bufferIdx, numValues, vector.getValidityBuffer());
                        bufferIdx += numValues;
                        break;
                    }
                    case PACKED: {
                        int i;
                        for (i = 0; i < numValues; ++i) {
                            if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                                this.nextVal(vector, bufferIdx, valuesReader, typeWidth, byteArray);
                                nullabilityHolder.setNotNull(bufferIdx);
                            } else {
                                VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, bufferIdx, vector.getValidityBuffer());
                            }
                            ++bufferIdx;
                        }
                        break;
                    }
                }
                left -= numValues;
                VectorizedParquetDefinitionLevelReader.this.currentCount -= numValues;
            }
        }

        public void nextDictEncodedBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, NullabilityHolder nullabilityHolder, VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader, Dictionary dict) {
            int idx = startOffset;
            int left = numValsToRead;
            while (left > 0) {
                if (VectorizedParquetDefinitionLevelReader.this.currentCount == 0) {
                    VectorizedParquetDefinitionLevelReader.this.readNextGroup();
                }
                int numValues = Math.min(left, VectorizedParquetDefinitionLevelReader.this.currentCount);
                ArrowBuf validityBuffer = vector.getValidityBuffer();
                switch (VectorizedParquetDefinitionLevelReader.this.mode) {
                    case RLE: {
                        if (VectorizedParquetDefinitionLevelReader.this.currentValue == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                            this.nextDictEncodedVal(vector, idx, dictionaryEncodedValuesReader, numValues, dict, nullabilityHolder, typeWidth, VectorizedParquetDefinitionLevelReader.this.mode);
                        } else {
                            VectorizedParquetDefinitionLevelReader.this.setNulls(nullabilityHolder, idx, numValues, validityBuffer);
                        }
                        idx += numValues;
                        break;
                    }
                    case PACKED: {
                        for (int i = 0; i < numValues; ++i) {
                            if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                                this.nextDictEncodedVal(vector, idx, dictionaryEncodedValuesReader, numValues, dict, nullabilityHolder, typeWidth, VectorizedParquetDefinitionLevelReader.this.mode);
                                nullabilityHolder.setNotNull(idx);
                                if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                                    BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)idx);
                                }
                            } else {
                                VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, idx, validityBuffer);
                            }
                            ++idx;
                        }
                        break;
                    }
                }
                left -= numValues;
                VectorizedParquetDefinitionLevelReader.this.currentCount -= numValues;
            }
        }

        protected abstract void nextVal(FieldVector var1, int var2, ValuesAsBytesReader var3, int var4, byte[] var5);

        protected abstract void nextDictEncodedVal(FieldVector var1, int var2, VectorizedDictionaryEncodedParquetValuesReader var3, int var4, Dictionary var5, NullabilityHolder var6, int var7, BaseVectorizedParquetValuesReader.Mode var8);
    }

    class IntegerReader
    extends NumericBaseReader {
        IntegerReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setInt((long)idx, valuesReader.readInteger());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                dictionaryEncodedValuesReader.integerDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setInt((long)idx * (long)typeWidth, dict.decodeToInt(dictionaryEncodedValuesReader.readInteger()));
            }
        }
    }

    class FloatReader
    extends NumericBaseReader {
        FloatReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setFloat((long)idx, valuesReader.readFloat());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                dictionaryEncodedValuesReader.floatDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setFloat((long)idx * (long)typeWidth, dict.decodeToFloat(dictionaryEncodedValuesReader.readInteger()));
            }
        }
    }

    class DoubleReader
    extends NumericBaseReader {
        DoubleReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setDouble((long)idx, valuesReader.readDouble());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                dictionaryEncodedValuesReader.doubleDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setDouble((long)idx * (long)typeWidth, dict.decodeToDouble(dictionaryEncodedValuesReader.readInteger()));
            }
        }
    }

    class LongReader
    extends NumericBaseReader {
        LongReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, ValuesAsBytesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setLong((long)idx, valuesReader.readLong());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                dictionaryEncodedValuesReader.longDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setLong((long)idx * (long)typeWidth, dict.decodeToLong(dictionaryEncodedValuesReader.readInteger()));
            }
        }
    }

    abstract class NumericBaseReader {
        NumericBaseReader() {
        }

        public void nextBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, NullabilityHolder nullabilityHolder, ValuesAsBytesReader valuesReader) {
            int bufferIdx = startOffset;
            int left = numValsToRead;
            while (left > 0) {
                if (VectorizedParquetDefinitionLevelReader.this.currentCount == 0) {
                    VectorizedParquetDefinitionLevelReader.this.readNextGroup();
                }
                int numValues = Math.min(left, VectorizedParquetDefinitionLevelReader.this.currentCount);
                switch (VectorizedParquetDefinitionLevelReader.this.mode) {
                    case RLE: {
                        VectorizedParquetDefinitionLevelReader.this.setNextNValuesInVector(typeWidth, nullabilityHolder, valuesReader, bufferIdx, vector, numValues);
                        bufferIdx += numValues;
                        break;
                    }
                    case PACKED: {
                        for (int i = 0; i < numValues; ++i) {
                            if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                                this.nextVal(vector, bufferIdx * typeWidth, valuesReader, VectorizedParquetDefinitionLevelReader.this.mode);
                                nullabilityHolder.setNotNull(bufferIdx);
                                if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                                    BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)bufferIdx);
                                }
                            } else {
                                VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, bufferIdx, vector.getValidityBuffer());
                            }
                            ++bufferIdx;
                        }
                        break;
                    }
                }
                left -= numValues;
                VectorizedParquetDefinitionLevelReader.this.currentCount -= numValues;
            }
        }

        public void nextDictEncodedBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, NullabilityHolder nullabilityHolder, VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader, Dictionary dict) {
            int idx = startOffset;
            int left = numValsToRead;
            while (left > 0) {
                if (VectorizedParquetDefinitionLevelReader.this.currentCount == 0) {
                    VectorizedParquetDefinitionLevelReader.this.readNextGroup();
                }
                int numValues = Math.min(left, VectorizedParquetDefinitionLevelReader.this.currentCount);
                ArrowBuf validityBuffer = vector.getValidityBuffer();
                switch (VectorizedParquetDefinitionLevelReader.this.mode) {
                    case RLE: {
                        if (VectorizedParquetDefinitionLevelReader.this.currentValue == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                            this.nextDictEncodedVal(vector, idx, dictionaryEncodedValuesReader, dict, VectorizedParquetDefinitionLevelReader.this.mode, numValues, nullabilityHolder, typeWidth);
                        } else {
                            VectorizedParquetDefinitionLevelReader.this.setNulls(nullabilityHolder, idx, numValues, validityBuffer);
                        }
                        idx += numValues;
                        break;
                    }
                    case PACKED: {
                        for (int i = 0; i < numValues; ++i) {
                            if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                                this.nextDictEncodedVal(vector, idx, dictionaryEncodedValuesReader, dict, VectorizedParquetDefinitionLevelReader.this.mode, numValues, nullabilityHolder, typeWidth);
                                nullabilityHolder.setNotNull(idx);
                                if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                                    BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)idx);
                                }
                            } else {
                                VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, idx, validityBuffer);
                            }
                            ++idx;
                        }
                        break;
                    }
                }
                left -= numValues;
                VectorizedParquetDefinitionLevelReader.this.currentCount -= numValues;
            }
        }

        protected abstract void nextVal(FieldVector var1, int var2, ValuesAsBytesReader var3, BaseVectorizedParquetValuesReader.Mode var4);

        protected abstract void nextDictEncodedVal(FieldVector var1, int var2, VectorizedDictionaryEncodedParquetValuesReader var3, Dictionary var4, BaseVectorizedParquetValuesReader.Mode var5, int var6, NullabilityHolder var7, int var8);
    }
}

