/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.arrow.ArrowAllocation;
import org.apache.iceberg.arrow.vectorized.VectorizedArrowReader;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class VectorizedReaderBuilder
extends TypeWithSchemaVisitor<VectorizedReader<?>> {
    private final MessageType parquetSchema;
    private final Schema icebergSchema;
    private final BufferAllocator rootAllocator;
    private final Map<Integer, ?> idToConstant;
    private final boolean setArrowValidityVector;
    private final Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory;
    private final BiFunction<Type, Object, Object> convert;

    public VectorizedReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory) {
        this(expectedSchema, parquetSchema, setArrowValidityVector, idToConstant, readerFactory, (type, value) -> value);
    }

    protected VectorizedReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory, BiFunction<Type, Object, Object> convert) {
        this.parquetSchema = parquetSchema;
        this.icebergSchema = expectedSchema;
        this.rootAllocator = ArrowAllocation.rootAllocator().newChildAllocator("VectorizedReadBuilder", 0L, Long.MAX_VALUE);
        this.setArrowValidityVector = setArrowValidityVector;
        this.idToConstant = idToConstant;
        this.readerFactory = readerFactory;
        this.convert = convert;
    }

    public VectorizedReader<?> message(Types.StructType expected, MessageType message, List<VectorizedReader<?>> fieldReaders) {
        GroupType groupType = message.asGroupType();
        HashMap readersById = Maps.newHashMap();
        List fields = groupType.getFields();
        IntStream.range(0, fields.size()).filter(pos -> ((org.apache.parquet.schema.Type)fields.get(pos)).getId() != null).forEach(pos -> readersById.put(((org.apache.parquet.schema.Type)fields.get(pos)).getId().intValue(), (VectorizedReader)fieldReaders.get(pos)));
        List icebergFields = expected != null ? expected.fields() : ImmutableList.of();
        ArrayList reorderedFields = Lists.newArrayListWithExpectedSize((int)icebergFields.size());
        Iterator iterator = icebergFields.iterator();
        while (iterator.hasNext()) {
            Types.NestedField field = (Types.NestedField)iterator.next();
            int id = field.fieldId();
            VectorizedReader reader = (VectorizedReader)readersById.get(id);
            if (this.idToConstant.containsKey(id)) {
                reorderedFields.add(this.constantReader(field, this.idToConstant.get(id)));
                continue;
            }
            if (id == MetadataColumns.ROW_POSITION.fieldId()) {
                if (this.setArrowValidityVector) {
                    reorderedFields.add(VectorizedArrowReader.positionsWithSetArrowValidityVector());
                    continue;
                }
                reorderedFields.add(VectorizedArrowReader.positions());
                continue;
            }
            if (id == MetadataColumns.IS_DELETED.fieldId()) {
                reorderedFields.add(new VectorizedArrowReader.DeletedVectorReader());
                continue;
            }
            if (reader != null) {
                reorderedFields.add(reader);
                continue;
            }
            if (field.initialDefault() != null) {
                reorderedFields.add(this.constantReader(field, this.convert.apply(field.type(), field.initialDefault())));
                continue;
            }
            if (field.isOptional()) {
                reorderedFields.add(VectorizedArrowReader.nulls());
                continue;
            }
            throw new IllegalArgumentException(String.format("Missing required field: %s", field.name()));
        }
        return this.vectorizedReader(reorderedFields);
    }

    private <T> VectorizedArrowReader.ConstantVectorReader<T> constantReader(Types.NestedField field, T constant) {
        return new VectorizedArrowReader.ConstantVectorReader<T>(field, constant);
    }

    protected VectorizedReader<?> vectorizedReader(List<VectorizedReader<?>> reorderedFields) {
        return this.readerFactory.apply(reorderedFields);
    }

    public VectorizedReader<?> struct(Types.StructType expected, GroupType groupType, List<VectorizedReader<?>> fieldReaders) {
        if (expected != null) {
            throw new UnsupportedOperationException("Vectorized reads are not supported yet for struct fields");
        }
        return null;
    }

    public VectorizedReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
        if (primitive.getId() == null) {
            return null;
        }
        int parquetFieldId = primitive.getId().intValue();
        ColumnDescriptor desc = this.parquetSchema.getColumnDescription(this.currentPath());
        if (desc.getMaxRepetitionLevel() > 0) {
            return null;
        }
        Types.NestedField icebergField = this.icebergSchema.findField(parquetFieldId);
        if (icebergField == null) {
            return null;
        }
        return new VectorizedArrowReader(desc, icebergField, this.rootAllocator, this.setArrowValidityVector);
    }
}

