/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.io.IOException;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedDictionaryEncodedParquetValuesReader;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedParquetDefinitionLevelReader;
import org.apache.iceberg.parquet.BasePageIterator;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.ValuesAsBytesReader;
import org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.PrimitiveType;

public class VectorizedPageIterator
extends BasePageIterator {
    private final boolean setArrowValidityVector;
    private ValuesAsBytesReader plainValuesReader = null;
    private VectorizedDictionaryEncodedParquetValuesReader dictionaryEncodedValuesReader = null;
    private boolean allPagesDictEncoded;
    private VectorizedParquetDefinitionLevelReader vectorizedDefinitionLevelReader;
    private DictionaryDecodeMode dictionaryDecodeMode;

    public VectorizedPageIterator(ColumnDescriptor desc, String writerVersion, boolean setValidityVector) {
        super(desc, writerVersion);
        this.setArrowValidityVector = setValidityVector;
    }

    public void setAllPagesDictEncoded(boolean allDictEncoded) {
        this.allPagesDictEncoded = allDictEncoded;
    }

    protected void reset() {
        super.reset();
        this.plainValuesReader = null;
        this.vectorizedDefinitionLevelReader = null;
    }

    protected void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) {
        ValuesAsBytesReader previousReader = this.plainValuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("could not read page in col " + this.desc + " as the dictionary was missing for encoding " + dataEncoding);
            }
            try {
                this.dictionaryEncodedValuesReader = new VectorizedDictionaryEncodedParquetValuesReader(this.desc.getMaxDefinitionLevel(), this.setArrowValidityVector);
                this.dictionaryEncodedValuesReader.initFromPage(valueCount, in);
                if (ParquetUtil.isIntType((PrimitiveType)this.desc.getPrimitiveType()) || !this.allPagesDictEncoded) {
                    this.dictionaryDecodeMode = DictionaryDecodeMode.EAGER;
                }
                this.dictionaryDecodeMode = DictionaryDecodeMode.LAZY;
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read page in col " + this.desc, (Throwable)e);
            }
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Cannot support vectorized reads for column " + this.desc + " with encoding " + dataEncoding + ". Disable vectorized reads to read this table/file");
            }
            this.plainValuesReader = new ValuesAsBytesReader();
            this.plainValuesReader.initFromPage(valueCount, in);
            this.dictionaryDecodeMode = DictionaryDecodeMode.NONE;
        }
        if (CorruptDeltaByteArrays.requiresSequentialReads((String)this.writerVersion, (Encoding)dataEncoding) && previousReader instanceof RequiresPreviousReader) {
            ((RequiresPreviousReader)this.plainValuesReader).setPreviousReader((ValuesReader)previousReader);
        }
    }

    public boolean producesDictionaryEncodedVector() {
        return this.dictionaryDecodeMode == DictionaryDecodeMode.LAZY;
    }

    protected void initDefinitionLevelsReader(DataPageV1 dataPageV1, ColumnDescriptor desc, ByteBufferInputStream in, int triplesCount) throws IOException {
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)desc.getMaxDefinitionLevel());
        this.vectorizedDefinitionLevelReader = new VectorizedParquetDefinitionLevelReader(bitWidth, desc.getMaxDefinitionLevel(), this.setArrowValidityVector);
        this.vectorizedDefinitionLevelReader.initFromPage(triplesCount, in);
    }

    protected void initDefinitionLevelsReader(DataPageV2 dataPageV2, ColumnDescriptor desc) throws IOException {
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)desc.getMaxDefinitionLevel());
        this.vectorizedDefinitionLevelReader = new VectorizedParquetDefinitionLevelReader(bitWidth, desc.getMaxDefinitionLevel(), false, this.setArrowValidityVector);
        this.vectorizedDefinitionLevelReader.initFromPage(dataPageV2.getValueCount(), dataPageV2.getDefinitionLevels().toInputStream());
    }

    public int nextBatchDictionaryIds(IntVector vector, int expectedBatchSize, int numValsInVector, NullabilityHolder holder) {
        int actualBatchSize = this.getActualBatchSize(expectedBatchSize);
        if (actualBatchSize <= 0) {
            return 0;
        }
        this.vectorizedDefinitionLevelReader.dictionaryIdReader().nextDictEncodedBatch((FieldVector)vector, numValsInVector, -1, actualBatchSize, holder, this.dictionaryEncodedValuesReader, null);
        this.triplesRead += actualBatchSize;
        this.hasNext = this.triplesRead < this.triplesCount;
        return actualBatchSize;
    }

    private int getActualBatchSize(int expectedBatchSize) {
        return Math.min(expectedBatchSize, this.triplesCount - this.triplesRead);
    }

    IntPageReader intPageReader() {
        return new IntPageReader();
    }

    LongPageReader longPageReader() {
        return new LongPageReader();
    }

    TimestampMillisPageReader timestampMillisPageReader() {
        return new TimestampMillisPageReader();
    }

    TimestampInt96PageReader timestampInt96PageReader() {
        return new TimestampInt96PageReader();
    }

    FloatPageReader floatPageReader() {
        return new FloatPageReader();
    }

    DoublePageReader doublePageReader() {
        return new DoublePageReader();
    }

    FixedSizeBinaryPageReader fixedSizeBinaryPageReader() {
        return new FixedSizeBinaryPageReader();
    }

    VarWidthTypePageReader varWidthTypePageReader() {
        return new VarWidthTypePageReader();
    }

    BooleanPageReader booleanPageReader() {
        return new BooleanPageReader();
    }

    class BooleanPageReader
    extends BasePageReader {
        BooleanPageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.booleanReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            throw new UnsupportedOperationException();
        }
    }

    class VarWidthTypePageReader
    extends BasePageReader {
        VarWidthTypePageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.varWidthReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.varWidthReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class FixedSizeBinaryPageReader
    extends BasePageReader {
        FixedSizeBinaryPageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.fixedSizeBinaryReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.fixedSizeBinaryReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class DoublePageReader
    extends BasePageReader {
        DoublePageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.doubleReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.doubleReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class FloatPageReader
    extends BasePageReader {
        FloatPageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.floatReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.floatReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class TimestampInt96PageReader
    extends BasePageReader {
        TimestampInt96PageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.timestampInt96Reader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.timestampInt96Reader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class TimestampMillisPageReader
    extends BasePageReader {
        TimestampMillisPageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.timestampMillisReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.timestampMillisReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class LongPageReader
    extends BasePageReader {
        LongPageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.longReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.longReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    class IntPageReader
    extends BasePageReader {
        IntPageReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.integerReader().nextBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.plainValuesReader);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int batchSize, int numVals, int typeWidth, NullabilityHolder holder) {
            VectorizedPageIterator.this.vectorizedDefinitionLevelReader.integerReader().nextDictEncodedBatch(vector, numVals, typeWidth, batchSize, holder, VectorizedPageIterator.this.dictionaryEncodedValuesReader, VectorizedPageIterator.this.dictionary);
        }
    }

    abstract class BasePageReader {
        BasePageReader() {
        }

        public int nextBatch(FieldVector vector, int expectedBatchSize, int numValsInVector, int typeWidth, NullabilityHolder holder) {
            int actualBatchSize = VectorizedPageIterator.this.getActualBatchSize(expectedBatchSize);
            if (actualBatchSize <= 0) {
                return 0;
            }
            if (VectorizedPageIterator.this.dictionaryDecodeMode == DictionaryDecodeMode.EAGER) {
                this.nextDictEncodedVal(vector, actualBatchSize, numValsInVector, typeWidth, holder);
            } else {
                this.nextVal(vector, actualBatchSize, numValsInVector, typeWidth, holder);
            }
            VectorizedPageIterator.this.triplesRead += actualBatchSize;
            VectorizedPageIterator.this.hasNext = VectorizedPageIterator.this.triplesRead < VectorizedPageIterator.this.triplesCount;
            return actualBatchSize;
        }

        protected abstract void nextVal(FieldVector var1, int var2, int var3, int var4, NullabilityHolder var5);

        protected abstract void nextDictEncodedVal(FieldVector var1, int var2, int var3, int var4, NullabilityHolder var5);
    }

    private static enum DictionaryDecodeMode {
        NONE,
        LAZY,
        EAGER;

    }
}

