/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputFile;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.SerializableSupplier;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public class S3FileIO
implements FileIO {
    private SerializableSupplier<S3Client> s3;
    private AwsProperties awsProperties;
    private AwsClientFactory awsClientFactory;
    private transient S3Client client;

    public S3FileIO() {
    }

    public S3FileIO(SerializableSupplier<S3Client> s3) {
        this(s3, new AwsProperties());
    }

    public S3FileIO(SerializableSupplier<S3Client> s3, AwsProperties awsProperties) {
        this.s3 = s3;
        this.awsProperties = awsProperties;
    }

    public InputFile newInputFile(String path) {
        return new S3InputFile(this.client(), new S3URI(path), this.awsProperties);
    }

    public OutputFile newOutputFile(String path) {
        return new S3OutputFile(this.client(), new S3URI(path), this.awsProperties);
    }

    public void deleteFile(String path) {
        S3URI location = new S3URI(path);
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)ObjectIdentifier.builder().key(location.key()).build();
        Delete delete = (Delete)Delete.builder().objects(new ObjectIdentifier[]{objectIdentifier}).build();
        DeleteObjectsRequest deleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(location.bucket()).delete(delete).build();
        this.client().deleteObjects(deleteRequest);
    }

    private S3Client client() {
        if (this.client == null) {
            this.client = (S3Client)this.s3.get();
        }
        return this.client;
    }

    public void initialize(Map<String, String> properties) {
        this.awsProperties = new AwsProperties(properties);
        this.awsClientFactory = AwsClientFactories.from(properties);
        this.s3 = this.awsClientFactory::s3;
    }
}

