/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.S3RequestUtil;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Predicates;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.io.CountingOutputStream;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

class S3OutputStream
extends PositionOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3OutputStream.class);
    private static volatile ExecutorService executorService;
    private final StackTraceElement[] createStack;
    private final S3Client s3;
    private final S3URI location;
    private final AwsProperties awsProperties;
    private CountingOutputStream stream;
    private final List<File> stagingFiles = Lists.newArrayList();
    private final File stagingDirectory;
    private File currentStagingFile;
    private String multipartUploadId;
    private final Map<File, CompletableFuture<CompletedPart>> multiPartMap = Maps.newHashMap();
    private final int multiPartSize;
    private final int multiPartThresholdSize;
    private long pos = 0L;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    S3OutputStream(S3Client s3, S3URI location, AwsProperties awsProperties) throws IOException {
        if (executorService == null) {
            Class<S3OutputStream> clazz = S3OutputStream.class;
            // MONITORENTER : org.apache.iceberg.aws.s3.S3OutputStream.class
            if (executorService == null) {
                executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(awsProperties.s3FileIoMultipartUploadThreads(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("iceberg-s3fileio-upload-%d").build())));
            }
            // MONITOREXIT : clazz
        }
        this.s3 = s3;
        this.location = location;
        this.awsProperties = awsProperties;
        this.createStack = Thread.currentThread().getStackTrace();
        this.multiPartSize = awsProperties.s3FileIoMultiPartSize();
        this.multiPartThresholdSize = (int)((double)this.multiPartSize * awsProperties.s3FileIOMultipartThresholdFactor());
        this.stagingDirectory = new File(awsProperties.s3fileIoStagingDirectory());
        this.newStream();
    }

    public long getPos() {
        return this.pos;
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void write(int b) throws IOException {
        if (this.stream.getCount() >= (long)this.multiPartSize) {
            this.newStream();
            this.uploadParts();
        }
        this.stream.write(b);
        ++this.pos;
        if (this.multipartUploadId == null && this.pos >= (long)this.multiPartThresholdSize) {
            this.initializeMultiPartUpload();
            this.uploadParts();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = len;
        int relativeOffset = off;
        while (this.stream.getCount() + (long)remaining > (long)this.multiPartSize) {
            int writeSize = this.multiPartSize - (int)this.stream.getCount();
            this.stream.write(b, relativeOffset, writeSize);
            remaining -= writeSize;
            relativeOffset += writeSize;
            this.newStream();
            this.uploadParts();
        }
        this.stream.write(b, relativeOffset, remaining);
        this.pos += (long)len;
        if (this.multipartUploadId == null && this.pos >= (long)this.multiPartThresholdSize) {
            this.initializeMultiPartUpload();
            this.uploadParts();
        }
    }

    private void newStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.currentStagingFile = File.createTempFile("s3fileio-", ".tmp", this.stagingDirectory);
        this.currentStagingFile.deleteOnExit();
        this.stagingFiles.add(this.currentStagingFile);
        this.stream = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.currentStagingFile)));
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        try {
            this.stream.close();
            this.completeUploads();
        }
        finally {
            this.cleanUpStagingFiles();
        }
    }

    private void initializeMultiPartUpload() {
        CreateMultipartUploadRequest.Builder requestBuilder = CreateMultipartUploadRequest.builder().bucket(this.location.bucket()).key(this.location.key());
        S3RequestUtil.configureEncryption(this.awsProperties, requestBuilder);
        S3RequestUtil.configurePermission(this.awsProperties, requestBuilder);
        this.multipartUploadId = this.s3.createMultipartUpload((CreateMultipartUploadRequest)requestBuilder.build()).uploadId();
    }

    private void uploadParts() {
        if (this.multipartUploadId == null) {
            return;
        }
        this.stagingFiles.stream().filter(f -> this.closed || !f.equals(this.currentStagingFile)).filter((Predicate<File>)Predicates.not(this.multiPartMap::containsKey)).forEach(f -> {
            UploadPartRequest.Builder requestBuilder = UploadPartRequest.builder().bucket(this.location.bucket()).key(this.location.key()).uploadId(this.multipartUploadId).partNumber(Integer.valueOf(this.stagingFiles.indexOf(f) + 1)).contentLength(Long.valueOf(f.length()));
            S3RequestUtil.configureEncryption(this.awsProperties, requestBuilder);
            UploadPartRequest uploadRequest = (UploadPartRequest)requestBuilder.build();
            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                UploadPartResponse response = this.s3.uploadPart(uploadRequest, RequestBody.fromFile((File)f));
                return (CompletedPart)CompletedPart.builder().eTag(response.eTag()).partNumber(uploadRequest.partNumber()).build();
            }, executorService).whenComplete((result, thrown) -> {
                try {
                    Files.deleteIfExists(f.toPath());
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete staging file: {}", f, (Object)e);
                }
                if (thrown != null) {
                    LOG.error("Failed to upload part: {}", (Object)uploadRequest, thrown);
                    this.abortUpload();
                }
            });
            this.multiPartMap.put((File)f, (CompletableFuture<CompletedPart>)future);
        });
    }

    private void completeMultiPartUpload() {
        Preconditions.checkState((boolean)this.closed, (Object)("Complete upload called on open stream: " + this.location));
        List completedParts = this.multiPartMap.values().stream().map(CompletableFuture::join).sorted(Comparator.comparing(CompletedPart::partNumber)).collect(Collectors.toList());
        CompleteMultipartUploadRequest request = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.location.bucket()).key(this.location.key()).uploadId(this.multipartUploadId).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build()).build();
        Tasks.foreach((Object[])new CompleteMultipartUploadRequest[]{request}).noRetry().onFailure((r, thrown) -> {
            LOG.error("Failed to complete multipart upload request: {}", r, (Object)thrown);
            this.abortUpload();
        }).throwFailureWhenFinished().run(arg_0 -> ((S3Client)this.s3).completeMultipartUpload(arg_0));
    }

    private void abortUpload() {
        if (this.multipartUploadId != null) {
            try {
                this.s3.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.location.bucket()).key(this.location.key()).uploadId(this.multipartUploadId).build());
            }
            finally {
                this.cleanUpStagingFiles();
            }
        }
    }

    private void cleanUpStagingFiles() {
        Tasks.foreach(this.stagingFiles).suppressFailureWhenFinished().onFailure((file, thrown) -> LOG.warn("Failed to delete staging file: {}", file, (Object)thrown)).run(File::delete);
    }

    private void completeUploads() {
        if (this.multipartUploadId == null) {
            long contentLength = this.stagingFiles.stream().mapToLong(File::length).sum();
            BufferedInputStream contentStream = new BufferedInputStream(this.stagingFiles.stream().map(S3OutputStream::uncheckedInputStream).reduce(SequenceInputStream::new).orElseGet(() -> new ByteArrayInputStream(new byte[0])));
            PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(this.location.bucket()).key(this.location.key());
            S3RequestUtil.configureEncryption(this.awsProperties, requestBuilder);
            S3RequestUtil.configurePermission(this.awsProperties, requestBuilder);
            this.s3.putObject((PutObjectRequest)requestBuilder.build(), RequestBody.fromInputStream((InputStream)contentStream, (long)contentLength));
        } else {
            this.uploadParts();
            this.completeMultiPartUpload();
        }
    }

    private static InputStream uncheckedInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
        }
    }
}

