/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputFile;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.SerializableSupplier;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;

public class S3FileIO
implements FileIO {
    private SerializableSupplier<S3Client> s3;
    private AwsProperties awsProperties;
    private AwsClientFactory awsClientFactory;
    private transient S3Client client;
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);

    public S3FileIO() {
    }

    public S3FileIO(SerializableSupplier<S3Client> s3) {
        this(s3, new AwsProperties());
    }

    public S3FileIO(SerializableSupplier<S3Client> s3, AwsProperties awsProperties) {
        this.s3 = s3;
        this.awsProperties = awsProperties;
    }

    public InputFile newInputFile(String path) {
        return S3InputFile.fromLocation(path, this.client(), this.awsProperties);
    }

    public OutputFile newOutputFile(String path) {
        return S3OutputFile.fromLocation(path, this.client(), this.awsProperties);
    }

    public void deleteFile(String path) {
        S3URI location = new S3URI(path);
        DeleteObjectRequest deleteRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(location.bucket()).key(location.key()).build();
        this.client().deleteObject(deleteRequest);
    }

    private S3Client client() {
        if (this.client == null) {
            this.client = (S3Client)this.s3.get();
        }
        return this.client;
    }

    public void initialize(Map<String, String> properties) {
        this.awsProperties = new AwsProperties(properties);
        this.awsClientFactory = AwsClientFactories.from(properties);
        this.s3 = this.awsClientFactory::s3;
    }

    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.client != null) {
            this.client.close();
        }
    }
}

