/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import software.amazon.awssdk.services.s3.S3Client;

public class S3OutputFile
extends BaseS3File
implements OutputFile {
    public static S3OutputFile fromLocation(String location, S3Client client) {
        return new S3OutputFile(client, new S3URI(location), new AwsProperties());
    }

    public static S3OutputFile fromLocation(String location, S3Client client, AwsProperties awsProperties) {
        return new S3OutputFile(client, new S3URI(location), awsProperties);
    }

    S3OutputFile(S3Client client, S3URI uri, AwsProperties awsProperties) {
        super(client, uri, awsProperties);
    }

    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", new Object[]{this.uri()});
    }

    public PositionOutputStream createOrOverwrite() {
        try {
            return new S3OutputStream(this.client(), this.uri(), this.awsProperties());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output stream for location: " + this.uri(), e);
        }
    }

    public InputFile toInputFile() {
        return new S3InputFile(this.client(), this.uri(), this.awsProperties());
    }
}

