/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.glue;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.glue.GlueToIcebergConverter;
import org.apache.iceberg.aws.glue.IcebergToGlueConverter;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.ValidationException;

class GlueTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(GlueTableOperations.class);
    private static final String GLUE_EXTERNAL_TABLE_TYPE = "EXTERNAL_TABLE";
    private final GlueClient glue;
    private final AwsProperties awsProperties;
    private final String databaseName;
    private final String tableName;
    private final String fullTableName;
    private final String commitLockEntityId;
    private final FileIO fileIO;
    private final LockManager lockManager;
    private static final DynMethods.UnboundMethod SET_VERSION_ID = DynMethods.builder((String)"versionId").hiddenImpl("software.amazon.awssdk.services.glue.model.UpdateTableRequest$Builder", new Class[]{String.class}).orNoop().build();

    GlueTableOperations(GlueClient glue, LockManager lockManager, String catalogName, AwsProperties awsProperties, FileIO fileIO, TableIdentifier tableIdentifier) {
        this.glue = glue;
        this.awsProperties = awsProperties;
        this.databaseName = IcebergToGlueConverter.getDatabaseName(tableIdentifier, awsProperties.glueCatalogSkipNameValidation());
        this.tableName = IcebergToGlueConverter.getTableName(tableIdentifier, awsProperties.glueCatalogSkipNameValidation());
        this.fullTableName = String.format("%s.%s.%s", catalogName, this.databaseName, this.tableName);
        this.commitLockEntityId = String.format("%s.%s", this.databaseName, this.tableName);
        this.fileIO = fileIO;
        this.lockManager = lockManager;
    }

    public FileIO io() {
        return this.fileIO;
    }

    protected String tableName() {
        return this.fullTableName;
    }

    protected void doRefresh() {
        String metadataLocation = null;
        Table table = this.getGlueTable();
        if (table != null) {
            GlueToIcebergConverter.validateTable(table, this.tableName());
            metadataLocation = (String)table.parameters().get("metadata_location");
        } else if (this.currentMetadataLocation() != null) {
            throw new NoSuchTableException("Cannot find Glue table %s after refresh, maybe another process deleted it or revoked your access permission", new Object[]{this.tableName()});
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        BaseMetastoreTableOperations.CommitStatus commitStatus = BaseMetastoreTableOperations.CommitStatus.FAILURE;
        try {
            this.lock(newMetadataLocation);
            Table glueTable = this.getGlueTable();
            this.checkMetadataLocation(glueTable, base);
            Map<String, String> properties = this.prepareProperties(glueTable, newMetadataLocation);
            this.persistGlueTable(glueTable, properties, metadata);
            commitStatus = BaseMetastoreTableOperations.CommitStatus.SUCCESS;
            return;
        }
        catch (CommitFailedException e) {
            throw e;
        }
        catch (ConcurrentModificationException e) {
            throw new CommitFailedException((Throwable)e, "Cannot commit %s because Glue detected concurrent update", new Object[]{this.tableName()});
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException((Throwable)e, "Cannot commit %s because its Glue table already exists when trying to create one", new Object[]{this.tableName()});
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e, "Cannot commit %s because Glue cannot find the requested entity", new Object[]{this.tableName()});
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException((Throwable)e, "Cannot commit %s because Glue cannot access the requested resources", new Object[]{this.tableName()});
        }
        catch (ValidationException e) {
            throw new org.apache.iceberg.exceptions.ValidationException((Throwable)e, "Cannot commit %s because Glue encountered a validation exception while accessing requested resources", new Object[]{this.tableName()});
        }
        catch (RuntimeException persistFailure) {
            LOG.error("Confirming if commit to {} indeed failed to persist, attempting to reconnect and check.", (Object)this.fullTableName, (Object)persistFailure);
            commitStatus = this.checkCommitStatus(newMetadataLocation, metadata);
            switch (commitStatus) {
                case SUCCESS: {
                    return;
                }
                case FAILURE: {
                    throw new CommitFailedException((Throwable)persistFailure, "Cannot commit %s due to unexpected exception", new Object[]{this.tableName()});
                }
                case UNKNOWN: {
                    throw new CommitStateUnknownException((Throwable)persistFailure);
                }
            }
            return;
        }
        finally {
            this.cleanupMetadataAndUnlock(commitStatus, newMetadataLocation);
        }
    }

    private void lock(String newMetadataLocation) {
        if (this.lockManager != null && !this.lockManager.acquire(this.commitLockEntityId, newMetadataLocation)) {
            throw new IllegalStateException(String.format("Fail to acquire lock %s to commit new metadata at %s", this.commitLockEntityId, newMetadataLocation));
        }
    }

    private void checkMetadataLocation(Table glueTable, TableMetadata base) {
        String baseMetadataLocation;
        String glueMetadataLocation = glueTable != null ? (String)glueTable.parameters().get("metadata_location") : null;
        String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
        if (!Objects.equals(baseMetadataLocation, glueMetadataLocation)) {
            throw new CommitFailedException("Cannot commit %s because base metadata location '%s' is not same as the current Glue location '%s'", new Object[]{this.tableName(), baseMetadataLocation, glueMetadataLocation});
        }
    }

    private Table getGlueTable() {
        try {
            GetTableResponse response = this.glue.getTable((GetTableRequest)GetTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(this.databaseName).name(this.tableName).build());
            return response.table();
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    private Map<String, String> prepareProperties(Table glueTable, String newMetadataLocation) {
        HashMap properties = glueTable != null ? Maps.newHashMap((Map)glueTable.parameters()) : Maps.newHashMap();
        properties.put("table_type", "iceberg".toUpperCase(Locale.ENGLISH));
        properties.put("metadata_location", newMetadataLocation);
        if (this.currentMetadataLocation() != null && !this.currentMetadataLocation().isEmpty()) {
            properties.put("previous_metadata_location", this.currentMetadataLocation());
        }
        return properties;
    }

    @VisibleForTesting
    void persistGlueTable(Table glueTable, Map<String, String> parameters, TableMetadata metadata) {
        if (glueTable != null) {
            LOG.debug("Committing existing Glue table: {}", (Object)this.tableName());
            UpdateTableRequest.Builder updateTableRequest = UpdateTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(this.databaseName).skipArchive(Boolean.valueOf(this.awsProperties.glueCatalogSkipArchive())).tableInput((TableInput)((TableInput.Builder)TableInput.builder().applyMutation(builder -> IcebergToGlueConverter.setTableInputInformation(builder, metadata))).name(this.tableName).tableType(GLUE_EXTERNAL_TABLE_TYPE).parameters(parameters).build());
            if (!SET_VERSION_ID.isNoop() && this.lockManager == null) {
                SET_VERSION_ID.invoke((Object)updateTableRequest, new Object[]{glueTable.versionId()});
            }
            this.glue.updateTable((UpdateTableRequest)updateTableRequest.build());
        } else {
            LOG.debug("Committing new Glue table: {}", (Object)this.tableName());
            this.glue.createTable((CreateTableRequest)CreateTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(this.databaseName).tableInput((TableInput)((TableInput.Builder)TableInput.builder().applyMutation(builder -> IcebergToGlueConverter.setTableInputInformation(builder, metadata))).name(this.tableName).tableType(GLUE_EXTERNAL_TABLE_TYPE).parameters(parameters).build()).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cleanupMetadataAndUnlock(BaseMetastoreTableOperations.CommitStatus commitStatus, String metadataLocation) {
        try {
            if (commitStatus == BaseMetastoreTableOperations.CommitStatus.FAILURE) {
                this.io().deleteFile(metadataLocation);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Failed to cleanup metadata file at {}", (Object)metadataLocation, (Object)e);
        }
        finally {
            if (this.lockManager != null) {
                this.lockManager.release(this.commitLockEntityId, metadataLocation);
            }
        }
    }
}

