/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.S3RequestUtil;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.metrics.MetricsContext;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

abstract class BaseS3File {
    private final S3Client client;
    private final S3URI uri;
    private final AwsProperties awsProperties;
    private HeadObjectResponse metadata;
    private final MetricsContext metrics;

    BaseS3File(S3Client client, S3URI uri, AwsProperties awsProperties, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.awsProperties = awsProperties;
        this.metrics = metrics;
    }

    public String location() {
        return this.uri.location();
    }

    S3Client client() {
        return this.client;
    }

    S3URI uri() {
        return this.uri;
    }

    public AwsProperties awsProperties() {
        return this.awsProperties;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    public boolean exists() {
        try {
            return this.getObjectMetadata() != null;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    protected HeadObjectResponse getObjectMetadata() throws S3Exception {
        if (this.metadata == null) {
            HeadObjectRequest.Builder requestBuilder = HeadObjectRequest.builder().bucket(this.uri().bucket()).key(this.uri().key());
            S3RequestUtil.configureEncryption(this.awsProperties, requestBuilder);
            this.metadata = this.client().headObject((HeadObjectRequest)requestBuilder.build());
        }
        return this.metadata;
    }

    public String toString() {
        return this.uri.toString();
    }
}

