/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3InputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.encryption.NativeFileCryptoParameters;
import org.apache.iceberg.encryption.NativelyEncryptedFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.MetricsContext;
import software.amazon.awssdk.services.s3.S3Client;

public class S3InputFile
extends BaseS3File
implements InputFile,
NativelyEncryptedFile {
    private NativeFileCryptoParameters nativeDecryptionParameters;
    private Long length;

    public static S3InputFile fromLocation(String location, S3Client client, AwsProperties awsProperties, MetricsContext metrics) {
        return new S3InputFile(client, new S3URI(location, awsProperties.s3BucketToAccessPointMapping()), null, awsProperties, metrics);
    }

    public static S3InputFile fromLocation(String location, long length, S3Client client, AwsProperties awsProperties, MetricsContext metrics) {
        return new S3InputFile(client, new S3URI(location, awsProperties.s3BucketToAccessPointMapping()), length > 0L ? Long.valueOf(length) : null, awsProperties, metrics);
    }

    S3InputFile(S3Client client, S3URI uri, Long length, AwsProperties awsProperties, MetricsContext metrics) {
        super(client, uri, awsProperties, metrics);
        this.length = length;
    }

    public long getLength() {
        if (this.length == null) {
            this.length = this.getObjectMetadata().contentLength();
        }
        return this.length;
    }

    public SeekableInputStream newStream() {
        return new S3InputStream(this.client(), this.uri(), this.awsProperties(), this.metrics());
    }

    public NativeFileCryptoParameters nativeCryptoParameters() {
        return this.nativeDecryptionParameters;
    }

    public void setNativeCryptoParameters(NativeFileCryptoParameters nativeCryptoParameters) {
        this.nativeDecryptionParameters = nativeCryptoParameters;
    }
}

