/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.S3RequestUtil;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.IOUtil;
import org.apache.iceberg.io.RangeReadable;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

class S3InputStream
extends SeekableInputStream
implements RangeReadable {
    private static final Logger LOG = LoggerFactory.getLogger(S3InputStream.class);
    private final StackTraceElement[] createStack;
    private final S3Client s3;
    private final S3URI location;
    private final AwsProperties awsProperties;
    private InputStream stream;
    private long pos = 0L;
    private long next = 0L;
    private boolean closed = false;
    private final Counter readBytes;
    private final Counter readOperations;
    private int skipSize = 0x100000;

    S3InputStream(S3Client s3, S3URI location) {
        this(s3, location, new AwsProperties(), MetricsContext.nullMetrics());
    }

    S3InputStream(S3Client s3, S3URI location, AwsProperties awsProperties, MetricsContext metrics) {
        this.s3 = s3;
        this.location = location;
        this.awsProperties = awsProperties;
        this.readBytes = metrics.counter("read.bytes", MetricsContext.Unit.BYTES);
        this.readOperations = metrics.counter("read.operations");
        this.createStack = Thread.currentThread().getStackTrace();
    }

    public long getPos() {
        return this.next;
    }

    public void seek(long newPos) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        Preconditions.checkArgument((newPos >= 0L ? 1 : 0) != 0, (String)"position is negative: %s", (long)newPos);
        this.next = newPos;
    }

    public int read() throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot read: already closed");
        this.positionStream();
        ++this.pos;
        ++this.next;
        this.readBytes.increment();
        this.readOperations.increment();
        return this.stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot read: already closed");
        this.positionStream();
        int bytesRead = this.stream.read(b, off, len);
        this.pos += (long)bytesRead;
        this.next += (long)bytesRead;
        this.readBytes.increment(bytesRead);
        this.readOperations.increment();
        return bytesRead;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        String range = String.format("bytes=%s-%s", position, position + (long)length - 1L);
        IOUtil.readFully((InputStream)this.readRange(range), (byte[])buffer, (int)offset, (int)length);
    }

    public int readTail(byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        String range = String.format("bytes=-%s", length);
        return IOUtil.readRemaining((InputStream)this.readRange(range), (byte[])buffer, (int)offset, (int)length);
    }

    private InputStream readRange(String range) {
        GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder().bucket(this.location.bucket()).key(this.location.key()).range(range);
        S3RequestUtil.configureEncryption(this.awsProperties, requestBuilder);
        return (InputStream)this.s3.getObject((GetObjectRequest)requestBuilder.build(), ResponseTransformer.toInputStream());
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
        this.closeStream();
    }

    private void positionStream() throws IOException {
        long skip;
        if (this.stream != null && this.next == this.pos) {
            return;
        }
        if (this.stream != null && this.next > this.pos && (skip = this.next - this.pos) <= (long)Math.max(this.stream.available(), this.skipSize)) {
            LOG.debug("Read-through seek for {} to offset {}", (Object)this.location, (Object)this.next);
            try {
                ByteStreams.skipFully((InputStream)this.stream, (long)skip);
                this.pos = this.next;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.debug("Seek with new stream for {} to offset {}", (Object)this.location, (Object)this.next);
        this.pos = this.next;
        this.openStream();
    }

    private void openStream() throws IOException {
        GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder().bucket(this.location.bucket()).key(this.location.key()).range(String.format("bytes=%s-", this.pos));
        S3RequestUtil.configureEncryption(this.awsProperties, requestBuilder);
        this.closeStream();
        try {
            this.stream = (InputStream)this.s3.getObject((GetObjectRequest)requestBuilder.build(), ResponseTransformer.toInputStream());
        }
        catch (NoSuchKeyException e) {
            throw new NotFoundException((Throwable)e, "Location does not exist: %s", new Object[]{this.location});
        }
    }

    private void closeStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public void setSkipSize(int skipSize) {
        this.skipSize = skipSize;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
        }
    }
}

