/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Locale;
import java.util.function.Function;
import org.apache.iceberg.aws.AwsProperties;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class S3RequestUtil {
    private static final Function<ServerSideEncryption, S3Request.Builder> NULL_SSE_SETTER = sse -> null;
    private static final Function<String, S3Request.Builder> NULL_STRING_SETTER = s -> null;

    private S3RequestUtil() {
    }

    static void configureEncryption(AwsProperties awsProperties, PutObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(awsProperties, arg_0 -> ((PutObjectRequest.Builder)requestBuilder).serverSideEncryption(arg_0), arg_0 -> ((PutObjectRequest.Builder)requestBuilder).ssekmsKeyId(arg_0), arg_0 -> ((PutObjectRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((PutObjectRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((PutObjectRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(AwsProperties awsProperties, CreateMultipartUploadRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(awsProperties, arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).serverSideEncryption(arg_0), arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).ssekmsKeyId(arg_0), arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(AwsProperties awsProperties, UploadPartRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(awsProperties, NULL_SSE_SETTER, NULL_STRING_SETTER, arg_0 -> ((UploadPartRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((UploadPartRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((UploadPartRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(AwsProperties awsProperties, GetObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(awsProperties, NULL_SSE_SETTER, NULL_STRING_SETTER, arg_0 -> ((GetObjectRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((GetObjectRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((GetObjectRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(AwsProperties awsProperties, HeadObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(awsProperties, NULL_SSE_SETTER, NULL_STRING_SETTER, arg_0 -> ((HeadObjectRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((HeadObjectRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((HeadObjectRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(AwsProperties awsProperties, Function<ServerSideEncryption, S3Request.Builder> encryptionSetter, Function<String, S3Request.Builder> kmsKeySetter, Function<String, S3Request.Builder> customAlgorithmSetter, Function<String, S3Request.Builder> customKeySetter, Function<String, S3Request.Builder> customMd5Setter) {
        switch (awsProperties.s3FileIoSseType().toLowerCase(Locale.ENGLISH)) {
            case "none": {
                break;
            }
            case "kms": {
                encryptionSetter.apply(ServerSideEncryption.AWS_KMS);
                kmsKeySetter.apply(awsProperties.s3FileIoSseKey());
                break;
            }
            case "s3": {
                encryptionSetter.apply(ServerSideEncryption.AES256);
                break;
            }
            case "custom": {
                customAlgorithmSetter.apply(ServerSideEncryption.AES256.name());
                customKeySetter.apply(awsProperties.s3FileIoSseKey());
                customMd5Setter.apply(awsProperties.s3FileIoSseMd5());
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot support given S3 encryption type: " + awsProperties.s3FileIoSseType());
            }
        }
    }

    static void configurePermission(AwsProperties awsProperties, PutObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configurePermission(awsProperties, arg_0 -> ((PutObjectRequest.Builder)requestBuilder).acl(arg_0));
    }

    static void configurePermission(AwsProperties awsProperties, CreateMultipartUploadRequest.Builder requestBuilder) {
        S3RequestUtil.configurePermission(awsProperties, arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).acl(arg_0));
    }

    static void configurePermission(AwsProperties awsProperties, Function<ObjectCannedACL, S3Request.Builder> aclSetter) {
        aclSetter.apply(awsProperties.s3FileIoAcl());
    }
}

