/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.aws.s3.signer.S3SignRequest;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3SignRequest", generator="Immutables")
@Immutable
public final class ImmutableS3SignRequest
implements S3SignRequest {
    private final String region;
    private final String method;
    private final URI uri;
    private final Map<String, List<String>> headers;
    private final Map<String, String> properties;

    private ImmutableS3SignRequest(String region, String method, URI uri, Map<String, List<String>> headers, Map<String, String> properties) {
        this.region = region;
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.properties = properties;
    }

    @Override
    public String region() {
        return this.region;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public final ImmutableS3SignRequest withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableS3SignRequest(newValue, this.method, this.uri, this.headers, this.properties);
    }

    public final ImmutableS3SignRequest withMethod(String value) {
        String newValue = Objects.requireNonNull(value, "method");
        if (this.method.equals(newValue)) {
            return this;
        }
        return new ImmutableS3SignRequest(this.region, newValue, this.uri, this.headers, this.properties);
    }

    public final ImmutableS3SignRequest withUri(URI value) {
        if (this.uri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "uri");
        return new ImmutableS3SignRequest(this.region, this.method, newValue, this.headers, this.properties);
    }

    public final ImmutableS3SignRequest withHeaders(Map<String, ? extends List<String>> entries) {
        if (this.headers == entries) {
            return this;
        }
        Map<String, List<String>> newValue = ImmutableS3SignRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableS3SignRequest(this.region, this.method, this.uri, newValue, this.properties);
    }

    public final ImmutableS3SignRequest withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableS3SignRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableS3SignRequest(this.region, this.method, this.uri, this.headers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3SignRequest && this.equalTo(0, (ImmutableS3SignRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableS3SignRequest another) {
        return this.region.equals(another.region) && this.method.equals(another.method) && this.uri.equals(another.uri) && this.headers.equals(another.headers) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.region.hashCode();
        h += (h << 5) + this.method.hashCode();
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + this.headers.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "S3SignRequest{region=" + this.region + ", method=" + this.method + ", uri=" + this.uri + ", headers=" + this.headers + ", properties=" + this.properties + "}";
    }

    public static ImmutableS3SignRequest copyOf(S3SignRequest instance) {
        if (instance instanceof ImmutableS3SignRequest) {
            return (ImmutableS3SignRequest)instance;
        }
        return ImmutableS3SignRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="S3SignRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REGION = 1L;
        private static final long INIT_BIT_METHOD = 2L;
        private static final long INIT_BIT_URI = 4L;
        private long initBits = 7L;
        @Nullable
        private String region;
        @Nullable
        private String method;
        @Nullable
        private URI uri;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3SignRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.region(instance.region());
            this.method(instance.method());
            this.uri(instance.uri());
            this.putAllHeaders(instance.headers());
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder method(String method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(String key, List<String> value) {
            this.headers.put(Objects.requireNonNull(key, "headers key"), value == null ? Objects.requireNonNull(value, "headers value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(Map.Entry<String, ? extends List<String>> entry) {
            List<String> v;
            String k = entry.getKey();
            this.headers.put(Objects.requireNonNull(k, "headers key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headers(Map<String, ? extends List<String>> entries) {
            this.headers.clear();
            return this.putAllHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHeaders(Map<String, ? extends List<String>> entries) {
            for (Map.Entry<String, ? extends List<String>> e : entries.entrySet()) {
                List<String> v;
                String k = e.getKey();
                this.headers.put(Objects.requireNonNull(k, "headers key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "headers value for key: " + k) : v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), value == null ? Objects.requireNonNull(value, "properties value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.properties.put(Objects.requireNonNull(k, "properties key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.properties.put(Objects.requireNonNull(k, "properties key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableS3SignRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableS3SignRequest(this.region, this.method, this.uri, ImmutableS3SignRequest.createUnmodifiableMap(false, false, this.headers), ImmutableS3SignRequest.createUnmodifiableMap(false, false, this.properties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("region");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("method");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build S3SignRequest, some of required attributes are not set " + attributes;
        }
    }
}

