/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.ReflectionSerializable;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.rest.ErrorOptions;
import com.azure.core.implementation.http.rest.RequestDataConfiguration;
import com.azure.core.implementation.http.rest.RestProxyBase;
import com.azure.core.implementation.http.rest.RestProxyUtils;
import com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.json.JsonSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public class AsyncRestProxy
extends RestProxyBase {
    private static final String TEXT_EVENT_STREAM = "text/event-stream";

    public AsyncRestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        super(httpPipeline, serializer, interfaceParser);
    }

    Mono<HttpResponse> send(HttpRequest request, com.azure.core.util.Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, RequestOptions options, EnumSet<ErrorOptions> errorOptions, Consumer<HttpRequest> requestCallback, SwaggerMethodParser methodParser, HttpRequest request, com.azure.core.util.Context context) {
        RestProxyUtils.validateResumeOperationIsNotPresent(method);
        context = this.startTracingSpan(methodParser, context);
        if (options != null && requestCallback != null) {
            requestCallback.accept(request);
        }
        com.azure.core.util.Context finalContext = context;
        Mono<HttpResponse> asyncResponse = RestProxyUtils.validateLengthAsync(request).flatMap(r -> {
            Mono<HttpResponse> mono;
            block8: {
                AutoCloseable scope = this.tracer.makeSpanCurrent(finalContext);
                try {
                    mono = this.send((HttpRequest)r, finalContext);
                    if (scope == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        return Mono.error(ex);
                    }
                }
                scope.close();
            }
            return mono;
        });
        Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse = this.decoder.decode(asyncResponse, methodParser);
        return this.handleRestReturnType(asyncDecodedResponse, methodParser, methodParser.getReturnType(), context, options, errorOptions);
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse, SwaggerMethodParser methodParser, RequestOptions options, EnumSet<ErrorOptions> errorOptions) {
        return asyncDecodedResponse.flatMap(decodedResponse -> {
            int responseStatusCode = decodedResponse.getSourceResponse().getStatusCode();
            if (methodParser.isExpectedResponseStatusCode(responseStatusCode) || options != null && errorOptions.contains((Object)ErrorOptions.NO_THROW)) {
                return Mono.just(decodedResponse);
            }
            return decodedResponse.getSourceResponse().getBodyAsByteArray().map(bytes -> AsyncRestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), bytes, decodedResponse.getDecodedBody((byte[])bytes))).switchIfEmpty(Mono.fromSupplier(() -> AsyncRestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), null, null))).flatMap(Mono::error);
        });
    }

    private Mono<?> handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        if (methodParser.isStreamResponse()) {
            return Mono.fromSupplier(() -> new StreamResponse(response.getSourceResponse()));
        }
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Response.class)) {
            Type bodyType = TypeUtil.getRestResponseBodyType(entityType);
            if (TypeUtil.isTypeOrSubTypeOf(bodyType, Void.class)) {
                return response.getSourceResponse().getBody().ignoreElements().then(Mono.fromCallable(() -> this.createResponse(response, entityType, null)));
            }
            return AsyncRestProxy.handleBodyReturnType(response.getSourceResponse(), AsyncRestProxy.decodeBytes(response), methodParser, bodyType).map(bodyAsObject -> this.createResponse(response, entityType, bodyAsObject)).switchIfEmpty(Mono.fromCallable(() -> this.createResponse(response, entityType, null)));
        }
        return AsyncRestProxy.handleBodyReturnType(response.getSourceResponse(), AsyncRestProxy.decodeBytes(response), methodParser, entityType);
    }

    private static Function<byte[], Mono<Object>> decodeBytes(HttpResponseDecoder.HttpDecodedResponse response) {
        return bytes -> Mono.fromCallable(() -> response.getDecodedBody((byte[])bytes)).publishOn(Schedulers.boundedElastic()).handle((object, sink) -> {
            if (object == null) {
                sink.complete();
            } else {
                sink.next(object);
                sink.complete();
            }
        });
    }

    static Mono<?> handleBodyReturnType(HttpResponse sourceResponse, Function<byte[], Mono<Object>> getDecodedBody, SwaggerMethodParser methodParser, Type entityType) {
        Mono<Object> asyncResult;
        int responseStatusCode = sourceResponse.getStatusCode();
        HttpMethod httpMethod = methodParser.getHttpMethod();
        Type returnValueWireType = methodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            boolean isSuccess = responseStatusCode / 100 == 2;
            asyncResult = Mono.just(isSuccess);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            Mono<byte[]> responseBodyBytesAsync = sourceResponse.getBodyAsByteArray();
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytesAsync = responseBodyBytesAsync.mapNotNull(base64UrlBytes -> new Base64Url((byte[])base64UrlBytes).decodedBytes());
            }
            asyncResult = responseBodyBytesAsync;
        } else {
            String contentType;
            asyncResult = FluxUtil.isFluxByteBuffer(entityType) ? Mono.just(sourceResponse.getBody()) : (TypeUtil.isTypeOrSubTypeOf(entityType, BinaryData.class) ? (TEXT_EVENT_STREAM.equals(contentType = sourceResponse.getHeaders().getValue(HttpHeaderName.CONTENT_TYPE)) ? BinaryData.fromFlux(sourceResponse.getBody(), null, false) : BinaryData.fromFlux(sourceResponse.getBody())) : (TypeUtil.isTypeOrSubTypeOf(entityType, InputStream.class) ? sourceResponse.getBodyAsInputStream() : sourceResponse.getBodyAsByteArray().flatMap(getDecodedBody)));
        }
        return asyncResult;
    }

    private Object handleRestReturnType(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncHttpDecodedResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context, RequestOptions options, EnumSet<ErrorOptions> errorOptionsSet) {
        CorePublisher<Object> result;
        Mono<HttpResponseDecoder.HttpDecodedResponse> asyncExpectedResponse = this.endSpanWhenDone(this.ensureExpectedStatus(asyncHttpDecodedResponse, methodParser, options, errorOptionsSet), context);
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            Type monoTypeParam = TypeUtil.getTypeArgument(returnType);
            result = TypeUtil.isTypeOrSubTypeOf(monoTypeParam, Void.class) ? asyncExpectedResponse.doOnNext(HttpResponseDecoder.HttpDecodedResponse::close).then() : asyncExpectedResponse.flatMap(response -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)response, methodParser, monoTypeParam));
        } else if (FluxUtil.isFluxByteBuffer(returnType)) {
            result = asyncExpectedResponse.flatMapMany(ar -> ar.getSourceResponse().getBody());
        } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            asyncExpectedResponse.doOnNext(HttpResponseDecoder.HttpDecodedResponse::close).block();
            result = null;
        } else {
            result = asyncExpectedResponse.flatMap(httpResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpResponse, methodParser, returnType)).block();
        }
        return result;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> endSpanWhenDone(Mono<HttpResponseDecoder.HttpDecodedResponse> getResponse, com.azure.core.util.Context span) {
        if (this.isTracingEnabled(span)) {
            return getResponse.doOnEach(signal -> {
                if (signal.hasValue()) {
                    int statusCode = ((HttpResponseDecoder.HttpDecodedResponse)signal.get()).getSourceResponse().getStatusCode();
                    this.tracer.end(statusCode >= 400 ? "" : null, null, span);
                } else if (signal.isOnError()) {
                    this.tracer.end(null, signal.getThrowable(), span);
                }
            }).doOnCancel(() -> this.tracer.end("cancel", null, span)).contextWrite(Context.of("TRACING_CONTEXT", span));
        }
        return getResponse;
    }

    @Override
    public void updateRequest(RequestDataConfiguration requestDataConfiguration, SerializerAdapter serializerAdapter) throws IOException {
        boolean isJson = requestDataConfiguration.isJson();
        HttpRequest request = requestDataConfiguration.getHttpRequest();
        Object bodyContentObject = requestDataConfiguration.getBodyContent();
        SwaggerMethodParser methodParser = requestDataConfiguration.getMethodParser();
        if (bodyContentObject == null) {
            return;
        }
        if (AsyncRestProxy.supportsJsonSerializable(bodyContentObject.getClass())) {
            request.setBody(ReflectionSerializable.serializeJsonSerializableToBytes((JsonSerializable)bodyContentObject));
            return;
        }
        if (AsyncRestProxy.supportsXmlSerializable(bodyContentObject.getClass())) {
            request.setBody(BinaryData.fromByteBuffer(AsyncRestProxy.serializeAsXmlSerializable(bodyContentObject)));
            return;
        }
        if (isJson) {
            request.setBody(serializerAdapter.serializeToBytes(bodyContentObject, SerializerEncoding.JSON));
        } else if (FluxUtil.isFluxByteBuffer(methodParser.getBodyJavaType())) {
            request.setBody((Flux)bodyContentObject);
        } else if (bodyContentObject instanceof byte[]) {
            request.setBody((byte[])bodyContentObject);
        } else if (bodyContentObject instanceof String) {
            String bodyContentString = (String)bodyContentObject;
            if (!bodyContentString.isEmpty()) {
                request.setBody(bodyContentString);
            }
        } else if (bodyContentObject instanceof ByteBuffer) {
            request.setBody(Flux.just((ByteBuffer)bodyContentObject));
        } else {
            request.setBody(serializerAdapter.serializeToBytes(bodyContentObject, SerializerEncoding.fromHeaders(request.getHeaders())));
        }
    }
}

