/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.JacksonJsonWriter;
import com.azure.json.JsonSerializable;
import java.io.IOException;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.Module;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

final class JsonSerializableSerializer
extends JsonSerializer<JsonSerializable> {
    private static final Module MODULE = new SimpleModule().addSerializer(JsonSerializable.class, new JsonSerializableSerializer());

    JsonSerializableSerializer() {
    }

    public static Module getModule() {
        return MODULE;
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        new JacksonJsonWriter(gen).writeJson(value);
    }

    @Override
    public Class<JsonSerializable> handledType() {
        return JsonSerializable.class;
    }
}

