/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakePathClientBuilder.class)
public class DataLakeDirectoryClient
extends DataLakePathClient {
    private final DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;

    DataLakeDirectoryClient(DataLakeDirectoryAsyncClient pathAsyncClient, BlockBlobClient blockBlobClient) {
        super(pathAsyncClient, blockBlobClient);
        this.dataLakeDirectoryAsyncClient = pathAsyncClient;
    }

    private DataLakeDirectoryClient(DataLakePathClient dataLakePathClient) {
        super(dataLakePathClient.dataLakePathAsyncClient, dataLakePathClient.blockBlobClient);
        this.dataLakeDirectoryAsyncClient = new DataLakeDirectoryAsyncClient(dataLakePathClient.dataLakePathAsyncClient);
    }

    public String getDirectoryUrl() {
        return this.getPathUrl();
    }

    public String getDirectoryPath() {
        return this.getObjectPath();
    }

    public String getDirectoryName() {
        return this.getObjectName();
    }

    @Override
    public DataLakeDirectoryClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.blockBlobClient.getCustomerProvidedKeyClient(Transforms.toBlobCustomerProvidedKey(customerProvidedKey)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(false, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRecursively() {
        this.deleteRecursivelyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRecursivelyWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.deleteWithResponse(true, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.dataLakePathAsyncClient.deleteWithResponse(recursive, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.dataLakePathAsyncClient.deleteIfExistsWithResponse(options, context), timeout);
    }

    public DataLakeFileClient getFileClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        return new DataLakeFileClient(this.dataLakeDirectoryAsyncClient.getFileAsyncClient(fileName), this.dataLakeDirectoryAsyncClient.prepareBuilderAppendPath(fileName).buildBlockBlobClient());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createFileWithResponse(fileName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createFileWithResponse(fileName, options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createWithResponse(options, timeout, context);
        return new SimpleResponse<DataLakeFileClient>(response, dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFileIfNotExists(String fileName) {
        return this.createFileIfNotExistsWithResponse(fileName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileIfNotExistsWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = StorageImplUtils.blockWithOptionalTimeout(dataLakeFileClient.dataLakePathAsyncClient.createIfNotExistsWithResponse(options, context), timeout);
        return new SimpleResponse<DataLakeFileClient>(response, dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return this.deleteFileIfExistsWithResponse(fileName, new DataLakePathDeleteOptions().setRequestConditions(new DataLakeRequestConditions()), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.dataLakeDirectoryAsyncClient.deleteFileIfExistsWithResponse(fileName, options, context), timeout);
    }

    public DataLakeDirectoryClient getSubdirectoryClient(String subdirectoryName) {
        Objects.requireNonNull(subdirectoryName, "'subdirectoryName' can not be set to null");
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getSubdirectoryAsyncClient(subdirectoryName), this.dataLakeDirectoryAsyncClient.prepareBuilderAppendPath(subdirectoryName).buildBlockBlobClient());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName) {
        return this.createSubdirectory(subdirectoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createSubdirectoryWithResponse(subdirectoryName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createSubdirectoryWithResponse(subdirectoryName, options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createWithResponse(options, timeout, context);
        return new SimpleResponse<DataLakeDirectoryClient>(response, dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectoryIfNotExists(String subdirectoryName) {
        return this.createSubdirectoryIfNotExistsWithResponse(subdirectoryName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryIfNotExistsWithResponse(String subdirectoryName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse<DataLakeDirectoryClient>(response, dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubdirectory(String subdirectoryName) {
        this.deleteSubdirectoryWithResponse(subdirectoryName, false, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubdirectoryWithResponse(String subdirectoryName, boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return dataLakeDirectoryClient.deleteWithResponse(recursive, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteSubdirectoryIfExists(String subdirectoryName) {
        return this.deleteSubdirectoryIfExistsWithResponse(subdirectoryName, new DataLakePathDeleteOptions().setIsRecursive(false).setRequestConditions(new DataLakeRequestConditions()), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteSubdirectoryIfExistsWithResponse(String subdirectoryName, DataLakePathDeleteOptions options, Duration timeout, Context context) {
        DataLakeDirectoryAsyncClient dataLakeDirectoryClient = this.dataLakeDirectoryAsyncClient.getSubdirectoryAsyncClient(subdirectoryName);
        return StorageImplUtils.blockWithOptionalTimeout(dataLakeDirectoryClient.deleteIfExistsWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient rename(String destinationFileSystem, String destinationPath) {
        return this.renameWithResponse(destinationFileSystem, destinationPath, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout, Context context) {
        Mono<Response> response = this.dataLakeDirectoryAsyncClient.renameWithResponse(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, context).map(asyncResponse -> new SimpleResponse<DataLakeDirectoryClient>(asyncResponse.getRequest(), asyncResponse.getStatusCode(), asyncResponse.getHeaders(), new DataLakeDirectoryClient(new DataLakeDirectoryAsyncClient((DataLakePathAsyncClient)asyncResponse.getValue()), new SpecializedBlobClientBuilder().blobAsyncClient(((DataLakePathAsyncClient)asyncResponse.getValue()).blockBlobAsyncClient).buildBlockBlobClient())));
        Response resp = StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        return new SimpleResponse<DataLakeDirectoryClient>(resp, new DataLakeDirectoryClient((DataLakePathClient)resp.getValue()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths() {
        return this.listPaths(false, false, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths(boolean recursive, boolean userPrincipleNameReturned, Integer maxResults, Duration timeout) {
        return new PagedIterable<PathItem>(this.dataLakeDirectoryAsyncClient.listPathsWithOptionalTimeout(recursive, userPrincipleNameReturned, maxResults, timeout));
    }
}

