/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema;

import com.azure.storage.internal.avro.implementation.AvroConstants;
import com.azure.storage.internal.avro.implementation.schema.AvroRecordField;
import java.util.LinkedList;
import java.util.List;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.node.JsonNodeType;

public class AvroType {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String type;

    AvroType(String type) {
        this.type = type;
    }

    String getType() {
        return this.type;
    }

    public static AvroType getType(String jsonString) {
        JsonNode schemaJson;
        try {
            schemaJson = MAPPER.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return AvroType.getType(schemaJson);
    }

    private static AvroType getType(JsonNode jsonSchema) {
        JsonNodeType nodeType = jsonSchema.getNodeType();
        switch (nodeType) {
            case STRING: {
                return AvroType.getJsonStringType(jsonSchema);
            }
            case ARRAY: {
                return AvroType.getJsonArrayType(jsonSchema);
            }
            case OBJECT: {
                return AvroType.getJsonObjectType(jsonSchema);
            }
        }
        throw new RuntimeException("Unsupported type");
    }

    private static AvroType getJsonStringType(JsonNode jsonSchema) {
        String type = jsonSchema.asText();
        if (AvroConstants.Types.PRIMITIVE_TYPES.contains(type)) {
            return new AvroPrimitiveType(type);
        }
        throw new RuntimeException("Unsupported type");
    }

    private static AvroType getJsonArrayType(JsonNode jsonSchema) {
        List<AvroType> types = AvroType.getUnionTypes(jsonSchema);
        return new AvroUnionType(types);
    }

    private static AvroType getJsonObjectType(JsonNode jsonSchema) {
        String type;
        switch (type = jsonSchema.get("type").asText()) {
            case "null": 
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "bytes": 
            case "string": {
                return new AvroPrimitiveType(type);
            }
            case "record": {
                if (jsonSchema.get("aliases") != null) {
                    throw new IllegalArgumentException("Unexpected aliases in schema.");
                }
                String fullName = jsonSchema.get("name").asText();
                String name = fullName.substring(fullName.lastIndexOf(46) + 1);
                List<AvroRecordField> fields = AvroType.getRecordFields(jsonSchema.withArray("fields"));
                return new AvroRecordType(name, fields);
            }
            case "enum": {
                if (jsonSchema.get("aliases") != null) {
                    throw new IllegalArgumentException("Unexpected aliases in schema.");
                }
                String name = jsonSchema.get("name").asText();
                List<String> symbols = AvroType.getEnumSymbols(jsonSchema.withArray("symbols"));
                return new AvroEnumType(name, symbols);
            }
            case "array": {
                AvroType items = AvroType.getType(jsonSchema.get("items"));
                return new AvroArrayType(items);
            }
            case "map": {
                AvroType values = AvroType.getType(jsonSchema.get("values"));
                return new AvroMapType(values);
            }
            case "fixed": {
                Long size = jsonSchema.get("size").asLong();
                return new AvroFixedType(size);
            }
        }
        throw new RuntimeException("Unsupported type");
    }

    private static List<AvroType> getUnionTypes(JsonNode parent) {
        LinkedList<AvroType> types = new LinkedList<AvroType>();
        for (JsonNode child : parent) {
            AvroType type = AvroType.getType(child);
            types.add(type);
        }
        return types;
    }

    private static List<String> getEnumSymbols(JsonNode parent) {
        LinkedList<String> symbols = new LinkedList<String>();
        for (JsonNode child : parent) {
            symbols.add(child.asText());
        }
        return symbols;
    }

    private static List<AvroRecordField> getRecordFields(JsonNode parent) {
        LinkedList<AvroRecordField> fields = new LinkedList<AvroRecordField>();
        for (JsonNode child : parent) {
            String name = child.get("name").asText();
            AvroType type = AvroType.getType(child.get("type"));
            fields.add(new AvroRecordField(name, type));
        }
        return fields;
    }

    static class AvroPrimitiveType
    extends AvroType {
        AvroPrimitiveType(String type) {
            super(type);
        }
    }

    static class AvroUnionType
    extends AvroType {
        private final List<AvroType> types;

        AvroUnionType(List<AvroType> types) {
            super("union");
            this.types = types;
        }

        List<AvroType> getTypes() {
            return this.types;
        }
    }

    static class AvroRecordType
    extends AvroType {
        private final String name;
        private final List<AvroRecordField> fields;

        AvroRecordType(String name, List<AvroRecordField> fields) {
            super("record");
            this.name = name;
            this.fields = fields;
        }

        String getName() {
            return this.name;
        }

        List<AvroRecordField> getFields() {
            return this.fields;
        }
    }

    static class AvroEnumType
    extends AvroType {
        private final String name;
        private final List<String> symbols;

        AvroEnumType(String name, List<String> symbols) {
            super("enum");
            this.name = name;
            this.symbols = symbols;
        }

        String getName() {
            return this.name;
        }

        List<String> getSymbols() {
            return this.symbols;
        }
    }

    static class AvroArrayType
    extends AvroType {
        private final AvroType itemType;

        AvroArrayType(AvroType itemType) {
            super("array");
            this.itemType = itemType;
        }

        AvroType getItemType() {
            return this.itemType;
        }
    }

    static class AvroMapType
    extends AvroType {
        private final AvroType valueType;

        AvroMapType(AvroType valueType) {
            super("map");
            this.valueType = valueType;
        }

        AvroType getValueType() {
            return this.valueType;
        }
    }

    static class AvroFixedType
    extends AvroType {
        private final Long size;

        AvroFixedType(Long size) {
            super("fixed");
            this.size = size;
        }

        Long getSize() {
            return this.size;
        }
    }
}

