/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.shaded.io.netty.handler.codec.marshalling;

import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandler;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.MessageToByteEncoder;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.marshalling.MarshallerProvider;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

@ChannelHandler.Sharable
public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider provider) {
        this.provider = provider;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        int lengthPos = out.writerIndex();
        out.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput output = new ChannelBufferByteOutput(out);
        marshaller.start((ByteOutput)output);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        out.setInt(lengthPos, out.writerIndex() - lengthPos - 4);
    }
}

