/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelDuplexHandler;
import reactor.netty.http.server.HttpServerInfos;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.util.annotation.Nullable;

class BaseAccessLogHandler
extends ChannelDuplexHandler {
    static final String DEFAULT_LOG_FORMAT = "{} - {} [{}] \"{} {} {}\" {} {} {}";
    static final Function<AccessLogArgProvider, AccessLog> DEFAULT_ACCESS_LOG = args -> AccessLog.create(DEFAULT_LOG_FORMAT, BaseAccessLogHandler.applyAddress(args.remoteAddress()), args.user(), args.zonedDateTime(), args.method(), args.uri(), args.protocol(), args.status(), args.contentLength() > -1L ? Long.valueOf(args.contentLength()) : "-", args.duration());
    final Function<AccessLogArgProvider, AccessLog> accessLog;

    BaseAccessLogHandler(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        this.accessLog = accessLog == null ? DEFAULT_ACCESS_LOG : accessLog;
    }

    static String applyAddress(@Nullable SocketAddress socketAddress) {
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : "-";
    }

    final <T extends AbstractAccessLogArgProvider<T>> void applyServerInfos(AbstractAccessLogArgProvider<T> accessLogArgs, HttpServerInfos serverInfos) {
        accessLogArgs.cookies(serverInfos.cookies());
        accessLogArgs.connectionInformation(serverInfos);
    }
}

