/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import reactor.core.Exceptions;

final class HttpResponseHeaderDecoder {
    private static final String MALFORMED_HEADERS_MESSAGE = "HTTP response has malformed headers";

    HttpResponseHeaderDecoder() {
    }

    static Object decode(HttpResponse response, SerializerAdapter serializer, Type decodedHeadersType) {
        if (decodedHeadersType == null) {
            return null;
        }
        try {
            return serializer.deserialize(response.getHeaders(), decodedHeadersType);
        }
        catch (IOException ex) {
            throw Exceptions.propagate(new HttpResponseException(MALFORMED_HEADERS_MESSAGE, response, ex));
        }
    }
}

